/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.declarative.impl;

import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayRenderer;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayEditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "()V", "isControlDown", "", "e", "Ljava/awt/event/MouseEvent;", "mouseClicked", "", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.platform.lang.impl"})
public final class DeclarativeInlayEditorMouseListener
implements EditorMouseListener {
    public void mouseClicked(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        MouseEvent mouseEvent = e.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"e.mouseEvent");
        MouseEvent event = mouseEvent;
        if (!Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.EDITING_AREA)) {
            return;
        }
        Inlay inlay = e.getInlay();
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"inlay.renderer");
        EditorCustomElementRenderer renderer = editorCustomElementRenderer;
        if (!(renderer instanceof DeclarativeInlayRenderer)) {
            return;
        }
        Rectangle rectangle = inlay2.getBounds();
        if (rectangle == null) {
            return;
        }
        Rectangle bounds = rectangle;
        Point inlayPoint = new Point(bounds.x, bounds.y);
        Point translated = new Point(event.getX() - inlayPoint.x, event.getY() - inlayPoint.y);
        if (SwingUtilities.isRightMouseButton(event) && !SwingUtilities.isLeftMouseButton(event)) {
            ((DeclarativeInlayRenderer)renderer).handleRightClick(e);
            return;
        }
        boolean controlDown = this.isControlDown(event);
        ((DeclarativeInlayRenderer)renderer).handleLeftClick(e, translated, controlDown);
        inlay2.update();
    }

    private final boolean isControlDown(MouseEvent e) {
        return SystemInfo.isMac && e.isMetaDown() || e.isControlDown();
    }
}

