/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.declarative.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.hints.declarative.DeclarativeInlayHintsSettings;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayHintsProviderFactory;
import com.intellij.codeInsight.hints.declarative.InlayOptionInfo;
import com.intellij.codeInsight.hints.declarative.InlayProviderInfo;
import com.intellij.codeInsight.hints.declarative.InlayProviderPassInfo;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPass;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "createHighlightingPass", "Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDeclarativeInlayHintsPassFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeInlayHintsPassFactory.kt\ncom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPassFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n766#2:85\n857#2,2:86\n1549#2:88\n1620#2,3:89\n1#3:92\n*S KotlinDebug\n*F\n+ 1 DeclarativeInlayHintsPassFactory.kt\ncom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPassFactory\n*L\n62#1:85\n62#1:86,2\n65#1:88\n65#1:89,3\n*E\n"})
public final class DeclarativeInlayHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Long> PSI_MODIFICATION_STAMP = new Key("declarative.inlays.psi.modification.stamp");

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DeclarativeInlayHintsPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        InlayProviderInfo it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        long current;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!Registry.is("inlays.declarative.hints")) {
            return null;
        }
        if (editor2.isOneLineMode()) {
            return null;
        }
        if (!HighlightingLevelManager.getInstance(file2.getProject()).shouldHighlight(file2)) {
            return null;
        }
        Long stamp = (Long)editor2.getUserData(PSI_MODIFICATION_STAMP);
        Long l = stamp;
        if (l != null && (current = DeclarativeInlayHintsPassFactory.Companion.getCurrentModificationCount(file2)) == l) {
            return null;
        }
        DeclarativeInlayHintsSettings declarativeInlayHintsSettings = DeclarativeInlayHintsSettings.Companion.getInstance();
        Iterable iterable = Companion.getSuitableToFileProviders(file2);
        boolean $i$f$filter = false;
        void var10_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InlayProviderInfo)element$iv$iv;
            boolean bl = false;
            Boolean bl2 = declarativeInlayHintsSettings.isProviderEnabled(it.getProviderId());
            if (!(bl2 != null ? bl2.booleanValue() : it.isEnabledByDefault())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InlayProviderInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HashMap<String, Boolean> optionsToEnabled = new HashMap<String, Boolean>();
            for (InlayOptionInfo optionInfo : it.getOptions()) {
                Boolean bl3 = declarativeInlayHintsSettings.isOptionEnabled(optionInfo.getId(), it.getProviderId());
                boolean isOptionEnabled = bl3 != null ? bl3.booleanValue() : optionInfo.isEnabledByDefault();
                if (optionsToEnabled.put(optionInfo.getId(), isOptionEnabled) == null) continue;
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            collection.add(new InlayProviderPassInfo(it.getProvider(), it.getProviderId(), (Map<String, Boolean>)optionsToEnabled));
        }
        List passProviders = (List)destination$iv$iv;
        return new DeclarativeInlayHintsPass(file2, editor2, passProviders, false, false, 16, null);
    }

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int[] nArray = new int[]{4};
        int[] it = nArray;
        boolean bl = false;
        int[] ghl = (int[])(((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses() ? nArray : null);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, ghl, null, false, -1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPassFactory$Companion;", "", "()V", "PSI_MODIFICATION_STAMP", "Lcom/intellij/openapi/util/Key;", "", "createPassForPreview", "Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "provider", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "providerId", "", "optionsToEnabled", "", "", "isDisabled", "getCurrentModificationCount", "getSuitableToFileProviders", "", "Lcom/intellij/codeInsight/hints/declarative/InlayProviderInfo;", "scheduleRecompute", "", "project", "Lcom/intellij/openapi/project/Project;", "updateModificationStamp", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @NotNull
        public final DeclarativeInlayHintsPass createPassForPreview(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull InlayHintsProvider provider2, @NotNull String providerId, @NotNull Map<String, Boolean> optionsToEnabled, boolean isDisabled) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter(optionsToEnabled, (String)"optionsToEnabled");
            return new DeclarativeInlayHintsPass(file2, editor2, CollectionsKt.listOf((Object)new InlayProviderPassInfo(provider2, providerId, optionsToEnabled)), true, isDisabled);
        }

        @NotNull
        public final List<InlayProviderInfo> getSuitableToFileProviders(@NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Language language = file2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
            return InlayHintsProviderFactory.Companion.getProvidersForLanguage(language);
        }

        public final void updateModificationStamp(@NotNull Editor editor2, @NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            editor2.putUserData(PSI_MODIFICATION_STAMP, (Object)this.getCurrentModificationCount(file2));
        }

        public final void scheduleRecompute(@NotNull Editor editor2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            editor2.putUserData(PSI_MODIFICATION_STAMP, null);
            DaemonCodeAnalyzer.getInstance(project2).restart();
        }

        private final long getCurrentModificationCount(PsiFile file2) {
            return file2.getManager().getModificationTracker().getModificationCount();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

