/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.declarative.impl;

import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayHintsProviderFactory;
import com.intellij.codeInsight.hints.declarative.InlayProviderInfo;
import com.intellij.codeInsight.hints.declarative.impl.InlayMouseArea;
import com.intellij.codeInsight.hints.declarative.impl.InlayPresentationList;
import com.intellij.codeInsight.hints.declarative.impl.util.TinyTree;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0014\u0010\u0011\u001a\u00020\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J,\u0010\u001d\u001a\u00020\u00172\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nJ(\u0010%\u001a\u00020\u00172\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "presentationList", "Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationList;", "fontMetricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "providerId", "", "(Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationList;Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;Ljava/lang/String;)V", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getPresentationList", "()Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationList;", "getProviderId", "()Ljava/lang/String;", "calcWidthInPixels", "", "getContextMenuGroupId", "getMouseArea", "Lcom/intellij/codeInsight/hints/declarative/impl/InlayMouseArea;", "pointInsideInlay", "Ljava/awt/Point;", "handleLeftClick", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "controlDown", "", "handleRightClick", "paint", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "setInlay", "updateState", "newState", "Lcom/intellij/codeInsight/hints/declarative/impl/util/TinyTree;", "", "disabled", "hasBackground", "intellij.platform.lang.impl"})
public final class DeclarativeInlayRenderer
implements EditorCustomElementRenderer {
    @TestOnly
    @NotNull
    private final InlayPresentationList presentationList;
    @NotNull
    private final InlayTextMetricsStorage fontMetricsStorage;
    @NotNull
    private final String providerId;
    @Nullable
    private Inlay<DeclarativeInlayRenderer> inlay;

    public DeclarativeInlayRenderer(@NotNull InlayPresentationList presentationList, @NotNull InlayTextMetricsStorage fontMetricsStorage, @NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)presentationList, (String)"presentationList");
        Intrinsics.checkNotNullParameter((Object)fontMetricsStorage, (String)"fontMetricsStorage");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.presentationList = presentationList;
        this.fontMetricsStorage = fontMetricsStorage;
        this.providerId = providerId;
    }

    @NotNull
    public final InlayPresentationList getPresentationList() {
        return this.presentationList;
    }

    @NotNull
    public final String getProviderId() {
        return this.providerId;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.presentationList.getWidthInPixels(this.fontMetricsStorage);
    }

    @RequiresEdt
    public final void updateState(@NotNull TinyTree<Object> newState, boolean disabled, boolean hasBackground) {
        Intrinsics.checkNotNullParameter(newState, (String)"newState");
        this.presentationList.updateState(newState, disabled, hasBackground);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        this.presentationList.paint(inlay, g, targetRegion, textAttributes);
    }

    public final void handleLeftClick(@NotNull EditorMouseEvent e, @NotNull Point pointInsideInlay, boolean controlDown) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)pointInsideInlay, (String)"pointInsideInlay");
        this.presentationList.handleClick(e, pointInsideInlay, this.fontMetricsStorage, controlDown);
    }

    public final void handleRightClick(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getEditor().getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Document document = e.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"e.editor.document");
        Document document2 = document;
        PsiFile psiFile = PsiDocumentManager.getInstance(project3).getPsiFile(document2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"psiFile.language");
        InlayProviderInfo inlayProviderInfo = InlayHintsProviderFactory.Companion.getProviderInfo(language, this.providerId);
        if (inlayProviderInfo == null) {
            return;
        }
        InlayProviderInfo providerInfo = inlayProviderInfo;
        String providerName = providerInfo.getProviderName();
        AnAction anAction = ActionManager.getInstance().getAction("InlayMenu");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getInstance().getAction(\"InlayMenu\")");
        AnAction inlayMenu = anAction;
        ActionGroup inlayMenuActionGroup = (ActionGroup)inlayMenu;
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("InlayMenuPopup", inlayMenuActionGroup);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"getInstance().createActi\u2026p\", inlayMenuActionGroup)");
        ActionPopupMenu popupMenu = actionPopupMenu;
        DataContext dataContext2 = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project3).add(CommonDataKeys.PSI_FILE, (Object)psiFile2).add(CommonDataKeys.EDITOR, (Object)e.getEditor()).add(InlayHintsProvider.Companion.getPROVIDER_ID(), (Object)this.providerId).add(InlayHintsProvider.Companion.getPROVIDER_NAME(), (Object)providerName).add(InlayHintsProvider.Companion.getINLAY_PAYLOADS(), this.presentationList.getPayloads()).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"builder()\n      .add(Com\u2026.payloads)\n      .build()");
        DataContext dataContext3 = dataContext2;
        popupMenu.setDataContext(() -> DeclarativeInlayRenderer.handleRightClick$lambda$0(dataContext3));
        JBPopupMenu.showByEvent((MouseEvent)e.getMouseEvent(), (JPopupMenu)popupMenu.getComponent());
    }

    public final void setInlay(@NotNull Inlay<DeclarativeInlayRenderer> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.inlay = inlay;
    }

    @Nullable
    public final InlayMouseArea getMouseArea(@NotNull Point pointInsideInlay) {
        Intrinsics.checkNotNullParameter((Object)pointInsideInlay, (String)"pointInsideInlay");
        return this.presentationList.getMouseArea(pointInsideInlay, this.fontMetricsStorage);
    }

    @NotNull
    public String getContextMenuGroupId(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return "DummyActionGroup";
    }

    private static final DataContext handleRightClick$lambda$0(DataContext $dataContext) {
        Intrinsics.checkNotNullParameter((Object)$dataContext, (String)"$dataContext");
        return $dataContext;
    }
}

