/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.declarative.impl;

import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.impl.InlayMouseArea;
import com.intellij.codeInsight.hints.declarative.impl.InlayPresentationEntry;
import com.intellij.codeInsight.hints.declarative.impl.PresentationEntryBuilder;
import com.intellij.codeInsight.hints.declarative.impl.util.TinyTree;
import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\t\u0018\u0000 C2\u00020\u0001:\u0001CB=\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001fH\u0002J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u001fJ&\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u0005J*\u00100\u001a\u00020,2\n\u00101\u001a\u0006\u0012\u0002\b\u0003022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020;J(\u0010<\u001a\u00020,2\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0006\u0010=\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J8\u0010>\u001a\u00020,2\u000e\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0006\u0010A\u001a\u00020;2\u0006\u0010B\u001a\u00020;H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0015\"\u0004\b\u0018\u0010\u0017R(\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationList;", "", "state", "Lcom/intellij/codeInsight/hints/declarative/impl/util/TinyTree;", "hasBackground", "", "isDisabled", "payloads", "", "", "Lcom/intellij/codeInsight/hints/declarative/InlayActionPayload;", "(Lcom/intellij/codeInsight/hints/declarative/impl/util/TinyTree;ZZLjava/util/Map;)V", "_partialWidthSums", "", "computedWidth", "", "entries", "", "Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationEntry;", "[Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationEntry;", "getHasBackground", "()Z", "setHasBackground", "(Z)V", "setDisabled", "getPayloads", "()Ljava/util/Map;", "setPayloads", "(Ljava/util/Map;)V", "computePartialSums", "fontMetricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "findEntryByPoint", "pointInsideInlay", "Ljava/awt/Point;", "getEntries", "()[Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationEntry;", "getMouseArea", "Lcom/intellij/codeInsight/hints/declarative/impl/InlayMouseArea;", "getPartialWidthSums", "storage", "getWidthInPixels", "textMetricsStorage", "handleClick", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "controlDown", "paint", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toggleTreeState", "parentIndexToSwitch", "", "updateState", "disabled", "updateStateTree", "treeToUpdate", "treeToUpdateFrom", "treeToUpdateIndex", "treeToUpdateFromIndex", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nInlayPresentationList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayPresentationList.kt\ncom/intellij/codeInsight/hints/declarative/impl/InlayPresentationList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public final class InlayPresentationList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TinyTree<Object> state;
    @TestOnly
    private boolean hasBackground;
    @TestOnly
    private boolean isDisabled;
    @Nullable
    private Map<String, ? extends InlayActionPayload> payloads;
    @NotNull
    private InlayPresentationEntry[] entries;
    @Nullable
    private int[] _partialWidthSums;
    private int computedWidth;
    private static final int NOT_COMPUTED = -1;
    private static final int LEFT_MARGIN = 7;
    private static final int RIGHT_MARGIN = 7;
    private static final int BOTTOM_MARGIN = 1;
    private static final int TOP_MARGIN = 1;
    private static final int ARC_WIDTH = 8;
    private static final int ARC_HEIGHT = 8;
    private static final float BACKGROUND_ALPHA = 0.55f;

    public InlayPresentationList(@NotNull TinyTree<Object> state, boolean hasBackground, boolean isDisabled, @Nullable Map<String, ? extends InlayActionPayload> payloads) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        this.state = state;
        this.hasBackground = hasBackground;
        this.isDisabled = isDisabled;
        this.payloads = payloads;
        this.entries = new PresentationEntryBuilder(this.state).buildPresentationEntries();
        this.computedWidth = -1;
    }

    public /* synthetic */ InlayPresentationList(TinyTree tinyTree, boolean bl, boolean bl2, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map2 = null;
        }
        this(tinyTree, bl, bl2, map2);
    }

    public final boolean getHasBackground() {
        return this.hasBackground;
    }

    public final void setHasBackground(boolean bl) {
        this.hasBackground = bl;
    }

    public final boolean isDisabled() {
        return this.isDisabled;
    }

    public final void setDisabled(boolean bl) {
        this.isDisabled = bl;
    }

    @Nullable
    public final Map<String, InlayActionPayload> getPayloads() {
        return this.payloads;
    }

    public final void setPayloads(@Nullable Map<String, ? extends InlayActionPayload> map2) {
        this.payloads = map2;
    }

    private final int[] computePartialSums(InlayTextMetricsStorage fontMetricsStorage) {
        int width = 0;
        int n = 0;
        int n2 = this.entries.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            InlayPresentationEntry entry = this.entries[n3];
            int oldWidth = width;
            width += entry.computeWidth(fontMetricsStorage);
            nArray[n3] = oldWidth;
        }
        return nArray;
    }

    private final int[] getPartialWidthSums(InlayTextMetricsStorage storage) {
        int[] sums = this._partialWidthSums;
        if (sums != null) {
            return sums;
        }
        int[] computed = this.computePartialSums(storage);
        this._partialWidthSums = computed;
        return computed;
    }

    public final void handleClick(@NotNull EditorMouseEvent e, @NotNull Point pointInsideInlay, @NotNull InlayTextMetricsStorage fontMetricsStorage, boolean controlDown) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)pointInsideInlay, (String)"pointInsideInlay");
        Intrinsics.checkNotNullParameter((Object)fontMetricsStorage, (String)"fontMetricsStorage");
        InlayPresentationEntry inlayPresentationEntry = this.findEntryByPoint(fontMetricsStorage, pointInsideInlay);
        if (inlayPresentationEntry == null) {
            return;
        }
        InlayPresentationEntry entry = inlayPresentationEntry;
        Editor editor2 = e.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.editor");
        entry.handleClick(editor2, this, controlDown);
    }

    private final InlayPresentationEntry findEntryByPoint(InlayTextMetricsStorage fontMetricsStorage, Point pointInsideInlay) {
        int x = pointInsideInlay.x;
        int[] partialWidthSums = this.getPartialWidthSums(fontMetricsStorage);
        InlayPresentationEntry[] inlayPresentationEntryArray = this.entries;
        int n = inlayPresentationEntryArray.length;
        for (int j = 0; j < n; ++j) {
            int n2;
            int index2 = j;
            InlayPresentationEntry entry = inlayPresentationEntryArray[j];
            int leftBound = partialWidthSums[index2] + 7;
            int[] nArray = partialWidthSums;
            int n3 = index2 + 1;
            if (n3 >= 0 && n3 <= ArraysKt.getLastIndex((int[])nArray)) {
                n2 = nArray[n3];
            } else {
                int it = n3;
                boolean bl = false;
                n2 = 0x7FFFFFF8;
            }
            int rightBound = n2 + 7;
            boolean bl = leftBound <= x ? x <= rightBound : false;
            if (!bl) continue;
            return entry;
        }
        return null;
    }

    @RequiresEdt
    public final void updateState(@NotNull TinyTree<Object> state, boolean disabled, boolean hasBackground) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        this.updateStateTree(state, this.state, (byte)0, (byte)0);
        this.state = state;
        this.entries = new PresentationEntryBuilder(state).buildPresentationEntries();
        this.computedWidth = -1;
        this._partialWidthSums = null;
        this.isDisabled = disabled;
        this.hasBackground = hasBackground;
    }

    private final void updateStateTree(TinyTree<Object> treeToUpdate, TinyTree<Object> treeToUpdateFrom, byte treeToUpdateIndex, byte treeToUpdateFromIndex) {
        byte treeToUpdateTag = treeToUpdate.getBytePayload(treeToUpdateIndex);
        byte treeToUpdateFromTag = treeToUpdateFrom.getBytePayload(treeToUpdateFromIndex);
        if (!(treeToUpdateFromTag != 6 && treeToUpdateFromTag != 8 || treeToUpdateTag != 6 && treeToUpdateTag != 8 && treeToUpdateTag != 7 && treeToUpdateTag != 9)) {
            treeToUpdate.setBytePayload(treeToUpdateFromTag, treeToUpdateIndex);
        }
        treeToUpdateFrom.syncProcessChildren(treeToUpdateFromIndex, treeToUpdateIndex, treeToUpdate, (Function2<Byte, Byte, Boolean>)((Function2)new Function2<Byte, Byte, Boolean>(this, treeToUpdate, treeToUpdateFrom){
            final /* synthetic */ InlayPresentationList this$0;
            final /* synthetic */ TinyTree<Object> $treeToUpdate;
            final /* synthetic */ TinyTree<Object> $treeToUpdateFrom;
            {
                this.this$0 = $receiver;
                this.$treeToUpdate = $treeToUpdate;
                this.$treeToUpdateFrom = $treeToUpdateFrom;
                super(2);
            }

            @NotNull
            public final Boolean invoke(byte treeToUpdateFromChildIndex, byte treeToUpdateChildIndex) {
                InlayPresentationList.access$updateStateTree(this.this$0, this.$treeToUpdate, this.$treeToUpdateFrom, treeToUpdateChildIndex, treeToUpdateFromChildIndex);
                return true;
            }
        }));
    }

    public final void toggleTreeState(byte parentIndexToSwitch) {
        byte payload = this.state.getBytePayload(parentIndexToSwitch);
        if (payload == 8 ? true : payload == 9) {
            this.state.setBytePayload((byte)6, parentIndexToSwitch);
        } else if (payload == 6 ? true : payload == 7) {
            this.state.setBytePayload((byte)8, parentIndexToSwitch);
        } else {
            throw new IllegalStateException(("Unexpected payload: " + payload).toString());
        }
        this.updateState(this.state, this.isDisabled, this.hasBackground);
    }

    /*
     * WARNING - void declaration
     */
    public final int getWidthInPixels(@NotNull InlayTextMetricsStorage textMetricsStorage) {
        Intrinsics.checkNotNullParameter((Object)textMetricsStorage, (String)"textMetricsStorage");
        if (this.computedWidth == -1) {
            int width;
            InlayPresentationEntry[] inlayPresentationEntryArray = this.entries;
            int n = 0;
            int n2 = inlayPresentationEntryArray.length;
            for (int j = 0; j < n2; ++j) {
                void it;
                InlayPresentationEntry inlayPresentationEntry;
                InlayPresentationEntry inlayPresentationEntry2 = inlayPresentationEntry = inlayPresentationEntryArray[j];
                int n3 = n;
                boolean bl = false;
                int n4 = it.computeWidth(textMetricsStorage);
                n = n3 + n4;
            }
            this.computedWidth = width = n + 7 + 7;
            return width;
        }
        return this.computedWidth;
    }

    public final void paint(@NotNull Inlay<?> inlay, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor3 = (EditorImpl)editor2;
        InlayTextMetricsStorage storage = InlayHintsUtils.INSTANCE.getTextMetricStorage$intellij_platform_lang_impl((Editor)editor3);
        Ref.IntRef xOffset = new Ref.IntRef();
        InlayTextMetrics metrics = storage.getFontMetrics(false);
        int gap = (int)targetRegion.getHeight() < metrics.getLineHeight() + 2 ? 1 : 2;
        TextAttributesKey attrKey = this.hasBackground ? DefaultLanguageHighlighterColors.INLAY_DEFAULT : DefaultLanguageHighlighterColors.INLAY_TEXT_WITHOUT_BACKGROUND;
        TextAttributes attrs = editor3.getColorsScheme().getAttributes(attrKey);
        PresentationUtilKt.withTranslated(g, targetRegion.getX(), targetRegion.getY(), (Function0<Unit>)((Function0)new Function0<Unit>(this, targetRegion, gap, storage, g, attrs, textAttributes){
            final /* synthetic */ InlayPresentationList this$0;
            final /* synthetic */ Rectangle2D $targetRegion;
            final /* synthetic */ int $gap;
            final /* synthetic */ InlayTextMetricsStorage $storage;
            final /* synthetic */ Graphics2D $g;
            final /* synthetic */ TextAttributes $attrs;
            final /* synthetic */ TextAttributes $textAttributes;
            {
                this.this$0 = $receiver;
                this.$targetRegion = $targetRegion;
                this.$gap = $gap;
                this.$storage = $storage;
                this.$g = $g;
                this.$attrs = $attrs;
                this.$textAttributes = $textAttributes;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getHasBackground()) {
                    int rectHeight = (int)this.$targetRegion.getHeight() - this.$gap * 2;
                    int rectWidth = this.this$0.getWidthInPixels(this.$storage);
                    GraphicsConfig config = GraphicsUtil.setupAAPainting(this.$g);
                    GraphicsUtil.paintWithAlpha(this.$g, 0.55f);
                    Color color = this.$attrs.getBackgroundColor();
                    if (color == null) {
                        color = this.$textAttributes.getBackgroundColor();
                    }
                    this.$g.setColor(color);
                    this.$g.fillRoundRect(0, this.$gap, rectWidth, rectHeight, 8, 8);
                    config.restore();
                }
            }
        }));
        PresentationUtilKt.withTranslated(g, (double)7 + targetRegion.getX(), targetRegion.getY(), (Function0<Unit>)((Function0)new Function0<Unit>(this, inlay, attrs, g, xOffset, storage, gap, targetRegion, editor3){
            final /* synthetic */ InlayPresentationList this$0;
            final /* synthetic */ Inlay<?> $inlay;
            final /* synthetic */ TextAttributes $attrs;
            final /* synthetic */ Graphics2D $g;
            final /* synthetic */ Ref.IntRef $xOffset;
            final /* synthetic */ InlayTextMetricsStorage $storage;
            final /* synthetic */ int $gap;
            final /* synthetic */ Rectangle2D $targetRegion;
            final /* synthetic */ EditorImpl $editor;
            {
                this.this$0 = $receiver;
                this.$inlay = $inlay;
                this.$attrs = $attrs;
                this.$g = $g;
                this.$xOffset = $xOffset;
                this.$storage = $storage;
                this.$gap = $gap;
                this.$targetRegion = $targetRegion;
                this.$editor = $editor;
                super(0);
            }

            public final void invoke() {
                for (InlayPresentationEntry entry : InlayPresentationList.access$getEntries$p(this.this$0)) {
                    TextAttributes textAttributes;
                    boolean hovered2 = entry.isHovered();
                    if (hovered2) {
                        TextAttributes inlayAttrsWithRefForeground;
                        TextAttributes refAttrs = this.$inlay.getEditor().getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
                        Intrinsics.checkNotNullExpressionValue((Object)this.$attrs.clone(), (String)"attrs.clone()");
                        inlayAttrsWithRefForeground.setForegroundColor(refAttrs.getForegroundColor());
                        textAttributes = inlayAttrsWithRefForeground;
                    } else {
                        textAttributes = this.$attrs;
                    }
                    TextAttributes finalAttrs = textAttributes;
                    PresentationUtilKt.withTranslated(this.$g, this.$xOffset.element, 0, (Function0<Unit>)((Function0)new Function0<Unit>(entry, this.$g, this.$storage, finalAttrs, this.this$0, this.$gap, this.$targetRegion, this.$editor){
                        final /* synthetic */ InlayPresentationEntry $entry;
                        final /* synthetic */ Graphics2D $g;
                        final /* synthetic */ InlayTextMetricsStorage $storage;
                        final /* synthetic */ TextAttributes $finalAttrs;
                        final /* synthetic */ InlayPresentationList this$0;
                        final /* synthetic */ int $gap;
                        final /* synthetic */ Rectangle2D $targetRegion;
                        final /* synthetic */ EditorImpl $editor;
                        {
                            this.$entry = $entry;
                            this.$g = $g;
                            this.$storage = $storage;
                            this.$finalAttrs = $finalAttrs;
                            this.this$0 = $receiver;
                            this.$gap = $gap;
                            this.$targetRegion = $targetRegion;
                            this.$editor = $editor;
                            super(0);
                        }

                        public final void invoke() {
                            TextAttributes textAttributes = this.$finalAttrs;
                            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"finalAttrs");
                            this.$entry.render(this.$g, this.$storage, textAttributes, this.this$0.isDisabled(), this.$gap, (int)this.$targetRegion.getHeight(), (Editor)this.$editor);
                        }
                    }));
                    this.$xOffset.element += entry.computeWidth(this.$storage);
                }
            }
        }));
    }

    @TestOnly
    @NotNull
    public final InlayPresentationEntry[] getEntries() {
        return this.entries;
    }

    @Nullable
    public final InlayMouseArea getMouseArea(@NotNull Point pointInsideInlay, @NotNull InlayTextMetricsStorage fontMetricsStorage) {
        Intrinsics.checkNotNullParameter((Object)pointInsideInlay, (String)"pointInsideInlay");
        Intrinsics.checkNotNullParameter((Object)fontMetricsStorage, (String)"fontMetricsStorage");
        InlayPresentationEntry inlayPresentationEntry = this.findEntryByPoint(fontMetricsStorage, pointInsideInlay);
        if (inlayPresentationEntry == null) {
            return null;
        }
        InlayPresentationEntry entry = inlayPresentationEntry;
        return entry.getClickArea();
    }

    public static final /* synthetic */ void access$updateStateTree(InlayPresentationList $this, TinyTree treeToUpdate, TinyTree treeToUpdateFrom, byte treeToUpdateIndex, byte treeToUpdateFromIndex) {
        $this.updateStateTree(treeToUpdate, treeToUpdateFrom, treeToUpdateIndex, treeToUpdateFromIndex);
    }

    public static final /* synthetic */ InlayPresentationEntry[] access$getEntries$p(InlayPresentationList $this) {
        return $this.entries;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationList$Companion;", "", "()V", "ARC_HEIGHT", "", "ARC_WIDTH", "BACKGROUND_ALPHA", "", "BOTTOM_MARGIN", "LEFT_MARGIN", "NOT_COMPUTED", "RIGHT_MARGIN", "TOP_MARGIN", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

