/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.declarative.impl;

import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.InlayActionHandler;
import com.intellij.codeInsight.hints.declarative.impl.InlayMouseArea;
import com.intellij.codeInsight.hints.declarative.impl.InlayPresentationEntry;
import com.intellij.codeInsight.hints.declarative.impl.InlayPresentationList;
import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.paint.EffectPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J@\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010$\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/TextInlayPresentationEntry;", "Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationEntry;", "text", "", "parentIndexToSwitch", "", "clickArea", "Lcom/intellij/codeInsight/hints/declarative/impl/InlayMouseArea;", "(Ljava/lang/String;BLcom/intellij/codeInsight/hints/declarative/impl/InlayMouseArea;)V", "getText", "()Ljava/lang/String;", "computeHeight", "", "fontMetricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "computeWidth", "equals", "", "other", "", "handleClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "list", "Lcom/intellij/codeInsight/hints/declarative/impl/InlayPresentationList;", "controlDown", "hashCode", "render", "graphics", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "isDisabled", "yOffset", "rectHeight", "toString", "intellij.platform.lang.impl"})
public final class TextInlayPresentationEntry
extends InlayPresentationEntry {
    @TestOnly
    @NotNull
    private final String text;
    private final byte parentIndexToSwitch;

    public TextInlayPresentationEntry(@NotNull String text2, byte parentIndexToSwitch, @Nullable InlayMouseArea clickArea) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(clickArea, null);
        this.text = text2;
        this.parentIndexToSwitch = parentIndexToSwitch;
    }

    public /* synthetic */ TextInlayPresentationEntry(String string2, byte by, InlayMouseArea inlayMouseArea, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            by = (byte)-1;
        }
        this(string2, by, inlayMouseArea);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    public void handleClick(@NotNull Editor editor2, @NotNull InlayPresentationList list2, boolean controlDown) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Project project2 = editor2.getProject();
        if (this.getClickArea() != null && project2 != null) {
            InlayActionHandler inlayActionHandler;
            InlayActionData actionData = this.getClickArea().getActionData();
            if (controlDown && (inlayActionHandler = InlayActionHandler.Companion.getActionHandler(actionData.getHandlerId())) != null) {
                inlayActionHandler.handleClick(editor2, actionData.getPayload());
            }
        }
        if (this.parentIndexToSwitch != -1) {
            list2.toggleTreeState(this.parentIndexToSwitch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(@NotNull Graphics2D graphics, @NotNull InlayTextMetricsStorage fontMetricsStorage, @NotNull TextAttributes attributes, boolean isDisabled, int yOffset, int rectHeight, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)fontMetricsStorage, (String)"fontMetricsStorage");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        InlayTextMetrics metrics = fontMetricsStorage.getFontMetrics(false);
        Object savedHint = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        Color savedColor = graphics.getColor();
        try {
            Color foreground = attributes.getForegroundColor();
            if (foreground != null) {
                Color effectColor;
                int width = this.computeWidth(fontMetricsStorage);
                int height = this.computeHeight(fontMetricsStorage);
                Font font = metrics.getFont();
                graphics.setFont(font);
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                graphics.setColor(foreground);
                graphics.drawString(this.text, 0, Math.max(editor2.getAscent(), (rectHeight + metrics.getAscent() - metrics.getDescent()) / 2) - 1);
                Color color = attributes.getEffectColor();
                if (color == null) {
                    color = effectColor = foreground;
                }
                if (isDisabled) {
                    graphics.setColor(effectColor);
                    EffectPainter.STRIKE_THROUGH.paint(graphics, 0, metrics.getFontBaseline() + yOffset, width, height, (Object)font);
                }
            }
        }
        finally {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
            graphics.setColor(savedColor);
        }
    }

    @Override
    public int computeWidth(@NotNull InlayTextMetricsStorage fontMetricsStorage) {
        Intrinsics.checkNotNullParameter((Object)fontMetricsStorage, (String)"fontMetricsStorage");
        return fontMetricsStorage.getFontMetrics(false).getStringWidth(this.text);
    }

    @Override
    public int computeHeight(@NotNull InlayTextMetricsStorage fontMetricsStorage) {
        Intrinsics.checkNotNullParameter((Object)fontMetricsStorage, (String)"fontMetricsStorage");
        return fontMetricsStorage.getFontMetrics(false).getFontHeight();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.codeInsight.hints.declarative.impl.TextInlayPresentationEntry");
        TextInlayPresentationEntry cfr_ignored_0 = (TextInlayPresentationEntry)other;
        return Intrinsics.areEqual((Object)this.text, (Object)((TextInlayPresentationEntry)other).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @NotNull
    public String toString() {
        return "TextInlayPresentationEntry(text='" + this.text + "', parentIndexToSwitch=" + this.parentIndexToSwitch + ")";
    }
}

