/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.declarative.impl.toggle;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hints.declarative.DeclarativeInlayHintsSettings;
import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayHintsProviderFactory;
import com.intellij.codeInsight.hints.declarative.InlayOptionInfo;
import com.intellij.codeInsight.hints.declarative.InlayPayload;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayProviderInfo;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.OwnBypassCollector;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPassFactory;
import com.intellij.codeInsight.hints.declarative.impl.toggle.DeclarativeHintsTogglingIntention;
import com.intellij.codeInsight.hints.declarative.impl.toggle.DeclarativeHintsTogglingOptionIntention;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor;", "Lcom/intellij/codeInsight/daemon/impl/IntentionMenuContributor;", "()V", "collectActions", "", "hostEditor", "Lcom/intellij/openapi/editor/Editor;", "hostFile", "Lcom/intellij/psi/PsiFile;", "intentions", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "passIdToShowIntentionsFor", "", "offset", "Context", "DummyInlayTreeSink", "OwnCollectorInfo", "ProviderInfo", "ProviderWithOptionInfo", "SharedCollectorInfo", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDeclarativeHintsTogglingIntentionMenuContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeHintsTogglingIntentionMenuContributor.kt\ncom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class DeclarativeHintsTogglingIntentionMenuContributor
implements IntentionMenuContributor {
    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset2) {
        Intrinsics.checkNotNullParameter((Object)hostEditor, (String)"hostEditor");
        Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)intentions, (String)"intentions");
        Project project2 = hostFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"hostFile.project");
        Context context2 = Context.Companion.gather(project2, hostEditor, hostFile);
        if (context2 == null) {
            return;
        }
        Context context3 = context2;
        for (ProviderInfo providerInfo : context3.getProvidersToToggle()) {
            DeclarativeHintsTogglingIntention action2 = new DeclarativeHintsTogglingIntention(providerInfo.getProviderId(), providerInfo.getProviderName(), providerInfo.getProviderEnabled());
            HighlightInfo.IntentionActionDescriptor descriptor2 = new HighlightInfo.IntentionActionDescriptor(action2, new ArrayList(), null, null, null, null, HighlightSeverity.INFORMATION);
            intentions.intentionsToShow.add(descriptor2);
        }
        DeclarativeInlayHintsSettings settings = DeclarativeInlayHintsSettings.Companion.getInstance();
        for (ProviderWithOptionInfo providersWithOption : context3.getProvidersWithOptions()) {
            InlayOptionInfo optionInfo;
            Object v3;
            String optionId;
            String providerId;
            block4: {
                InlayProviderInfo providerInfo;
                providerId = providersWithOption.getProviderId();
                Language language = hostFile.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"hostFile.language");
                if (InlayHintsProviderFactory.Companion.getProviderInfo(language, providerId) == null) continue;
                optionId = providersWithOption.getOptionId();
                Iterable iterable = providerInfo.getOptions();
                for (Object t : iterable) {
                    InlayOptionInfo it = (InlayOptionInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)optionId)) continue;
                    v3 = t;
                    break block4;
                }
                v3 = null;
            }
            if ((InlayOptionInfo)v3 == null) continue;
            Boolean bl = settings.isOptionEnabled(optionId, providerId);
            boolean optionEnabled = bl != null ? bl.booleanValue() : optionInfo.isEnabledByDefault();
            boolean providerEnabled = providersWithOption.getProviderEnabled();
            DeclarativeHintsTogglingOptionIntention.Mode mode = providerEnabled ? (optionEnabled ? DeclarativeHintsTogglingOptionIntention.Mode.DisableOption : DeclarativeHintsTogglingOptionIntention.Mode.EnableOption) : DeclarativeHintsTogglingOptionIntention.Mode.EnableProviderAndOption;
            DeclarativeHintsTogglingOptionIntention action3 = new DeclarativeHintsTogglingOptionIntention(optionId, providerId, providersWithOption.getProviderName(), optionInfo.getName(), mode);
            HighlightInfo.IntentionActionDescriptor descriptor3 = new HighlightInfo.IntentionActionDescriptor(action3, new ArrayList(), null, null, null, null, HighlightSeverity.INFORMATION);
            intentions.intentionsToShow.add(descriptor3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$Context;", "", "providersWithOptions", "", "Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$ProviderWithOptionInfo;", "providersToToggle", "Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$ProviderInfo;", "(Ljava/util/Set;Ljava/util/Set;)V", "getProvidersToToggle", "()Ljava/util/Set;", "getProvidersWithOptions", "Companion", "intellij.platform.lang.impl"})
    private static final class Context {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<ProviderWithOptionInfo> providersWithOptions;
        @NotNull
        private final Set<ProviderInfo> providersToToggle;

        public Context(@NotNull Set<ProviderWithOptionInfo> providersWithOptions, @NotNull Set<ProviderInfo> providersToToggle) {
            Intrinsics.checkNotNullParameter(providersWithOptions, (String)"providersWithOptions");
            Intrinsics.checkNotNullParameter(providersToToggle, (String)"providersToToggle");
            this.providersWithOptions = providersWithOptions;
            this.providersToToggle = providersToToggle;
        }

        @NotNull
        public final Set<ProviderWithOptionInfo> getProvidersWithOptions() {
            return this.providersWithOptions;
        }

        @NotNull
        public final Set<ProviderInfo> getProvidersToToggle() {
            return this.providersToToggle;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$Context$Companion;", "", "()V", "gather", "Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$Context;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Context gather(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
                int offset2;
                PsiElement element;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                List<InlayProviderInfo> providers = DeclarativeInlayHintsPassFactory.Companion.getSuitableToFileProviders(file2);
                if (providers.isEmpty()) {
                    return null;
                }
                ArrayList<OwnCollectorInfo> ownBypassCollectors = new ArrayList<OwnCollectorInfo>();
                ArrayList<SharedCollectorInfo> sharedBypassCollectors = new ArrayList<SharedCollectorInfo>();
                DeclarativeInlayHintsSettings settings = DeclarativeInlayHintsSettings.Companion.getInstance();
                for (InlayProviderInfo provider2 : providers) {
                    InlayHintsCollector collector2 = provider2.getProvider().createCollector(file2, editor2);
                    if (collector2 == null) continue;
                    String providerId = provider2.getProviderId();
                    Boolean bl = settings.isProviderEnabled(providerId);
                    boolean enabled = bl != null ? bl.booleanValue() : provider2.isEnabledByDefault();
                    InlayHintsCollector inlayHintsCollector = collector2;
                    if (inlayHintsCollector instanceof OwnBypassCollector) {
                        ownBypassCollectors.add(new OwnCollectorInfo((OwnBypassCollector)collector2, providerId, provider2.getProviderName(), enabled));
                        continue;
                    }
                    if (!(inlayHintsCollector instanceof SharedBypassCollector)) continue;
                    sharedBypassCollectors.add(new SharedCollectorInfo((SharedBypassCollector)collector2, new DummyInlayTreeSink(), providerId, provider2.getProviderName(), enabled));
                }
                HashSet<ProviderInfo> providersToToggle = new HashSet<ProviderInfo>();
                HashSet<ProviderWithOptionInfo> providersWithOptionsToToggle = new HashSet<ProviderWithOptionInfo>();
                if (!((Collection)sharedBypassCollectors).isEmpty() && (element = file2.findElementAt(offset2 = editor2.getCaretModel().getOffset())) != null) {
                    for (PsiElement parent2 : PsiTreeUtilKt.parents(element, true)) {
                        for (SharedCollectorInfo sharedCollectorInfo : sharedBypassCollectors) {
                            SharedBypassCollector collector3 = sharedCollectorInfo.component1();
                            DummyInlayTreeSink sink = sharedCollectorInfo.component2();
                            String providerId = sharedCollectorInfo.component3();
                            String providerName = sharedCollectorInfo.component4();
                            boolean providerEnabled = sharedCollectorInfo.component5();
                            collector3.collectFromElement(parent2, sink);
                            if (sink.getAttemptedToAddWithoutOptions()) {
                                providersToToggle.add(new ProviderInfo(providerId, providerName, providerEnabled));
                            }
                            if (!(!((Collection)sink.getAttemptedToAddUnderOptions()).isEmpty())) continue;
                            for (String optionId : sink.getAttemptedToAddUnderOptions()) {
                                providersWithOptionsToToggle.add(new ProviderWithOptionInfo(providerId, optionId, providerName, providerEnabled));
                            }
                        }
                    }
                }
                if (!((Collection)ownBypassCollectors).isEmpty()) {
                    for (OwnCollectorInfo ownCollectorInfo : ownBypassCollectors) {
                        OwnBypassCollector collector4 = ownCollectorInfo.component1();
                        String providerId = ownCollectorInfo.component2();
                        String providerName = ownCollectorInfo.component3();
                        boolean providerEnabled = ownCollectorInfo.component4();
                        if (collector4.shouldSuggestToggling(project2, editor2, file2)) {
                            providersToToggle.add(new ProviderInfo(providerId, providerName, providerEnabled));
                        }
                        Set<String> optionsToToggle = collector4.getOptionsToToggle(project2, editor2, file2);
                        for (String optionId : optionsToToggle) {
                            providersWithOptionsToToggle.add(new ProviderWithOptionInfo(providerId, optionId, providerName, providerEnabled));
                        }
                    }
                }
                if (providersToToggle.isEmpty() && providersWithOptionsToToggle.isEmpty()) {
                    return null;
                }
                return new Context((Set<ProviderWithOptionInfo>)providersWithOptionsToToggle, (Set<ProviderInfo>)providersToToggle);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u000f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J,\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$ProviderInfo;", "", "providerId", "", "providerName", "Lorg/jetbrains/annotations/Nls;", "providerEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getProviderEnabled", "()Z", "getProviderId", "()Ljava/lang/String;", "getProviderName", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class ProviderInfo {
        @NotNull
        private final String providerId;
        @NotNull
        private final String providerName;
        private final boolean providerEnabled;

        public ProviderInfo(@NotNull String providerId, @NotNull String providerName, boolean providerEnabled) {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.providerId = providerId;
            this.providerName = providerName;
            this.providerEnabled = providerEnabled;
        }

        @NotNull
        public final String getProviderId() {
            return this.providerId;
        }

        @NotNull
        public final String getProviderName() {
            return this.providerName;
        }

        public final boolean getProviderEnabled() {
            return this.providerEnabled;
        }

        @NotNull
        public final String component1() {
            return this.providerId;
        }

        @NotNull
        public final String component2() {
            return this.providerName;
        }

        public final boolean component3() {
            return this.providerEnabled;
        }

        @NotNull
        public final ProviderInfo copy(@NotNull String providerId, @NotNull String providerName, boolean providerEnabled) {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new ProviderInfo(providerId, providerName, providerEnabled);
        }

        public static /* synthetic */ ProviderInfo copy$default(ProviderInfo providerInfo, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = providerInfo.providerId;
            }
            if ((n & 2) != 0) {
                string3 = providerInfo.providerName;
            }
            if ((n & 4) != 0) {
                bl = providerInfo.providerEnabled;
            }
            return providerInfo.copy(string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "ProviderInfo(providerId=" + this.providerId + ", providerName=" + this.providerName + ", providerEnabled=" + this.providerEnabled + ")";
        }

        public int hashCode() {
            int result2 = this.providerId.hashCode();
            result2 = result2 * 31 + this.providerName.hashCode();
            int n = this.providerEnabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProviderInfo)) {
                return false;
            }
            ProviderInfo providerInfo = (ProviderInfo)other;
            if (!Intrinsics.areEqual((Object)this.providerId, (Object)providerInfo.providerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.providerName, (Object)providerInfo.providerName)) {
                return false;
            }
            return this.providerEnabled == providerInfo.providerEnabled;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B*\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0012\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J6\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$ProviderWithOptionInfo;", "", "providerId", "", "optionId", "providerName", "Lorg/jetbrains/annotations/Nls;", "providerEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getOptionId", "()Ljava/lang/String;", "getProviderEnabled", "()Z", "getProviderId", "getProviderName", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class ProviderWithOptionInfo {
        @NotNull
        private final String providerId;
        @NotNull
        private final String optionId;
        @NotNull
        private final String providerName;
        private final boolean providerEnabled;

        public ProviderWithOptionInfo(@NotNull String providerId, @NotNull String optionId, @NotNull String providerName, boolean providerEnabled) {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.providerId = providerId;
            this.optionId = optionId;
            this.providerName = providerName;
            this.providerEnabled = providerEnabled;
        }

        @NotNull
        public final String getProviderId() {
            return this.providerId;
        }

        @NotNull
        public final String getOptionId() {
            return this.optionId;
        }

        @NotNull
        public final String getProviderName() {
            return this.providerName;
        }

        public final boolean getProviderEnabled() {
            return this.providerEnabled;
        }

        @NotNull
        public final String component1() {
            return this.providerId;
        }

        @NotNull
        public final String component2() {
            return this.optionId;
        }

        @NotNull
        public final String component3() {
            return this.providerName;
        }

        public final boolean component4() {
            return this.providerEnabled;
        }

        @NotNull
        public final ProviderWithOptionInfo copy(@NotNull String providerId, @NotNull String optionId, @NotNull String providerName, boolean providerEnabled) {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new ProviderWithOptionInfo(providerId, optionId, providerName, providerEnabled);
        }

        public static /* synthetic */ ProviderWithOptionInfo copy$default(ProviderWithOptionInfo providerWithOptionInfo, String string2, String string3, String string4, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = providerWithOptionInfo.providerId;
            }
            if ((n & 2) != 0) {
                string3 = providerWithOptionInfo.optionId;
            }
            if ((n & 4) != 0) {
                string4 = providerWithOptionInfo.providerName;
            }
            if ((n & 8) != 0) {
                bl = providerWithOptionInfo.providerEnabled;
            }
            return providerWithOptionInfo.copy(string2, string3, string4, bl);
        }

        @NotNull
        public String toString() {
            return "ProviderWithOptionInfo(providerId=" + this.providerId + ", optionId=" + this.optionId + ", providerName=" + this.providerName + ", providerEnabled=" + this.providerEnabled + ")";
        }

        public int hashCode() {
            int result2 = this.providerId.hashCode();
            result2 = result2 * 31 + this.optionId.hashCode();
            result2 = result2 * 31 + this.providerName.hashCode();
            int n = this.providerEnabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProviderWithOptionInfo)) {
                return false;
            }
            ProviderWithOptionInfo providerWithOptionInfo = (ProviderWithOptionInfo)other;
            if (!Intrinsics.areEqual((Object)this.providerId, (Object)providerWithOptionInfo.providerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.optionId, (Object)providerWithOptionInfo.optionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.providerName, (Object)providerWithOptionInfo.providerName)) {
                return false;
            }
            return this.providerEnabled == providerWithOptionInfo.providerEnabled;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u000b2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b\u001fH\u0016J\u001e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0011j\b\u0012\u0004\u0012\u00020\u0005`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$DummyInlayTreeSink;", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "()V", "attemptedToAddUnderOptions", "", "", "getAttemptedToAddUnderOptions", "()Ljava/util/Set;", "setAttemptedToAddUnderOptions", "(Ljava/util/Set;)V", "attemptedToAddWithoutOptions", "", "getAttemptedToAddWithoutOptions", "()Z", "setAttemptedToAddWithoutOptions", "(Z)V", "currentOptions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addPresentation", "", "position", "Lcom/intellij/codeInsight/hints/declarative/InlayPosition;", "payloads", "", "Lcom/intellij/codeInsight/hints/declarative/InlayPayload;", "tooltip", "hasBackground", "builder", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/hints/declarative/PresentationTreeBuilder;", "Lkotlin/ExtensionFunctionType;", "whenOptionEnabled", "optionId", "block", "Lkotlin/Function0;", "intellij.platform.lang.impl"})
    private static final class DummyInlayTreeSink
    implements InlayTreeSink {
        @NotNull
        private Set<String> attemptedToAddUnderOptions = new HashSet();
        private boolean attemptedToAddWithoutOptions;
        @NotNull
        private final HashSet<String> currentOptions = new HashSet();

        @NotNull
        public final Set<String> getAttemptedToAddUnderOptions() {
            return this.attemptedToAddUnderOptions;
        }

        public final void setAttemptedToAddUnderOptions(@NotNull Set<String> set2) {
            Intrinsics.checkNotNullParameter(set2, (String)"<set-?>");
            this.attemptedToAddUnderOptions = set2;
        }

        public final boolean getAttemptedToAddWithoutOptions() {
            return this.attemptedToAddWithoutOptions;
        }

        public final void setAttemptedToAddWithoutOptions(boolean bl) {
            this.attemptedToAddWithoutOptions = bl;
        }

        @Override
        public void addPresentation(@NotNull InlayPosition position, @Nullable List<InlayPayload> payloads, @Nullable String tooltip, boolean hasBackground, @NotNull Function1<? super PresentationTreeBuilder, Unit> builder2) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(builder2, (String)"builder");
            if (this.currentOptions.isEmpty()) {
                this.attemptedToAddWithoutOptions = true;
            } else {
                this.attemptedToAddUnderOptions.addAll((Collection<String>)this.currentOptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void whenOptionEnabled(@NotNull String optionId, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            this.currentOptions.add(optionId);
            try {
                block.invoke();
            }
            finally {
                this.currentOptions.remove(optionId);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$SharedCollectorInfo;", "", "collector", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "sink", "Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$DummyInlayTreeSink;", "providerId", "", "providerName", "enabled", "", "(Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$DummyInlayTreeSink;Ljava/lang/String;Ljava/lang/String;Z)V", "getCollector", "()Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "getEnabled", "()Z", "getProviderId", "()Ljava/lang/String;", "getProviderName", "getSink", "()Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$DummyInlayTreeSink;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class SharedCollectorInfo {
        @NotNull
        private final SharedBypassCollector collector;
        @NotNull
        private final DummyInlayTreeSink sink;
        @NotNull
        private final String providerId;
        @NotNull
        private final String providerName;
        private final boolean enabled;

        public SharedCollectorInfo(@NotNull SharedBypassCollector collector2, @NotNull DummyInlayTreeSink sink, @NotNull String providerId, @NotNull String providerName, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.collector = collector2;
            this.sink = sink;
            this.providerId = providerId;
            this.providerName = providerName;
            this.enabled = enabled;
        }

        @NotNull
        public final SharedBypassCollector getCollector() {
            return this.collector;
        }

        @NotNull
        public final DummyInlayTreeSink getSink() {
            return this.sink;
        }

        @NotNull
        public final String getProviderId() {
            return this.providerId;
        }

        @NotNull
        public final String getProviderName() {
            return this.providerName;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final SharedBypassCollector component1() {
            return this.collector;
        }

        @NotNull
        public final DummyInlayTreeSink component2() {
            return this.sink;
        }

        @NotNull
        public final String component3() {
            return this.providerId;
        }

        @NotNull
        public final String component4() {
            return this.providerName;
        }

        public final boolean component5() {
            return this.enabled;
        }

        @NotNull
        public final SharedCollectorInfo copy(@NotNull SharedBypassCollector collector2, @NotNull DummyInlayTreeSink sink, @NotNull String providerId, @NotNull String providerName, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new SharedCollectorInfo(collector2, sink, providerId, providerName, enabled);
        }

        public static /* synthetic */ SharedCollectorInfo copy$default(SharedCollectorInfo sharedCollectorInfo, SharedBypassCollector sharedBypassCollector, DummyInlayTreeSink dummyInlayTreeSink, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                sharedBypassCollector = sharedCollectorInfo.collector;
            }
            if ((n & 2) != 0) {
                dummyInlayTreeSink = sharedCollectorInfo.sink;
            }
            if ((n & 4) != 0) {
                string2 = sharedCollectorInfo.providerId;
            }
            if ((n & 8) != 0) {
                string3 = sharedCollectorInfo.providerName;
            }
            if ((n & 0x10) != 0) {
                bl = sharedCollectorInfo.enabled;
            }
            return sharedCollectorInfo.copy(sharedBypassCollector, dummyInlayTreeSink, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "SharedCollectorInfo(collector=" + this.collector + ", sink=" + this.sink + ", providerId=" + this.providerId + ", providerName=" + this.providerName + ", enabled=" + this.enabled + ")";
        }

        public int hashCode() {
            int result2 = this.collector.hashCode();
            result2 = result2 * 31 + this.sink.hashCode();
            result2 = result2 * 31 + this.providerId.hashCode();
            result2 = result2 * 31 + this.providerName.hashCode();
            int n = this.enabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SharedCollectorInfo)) {
                return false;
            }
            SharedCollectorInfo sharedCollectorInfo = (SharedCollectorInfo)other;
            if (!Intrinsics.areEqual((Object)this.collector, (Object)sharedCollectorInfo.collector)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sink, (Object)sharedCollectorInfo.sink)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.providerId, (Object)sharedCollectorInfo.providerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.providerName, (Object)sharedCollectorInfo.providerName)) {
                return false;
            }
            return this.enabled == sharedCollectorInfo.enabled;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInsight/hints/declarative/impl/toggle/DeclarativeHintsTogglingIntentionMenuContributor$OwnCollectorInfo;", "", "collector", "Lcom/intellij/codeInsight/hints/declarative/OwnBypassCollector;", "providerId", "", "providerName", "enabled", "", "(Lcom/intellij/codeInsight/hints/declarative/OwnBypassCollector;Ljava/lang/String;Ljava/lang/String;Z)V", "getCollector", "()Lcom/intellij/codeInsight/hints/declarative/OwnBypassCollector;", "getEnabled", "()Z", "getProviderId", "()Ljava/lang/String;", "getProviderName", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class OwnCollectorInfo {
        @NotNull
        private final OwnBypassCollector collector;
        @NotNull
        private final String providerId;
        @NotNull
        private final String providerName;
        private final boolean enabled;

        public OwnCollectorInfo(@NotNull OwnBypassCollector collector2, @NotNull String providerId, @NotNull String providerName, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.collector = collector2;
            this.providerId = providerId;
            this.providerName = providerName;
            this.enabled = enabled;
        }

        @NotNull
        public final OwnBypassCollector getCollector() {
            return this.collector;
        }

        @NotNull
        public final String getProviderId() {
            return this.providerId;
        }

        @NotNull
        public final String getProviderName() {
            return this.providerName;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final OwnBypassCollector component1() {
            return this.collector;
        }

        @NotNull
        public final String component2() {
            return this.providerId;
        }

        @NotNull
        public final String component3() {
            return this.providerName;
        }

        public final boolean component4() {
            return this.enabled;
        }

        @NotNull
        public final OwnCollectorInfo copy(@NotNull OwnBypassCollector collector2, @NotNull String providerId, @NotNull String providerName, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new OwnCollectorInfo(collector2, providerId, providerName, enabled);
        }

        public static /* synthetic */ OwnCollectorInfo copy$default(OwnCollectorInfo ownCollectorInfo, OwnBypassCollector ownBypassCollector, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                ownBypassCollector = ownCollectorInfo.collector;
            }
            if ((n & 2) != 0) {
                string2 = ownCollectorInfo.providerId;
            }
            if ((n & 4) != 0) {
                string3 = ownCollectorInfo.providerName;
            }
            if ((n & 8) != 0) {
                bl = ownCollectorInfo.enabled;
            }
            return ownCollectorInfo.copy(ownBypassCollector, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "OwnCollectorInfo(collector=" + this.collector + ", providerId=" + this.providerId + ", providerName=" + this.providerName + ", enabled=" + this.enabled + ")";
        }

        public int hashCode() {
            int result2 = this.collector.hashCode();
            result2 = result2 * 31 + this.providerId.hashCode();
            result2 = result2 * 31 + this.providerName.hashCode();
            int n = this.enabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OwnCollectorInfo)) {
                return false;
            }
            OwnCollectorInfo ownCollectorInfo = (OwnCollectorInfo)other;
            if (!Intrinsics.areEqual((Object)this.collector, (Object)ownCollectorInfo.collector)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.providerId, (Object)ownCollectorInfo.providerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.providerName, (Object)ownCollectorInfo.providerName)) {
                return false;
            }
            return this.enabled == ownCollectorInfo.enabled;
        }
    }
}

