/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u0005R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006&"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "fontHeight", "", "fontBaseline", "fontMetrics", "Ljava/awt/FontMetrics;", "fontType", "(Lcom/intellij/openapi/editor/Editor;IILjava/awt/FontMetrics;I)V", "ascent", "getAscent", "()I", "descent", "getDescent", "editorComponent", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "getFontBaseline", "getFontHeight", "getFontType", "lineHeight", "getLineHeight", "getStringWidth", "text", "", "isActual", "", "size", "", "familyName", "offsetFromTop", "Companion", "intellij.platform.lang.impl"})
public final class InlayTextMetrics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int fontHeight;
    private final int fontBaseline;
    @NotNull
    private final FontMetrics fontMetrics;
    private final int fontType;
    private final int ascent;
    private final int descent;
    private final int lineHeight;
    @NotNull
    private final JComponent editorComponent;

    public InlayTextMetrics(@NotNull Editor editor2, int fontHeight, int fontBaseline, @NotNull FontMetrics fontMetrics, int fontType) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        this.fontHeight = fontHeight;
        this.fontBaseline = fontBaseline;
        this.fontMetrics = fontMetrics;
        this.fontType = fontType;
        this.ascent = editor2.getAscent();
        EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        this.descent = editorImpl != null ? editorImpl.getDescent() : 0;
        this.lineHeight = editor2.getLineHeight();
        JComponent jComponent = editor2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
        this.editorComponent = jComponent;
    }

    public final int getFontHeight() {
        return this.fontHeight;
    }

    public final int getFontBaseline() {
        return this.fontBaseline;
    }

    public final int getFontType() {
        return this.fontType;
    }

    @NotNull
    public final Font getFont() {
        Font font = this.fontMetrics.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"fontMetrics.font");
        return font;
    }

    public final int getAscent() {
        return this.ascent;
    }

    public final int getDescent() {
        return this.descent;
    }

    public final int getLineHeight() {
        return this.lineHeight;
    }

    public final boolean isActual(float size, @NotNull String familyName) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        if (!(size == this.getFont().getSize2D())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getFont().getFamily(), (Object)familyName)) {
            return false;
        }
        return InlayTextMetrics.Companion.getCurrentContext(this.editorComponent).equals(this.fontMetrics.getFontRenderContext());
    }

    public final int offsetFromTop() {
        return (this.lineHeight - this.fontHeight) / 2;
    }

    public final int getStringWidth(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.fontMetrics.stringWidth(text2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics$Companion;", "", "()V", "create", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "editor", "Lcom/intellij/openapi/editor/Editor;", "size", "", "fontType", "", "create$intellij_platform_lang_impl", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "editorComponent", "Ljavax/swing/JComponent;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InlayTextMetrics create$intellij_platform_lang_impl(@NotNull Editor editor2, float size, int fontType) {
            Font font;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (EditorSettingsExternalizable.getInstance().isUseEditorFontInInlays()) {
                Font editorFont = EditorUtil.getEditorFont();
                font = editorFont.deriveFont(fontType, size);
            } else {
                String familyName = StartupUiUtil.getLabelFont().getFamily();
                font = UIUtil.getFontWithFallback(familyName, fontType, size);
            }
            Font font2 = font;
            JComponent jComponent = editor2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
            FontRenderContext context2 = this.getCurrentContext(jComponent);
            FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font2, (FontRenderContext)context2);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(font, context)");
            FontMetrics metrics = fontMetrics;
            int fontHeight = (int)Math.ceil(font2.createGlyphVector(context2, "Albpq@").getVisualBounds().getHeight());
            int fontBaseline = (int)Math.ceil(font2.createGlyphVector(context2, "Alb").getVisualBounds().getHeight());
            return new InlayTextMetrics(editor2, fontHeight, fontBaseline, metrics, fontType);
        }

        private final FontRenderContext getCurrentContext(JComponent editorComponent) {
            FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)editorComponent);
            return new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), UISettings.Companion.getEditorFractionalMetricsHint());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

