/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.StartupUiUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\n8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "normalTextMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "normalTextSize", "", "getNormalTextSize", "()F", "smallTextMetrics", "smallTextSize", "getSmallTextSize", "getFontMetrics", "small", "", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class InlayTextMetricsStorage {
    @NotNull
    private final Editor editor;
    @Nullable
    private InlayTextMetrics smallTextMetrics;
    @Nullable
    private InlayTextMetrics normalTextMetrics;

    public InlayTextMetricsStorage(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @RequiresEdt
    private final float getSmallTextSize() {
        return Math.max(1.0f, this.editor.getColorsScheme().getEditorFontSize2D() - 1.0f);
    }

    @RequiresEdt
    private final float getNormalTextSize() {
        return this.editor.getColorsScheme().getEditorFontSize2D();
    }

    @RequiresEdt
    @NotNull
    public final InlayTextMetrics getFontMetrics(boolean small) {
        InlayTextMetrics metrics;
        block8: {
            float fontSize;
            int fontType;
            block9: {
                String familyName;
                block6: {
                    float fontSize2;
                    block7: {
                        metrics = null;
                        familyName = EditorSettingsExternalizable.getInstance().isUseEditorFontInInlays() ? EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName() : StartupUiUtil.getLabelFont().getFamily();
                        fontType = this.editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLAY_DEFAULT).getFontType();
                        if (!small) break block6;
                        metrics = this.smallTextMetrics;
                        fontSize2 = this.getSmallTextSize();
                        if (metrics == null) break block7;
                        float f = this.getSmallTextSize();
                        Intrinsics.checkNotNullExpressionValue((Object)familyName, (String)"familyName");
                        if (metrics.isActual(f, familyName)) break block8;
                    }
                    this.smallTextMetrics = metrics = InlayTextMetrics.Companion.create$intellij_platform_lang_impl(this.editor, fontSize2, fontType);
                    break block8;
                }
                metrics = this.normalTextMetrics;
                fontSize = this.getNormalTextSize();
                if (metrics == null) break block9;
                float f = this.getNormalTextSize();
                Intrinsics.checkNotNullExpressionValue((Object)familyName, (String)"familyName");
                if (metrics.isActual(f, familyName)) break block8;
            }
            this.normalTextMetrics = metrics = InlayTextMetrics.Companion.create$intellij_platform_lang_impl(this.editor, fontSize, fontType);
        }
        return metrics;
    }
}

