/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/hints/presentation/MenuOnClickPresentation;", "Lcom/intellij/codeInsight/hints/presentation/StaticDelegatePresentation;", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "project", "Lcom/intellij/openapi/project/Project;", "actionsSupplier", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "getActionsSupplier", "()Lkotlin/jvm/functions/Function0;", "getProject", "()Lcom/intellij/openapi/project/Project;", "mouseClicked", "", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "intellij.platform.lang.impl"})
public final class MenuOnClickPresentation
extends StaticDelegatePresentation {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<List<AnAction>> actionsSupplier;

    public MenuOnClickPresentation(@NotNull InlayPresentation presentation2, @NotNull Project project2, @NotNull Function0<? extends List<? extends AnAction>> actionsSupplier) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(actionsSupplier, (String)"actionsSupplier");
        super(presentation2);
        this.project = project2;
        this.actionsSupplier = actionsSupplier;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Function0<List<AnAction>> getActionsSupplier() {
        return this.actionsSupplier;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        super.mouseClicked(event, translated);
        if (SwingUtilities.isRightMouseButton(event) && !SwingUtilities.isLeftMouseButton(event)) {
            List actions = (List)this.actionsSupplier.invoke();
            if (actions.isEmpty()) {
                return;
            }
            JBPopupMenu.showByEvent((MouseEvent)event, (String)"InlayMenu", (ActionGroup)((ActionGroup)new DefaultActionGroup(actions)));
        }
    }
}

