/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettingsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ParameterNameHintsSettings", storages={@Storage(value="parameter.hints.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u001e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002J\u0016\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0016J\u0016\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010%\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007H\u0002R6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000e\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "addedPatterns", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "disabledLanguages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "options", "", "removedPatterns", "addIgnorePattern", "", "language", "Lcom/intellij/lang/Language;", "pattern", "getAddedPatterns", "getExcludeListDiff", "Lcom/intellij/codeInsight/hints/settings/Diff;", "getOption", "optionId", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getRemovedPatterns", "getState", "isEnabledForLanguage", "loadState", "state", "setAddedPatterns", "added", "setExcludeListDiff", "diff", "setIsEnabledForLanguage", "enabled", "setOption", "value", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "setRemovedPatterns", "removed", "Companion", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nParameterNameHintsSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParameterNameHintsSettings.kt\ncom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,209:1\n1855#2:210\n1549#2:211\n1620#2,3:212\n1549#2:215\n1620#2,3:216\n1856#2:219\n1549#2:222\n1620#2,3:223\n1855#2,2:226\n1855#2,2:228\n1855#2,2:230\n215#3,2:220\n*S KotlinDebug\n*F\n+ 1 ParameterNameHintsSettings.kt\ncom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings\n*L\n77#1:210\n83#1:211\n83#1:212,3\n84#1:215\n84#1:216,3\n77#1:219\n101#1:222\n101#1:223,3\n133#1:226,2\n143#1:228,2\n149#1:230,2\n92#1:220,2\n*E\n"})
public final class ParameterNameHintsSettings
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Set<String>> removedPatterns = new HashMap();
    @NotNull
    private final HashMap<String, Set<String>> addedPatterns = new HashMap();
    @NotNull
    private final HashMap<String, Boolean> options = new HashMap();
    @NotNull
    private final HashSet<String> disabledLanguages = new HashSet();

    public final void addIgnorePattern(@NotNull Language language, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Set<String> patternsBefore = this.getAddedPatterns(language);
        this.setAddedPatterns(language, SetsKt.plus(patternsBefore, (Object)pattern));
    }

    @NotNull
    public final Diff getExcludeListDiff(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Set<String> added = this.getAddedPatterns(language);
        Set<String> removed = this.getRemovedPatterns(language);
        return new Diff(added, removed);
    }

    public final void setExcludeListDiff(@NotNull Language language, @NotNull Diff diff) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.setAddedPatterns(language, diff.getAdded());
        this.setRemovedPatterns(language, diff.getRemoved());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Element getState() {
        Object element;
        Object object;
        Element root = new Element("settings");
        if (!((Map)this.removedPatterns).isEmpty() || !((Map)this.addedPatterns).isEmpty()) {
            Element blacklists = new Element("blacklists");
            root.addContent(blacklists);
            Set<String> set2 = this.removedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"removedPatterns.keys");
            Set<String> set3 = this.addedPatterns.keySet();
            Intrinsics.checkNotNullExpressionValue(set3, (String)"addedPatterns.keys");
            Set allLanguages = SetsKt.plus(set2, (Iterable)set3);
            Iterable $this$forEach$iv = allLanguages;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Element element2;
                Set<String> set4;
                Set<String> set5;
                Set<String> set6;
                Set<String> set7;
                Object element$iv = object.next();
                String it = (String)element$iv;
                boolean bl = false;
                Set<String> set8 = set7 = this.removedPatterns.get(it);
                if (set8 == null) {
                    set6 = SetsKt.emptySet();
                } else {
                    Intrinsics.checkNotNullExpressionValue(set8, (String)"removedPatterns[it] ?: emptySet()");
                    set6 = set7;
                }
                Set<String> removed = set6;
                Set<String> set9 = set5 = this.addedPatterns.get(it);
                if (set9 == null) {
                    set4 = SetsKt.emptySet();
                } else {
                    Intrinsics.checkNotNullExpressionValue(set9, (String)"addedPatterns[it] ?: emptySet()");
                    set4 = set5;
                }
                Set<String> added = set4;
                Element $this$getState_u24lambda_u243_u24lambda_u242 = element2 = new Element("blacklist");
                boolean bl2 = false;
                $this$getState_u24lambda_u243_u24lambda_u242.setAttribute("language", it);
                Iterable $this$map$iv = removed;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    String string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(ParameterNameHintsSettingsKt.access$toPatternElement((String)it2, "removed"));
                }
                List removedElements = (List)destination$iv$iv;
                Iterable $this$map$iv2 = added;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    String bl3 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(ParameterNameHintsSettingsKt.access$toPatternElement((String)it3, "added"));
                }
                List addedElements = (List)destination$iv$iv2;
                $this$getState_u24lambda_u243_u24lambda_u242.addContent((Collection)CollectionsKt.plus((Collection)addedElements, (Iterable)removedElements));
                Element languageBlacklist = element2;
                blacklists.addContent(languageBlacklist);
            }
        }
        Map $this$forEach$iv = this.options;
        boolean $i$f$forEach2 = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String id = (String)object.getKey();
            boolean value = (Boolean)object.getValue();
            element = new Element("option");
            ((Element)element).setAttribute("id", id);
            ((Element)element).setAttribute("value", String.valueOf(value));
            root.addContent((Element)element);
        }
        if (!((Collection)this.disabledLanguages).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Element disabledLanguagesElement = new Element("disabledLanguages");
            Iterable $i$f$forEach2 = this.disabledLanguages;
            Element element3 = disabledLanguagesElement;
            boolean $i$f$map = false;
            void element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Element element4 = new Element("language");
                element4.setAttribute("id", (String)it);
                collection.add(element4);
            }
            element3.addContent((Collection)((List)destination$iv$iv));
            root.addContent(disabledLanguagesElement);
        }
        return root;
    }

    public final void setIsEnabledForLanguage(boolean enabled, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!enabled) {
            this.disabledLanguages.add(language.getID());
        } else {
            this.disabledLanguages.remove(language.getID());
        }
    }

    public final boolean isEnabledForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return !this.disabledLanguages.contains(language.getID());
    }

    @Override
    public void loadState(@NotNull Element state) {
        block11: {
            Element element;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.addedPatterns.clear();
            this.removedPatterns.clear();
            this.options.clear();
            this.disabledLanguages.clear();
            Element element2 = state.getChild("blacklists");
            List<Element> list2 = element2 != null ? element2.getChildren("blacklist") : null;
            List<Element> allBlacklistElements = list2 == null ? CollectionsKt.emptyList() : list2;
            Iterable $this$forEach$iv = allBlacklistElements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set set2;
                Set set3;
                Object object;
                String language;
                block10: {
                    Set removed;
                    block9: {
                        Object object2;
                        Map map2;
                        Element blacklistElement;
                        block8: {
                            Set added;
                            block7: {
                                blacklistElement = (Element)element$iv;
                                boolean bl = false;
                                Intrinsics.checkNotNullExpressionValue((Object)blacklistElement, (String)"blacklistElement");
                                if (ParameterNameHintsSettingsKt.access$attributeValue(blacklistElement, "language") == null) continue;
                                added = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "added");
                                map2 = this.addedPatterns;
                                object = this.addedPatterns.get(language);
                                object2 = object;
                                if (object2 == null) break block7;
                                Intrinsics.checkNotNullExpressionValue(object2, (String)"addedPatterns[language]");
                                object2 = SetsKt.plus((Set)object, (Iterable)added);
                                if (object2 != null) break block8;
                            }
                            object2 = added;
                        }
                        object = object2;
                        map2.put(language, object);
                        removed = ParameterNameHintsSettingsKt.access$extractPatterns(blacklistElement, "removed");
                        object = this.removedPatterns;
                        set3 = this.removedPatterns.get(language);
                        set2 = set3;
                        if (set2 == null) break block9;
                        Intrinsics.checkNotNullExpressionValue(set2, (String)"removedPatterns[language]");
                        set2 = SetsKt.plus((Set)set3, (Iterable)removed);
                        if (set2 != null) break block10;
                    }
                    set2 = removed;
                }
                set3 = set2;
                object.put(language, set3);
            }
            List<Element> list3 = state.getChildren("option");
            Intrinsics.checkNotNullExpressionValue(list3, (String)"state.getChildren(\"option\")");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it = (Element)element$iv;
                boolean bl = false;
                String id = it.getAttributeValue("id");
                Map map3 = this.options;
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                map3.put(id, it.getAttributeBooleanValue("value"));
            }
            Element element3 = state.getChild("disabledLanguages");
            if (element3 == null) break block11;
            Element $this$loadState_u24lambda_u249 = element = element3;
            boolean bl = false;
            List<Element> list4 = $this$loadState_u24lambda_u249.getChildren("language");
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getChildren(XmlTagHelper.DISABLED_LANGUAGE_ITEM)");
            Iterable $this$forEach$iv2 = list4;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String languageId;
                Element it = (Element)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (ParameterNameHintsSettingsKt.access$attributeValue(it, "id") == null) continue;
                this.disabledLanguages.add(languageId);
            }
        }
    }

    @Nullable
    public final Boolean getOption(@NotNull String optionId) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        return this.options.get(optionId);
    }

    public final void setOption(@NotNull String optionId, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)optionId, (String)"optionId");
        if (value == null) {
            this.options.remove(optionId);
        } else {
            ((Map)this.options).put(optionId, value);
        }
    }

    private final Set<String> getAddedPatterns(Language language) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        Set set2 = this.addedPatterns.get(key);
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    private final Set<String> getRemovedPatterns(Language language) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        Set set2 = this.removedPatterns.get(key);
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    private final void setRemovedPatterns(Language language, Set<String> removed) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        ((Map)this.removedPatterns).put(key, removed);
    }

    private final void setAddedPatterns(Language language, Set<String> added) {
        String string2 = language.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"language.displayName");
        String key = string2;
        ((Map)this.addedPatterns).put(key, added);
    }

    @JvmStatic
    @NotNull
    public static final ParameterNameHintsSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ParameterNameHintsSettings getInstance() {
            ParameterNameHintsSettings parameterNameHintsSettings = ApplicationManager.getApplication().getService(ParameterNameHintsSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)parameterNameHintsSettings, (String)"getApplication().getServ\u2026intsSettings::class.java)");
            return parameterNameHintsSettings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

