/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings.language;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/hints/settings/language/CaseListPanel;", "Ljavax/swing/JPanel;", "cases", "", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable$Case;", "listener", "Lcom/intellij/codeInsight/hints/ChangeListener;", "(Ljava/util/List;Lcom/intellij/codeInsight/hints/ChangeListener;)V", "getCases", "()Ljava/util/List;", "checkBoxes", "", "Ljavax/swing/JCheckBox;", "getCheckBoxes", "setEnabledCheckboxes", "", "value", "", "updateCheckBoxes", "intellij.platform.lang.impl"})
public final class CaseListPanel
extends JPanel {
    @NotNull
    private final List<ImmediateConfigurable.Case> cases;
    @NotNull
    private final List<JCheckBox> checkBoxes;

    public CaseListPanel(@NotNull List<ImmediateConfigurable.Case> cases2, @NotNull ChangeListener listener2) {
        Intrinsics.checkNotNullParameter(cases2, (String)"cases");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.cases = cases2;
        this.checkBoxes = new ArrayList();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(JBUI.Borders.empty(0, 20, 0, 0));
        this.add(Box.createRigidArea(JBUI.size(0, 5)));
        for (ImmediateConfigurable.Case case_ : this.cases) {
            JCheckBox checkBox = new JCheckBox(case_.getName(), case_.getValue());
            checkBox.setAlignmentX(0.0f);
            this.checkBoxes.add(checkBox);
            checkBox.addActionListener(arg_0 -> CaseListPanel._init_$lambda$0(case_, checkBox, listener2, arg_0));
            String description = case_.getExtendedDescription();
            if (description != null) {
                JPanel checkBoxPanel = new JPanel();
                checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
                checkBoxPanel.setAlignmentX(0.0f);
                checkBoxPanel.add(checkBox);
                checkBoxPanel.add(Box.createRigidArea(JBUI.size(5, 0)));
                checkBoxPanel.add((Component)ContextHelpLabel.create((String)description));
                this.add(checkBoxPanel);
            } else {
                this.add(checkBox);
            }
            this.add(Box.createRigidArea(new Dimension(0, 3)));
        }
        this.add(Box.createRigidArea(JBUI.size(0, 5)));
    }

    @NotNull
    public final List<ImmediateConfigurable.Case> getCases() {
        return this.cases;
    }

    @NotNull
    public final List<JCheckBox> getCheckBoxes() {
        return this.checkBoxes;
    }

    public final void setEnabledCheckboxes(boolean value) {
        for (JCheckBox checkBox : this.checkBoxes) {
            checkBox.setEnabled(value);
        }
    }

    public final void updateCheckBoxes() {
        Iterator<JCheckBox> iterator2 = this.checkBoxes.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            JCheckBox checkBox = iterator2.next();
            checkBox.setSelected(this.cases.get(index2).getValue());
        }
    }

    private static final void _init_$lambda$0(ImmediateConfigurable.Case $case, JCheckBox $checkBox, ChangeListener $listener, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$case, (String)"$case");
        Intrinsics.checkNotNullParameter((Object)$checkBox, (String)"$checkBox");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $case.setValue($checkBox.isSelected());
        $listener.settingsChanged();
    }
}

