/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings.language;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hints.settings.language.SingleLanguageInlayHintsSettingsPanelKt;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a9\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\f\u001a\u000e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\r\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"SETTINGS_EDITOR_MARKER", "Lcom/intellij/openapi/util/Key;", "", "getSETTINGS_EDITOR_MARKER", "()Lcom/intellij/openapi/util/Key;", "createEditor", "Lcom/intellij/ui/EditorTextField;", "language", "Lcom/intellij/lang/Language;", "project", "Lcom/intellij/openapi/project/Project;", "updateHints", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Editor;", "Lkotlin/ParameterName;", "name", "editor", "", "isInlaySettingsEditor", "intellij.platform.lang.impl"})
public final class SingleLanguageInlayHintsSettingsPanelKt {
    @NotNull
    private static final Key<Boolean> SETTINGS_EDITOR_MARKER;

    @NotNull
    public static final Key<Boolean> getSETTINGS_EDITOR_MARKER() {
        return SETTINGS_EDITOR_MARKER;
    }

    public static final boolean isInlaySettingsEditor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return Intrinsics.areEqual((Object)editor2.getUserData(SETTINGS_EDITOR_MARKER), (Object)true);
    }

    @NotNull
    public static final EditorTextField createEditor(@NotNull Language language, @NotNull Project project2, @NotNull Function1<? super Editor, ? extends Object> updateHints2) {
        FileType fileType;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(updateHints2, (String)"updateHints");
        LanguageFileType languageFileType = language.getAssociatedFileType();
        if (languageFileType == null) {
            LanguageFileType languageFileType2 = FileTypes.PLAIN_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)languageFileType2, (String)"PLAIN_TEXT");
            fileType = languageFileType2;
        } else {
            fileType = languageFileType;
        }
        FileType fileType2 = fileType;
        EditorTextField editorField2 = new EditorTextField(project2, fileType2, updateHints2){
            final /* synthetic */ Function1<Editor, Object> $updateHints;
            {
                this.$updateHints = $updateHints;
                super(null, $project, $fileType, true, false);
            }

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"super.createEditor()");
                EditorEx editor2 = editorEx;
                editor2.putUserData(SingleLanguageInlayHintsSettingsPanelKt.getSETTINGS_EDITOR_MARKER(), (Object)true);
                this.$updateHints.invoke((Object)editor2);
                return editor2;
            }
        };
        editorField2.setFont(EditorFontType.PLAIN.getGlobalFont());
        editorField2.setBorder((Border)new LineBorder(JBColor.border()));
        editorField2.addSettingsProvider(arg_0 -> SingleLanguageInlayHintsSettingsPanelKt.createEditor$lambda$1(project2, updateHints2, arg_0));
        ReadAction.run(() -> SingleLanguageInlayHintsSettingsPanelKt.createEditor$lambda$2(editorField2));
        return editorField2;
    }

    private static final void createEditor$lambda$1(Project $project, Function1 $updateHints, EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$updateHints, (String)"$updateHints");
        editor2.setVerticalScrollbarVisible(true);
        editor2.setHorizontalScrollbarVisible(true);
        EditorSettings $this$createEditor_u24lambda_u241_u24lambda_u240 = editor2.getSettings();
        boolean bl = false;
        $this$createEditor_u24lambda_u241_u24lambda_u240.setAdditionalLinesCount(0);
        $this$createEditor_u24lambda_u241_u24lambda_u240.setAutoCodeFoldingEnabled(false);
        editor2.getDocument().addDocumentListener(new DocumentListener((Function1<? super Editor, ? extends Object>)$updateHints, editor2){
            final /* synthetic */ Function1<Editor, Object> $updateHints;
            final /* synthetic */ EditorEx $editor;
            {
                this.$updateHints = $updateHints;
                this.$editor = $editor;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EditorEx editorEx = this.$editor;
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"editor");
                this.$updateHints.invoke((Object)editorEx);
            }
        });
        editor2.setBackgroundColor(EditorFragmentComponent.getBackgroundColor((Editor)((Editor)editor2), (boolean)false));
        editor2.setBorder((Border)JBUI.Borders.empty());
        PsiFile psiFile = PsiDocumentManager.getInstance($project).getPsiFile(editor2.getDocument());
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance($project).setHighlightingEnabled(psiFile, false);
        }
    }

    private static final void createEditor$lambda$2(createEditor.editorField.1 $editorField) {
        Intrinsics.checkNotNullParameter((Object)((Object)$editorField), (String)"$editorField");
        $editorField.setCaretPosition(0);
    }

    static {
        Key key = Key.create("inlay.settings.editor");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create(\"inlay.settings.editor\")");
        SETTINGS_EDITOR_MARKER = key;
    }
}

