/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionBean
extends CustomLoadingExtensionPointBean<IntentionAction> {
    @Tag
    @RequiredElement
    public String className;
    @Tag
    public String language;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String category;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String categoryKey;
    @Tag
    public String bundleName;
    @Tag
    public String descriptionDirectoryName;

    @Override
    @Nullable
    protected String getImplementationClassName() {
        return this.className;
    }

    public String @Nullable [] getCategories() {
        String baseName;
        if (this.categoryKey == null) {
            return this.category == null ? null : this.category.split("/");
        }
        String string2 = baseName = this.bundleName != null ? this.bundleName : this.getPluginDescriptor().getResourceBundleBaseName();
        if (baseName == null) {
            Logger.getInstance(IntentionActionBean.class).error("No resource bundle specified for " + this.getPluginDescriptor());
            return null;
        }
        ResourceBundle bundle = DynamicBundle.getResourceBundle(this.getLoaderForClass(), baseName);
        String[] keys2 = this.categoryKey.split("/");
        if (keys2.length > 1) {
            String[] result2 = new String[keys2.length];
            for (int i2 = 0; i2 < keys2.length; ++i2) {
                result2[i2] = AbstractBundle.message(bundle, keys2[i2], new Object[0]);
            }
            return result2;
        }
        return AbstractBundle.message(bundle, this.categoryKey, new Object[0]).split("/");
    }

    public String getDescriptionDirectoryName() {
        return this.descriptionDirectoryName;
    }
}

