/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLevelIntentionComponent
extends EditorNotificationPanel {
    public FileLevelIntentionComponent(@NlsContexts.Label String description, @NotNull HighlightSeverity severity, @Nullable GutterMark gutterMark, final @Nullable List<? extends Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> intentions, @NotNull PsiFile psiFile, final @NotNull Editor editor2, @NlsContexts.Tooltip @Nullable String tooltip) {
        IntentionAction intentionAction;
        if (severity == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(2);
        }
        super(FileLevelIntentionComponent.getColor(psiFile.getProject(), severity), FileLevelIntentionComponent.getStatus(psiFile.getProject(), severity));
        final Project project2 = psiFile.getProject();
        ShowIntentionsPass.IntentionsInfo info2 = new ShowIntentionsPass.IntentionsInfo();
        if (intentions != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : intentions) {
                HighlightInfo.IntentionActionDescriptor descriptor2 = pair.getFirst();
                info2.intentionsToShow.add(descriptor2);
                IntentionAction action2 = descriptor2.getAction();
                if (action2 instanceof EmptyIntentionAction) continue;
                String text2 = action2.getText();
                this.createActionLabel(text2, () -> {
                    PsiDocumentManager.getInstance(project2).commitAllDocuments();
                    ShowIntentionActionsHandler.chooseActionAndInvoke(psiFile, editor2, action2, text2);
                });
            }
        }
        this.myLabel.setText(description);
        this.myLabel.setToolTipText(tooltip);
        if (gutterMark != null) {
            this.myLabel.setIcon(gutterMark.getIcon());
        }
        if (!(intentions == null || intentions.isEmpty() || (intentionAction = intentions.get(0).getFirst().getAction()) instanceof UserDataHolder && Boolean.FALSE.equals(((UserDataHolder)((Object)intentionAction)).getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY)))) {
            this.myGearLabel.setIcon(AllIcons.General.GearPlain);
            final SmartPsiElementPointer<PsiFile> smartPsiElementPointer = SmartPointerManager.createPointer(psiFile);
            new ClickListener(){

                @Override
                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    PsiFile psiFile;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((psiFile = (PsiFile)smartPsiElementPointer.getElement()) == null) {
                        return true;
                    }
                    CachedIntentions cachedIntentions = new CachedIntentions(project2, psiFile, editor2);
                    IntentionListStep step2 = new IntentionListStep(null, editor2, psiFile, project2, cachedIntentions);
                    HighlightInfo.IntentionActionDescriptor descriptor2 = (HighlightInfo.IntentionActionDescriptor)((Pair)intentions.get(0)).getFirst();
                    IntentionActionWithTextCaching actionWithTextCaching = cachedIntentions.wrapAction(descriptor2, psiFile, psiFile, editor2);
                    if (step2.hasSubstep(actionWithTextCaching)) {
                        step2 = step2.getSubStep(actionWithTextCaching, null);
                    }
                    ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
                    Dimension dimension = popup2.getContent().getPreferredSize();
                    Point at = new Point(-dimension.width + FileLevelIntentionComponent.this.myGearLabel.getWidth(), FileLevelIntentionComponent.this.getHeight());
                    popup2.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent$1", "onClick"));
                }
            }.installOn(this.myGearLabel);
        }
    }

    @NotNull
    private static Color getColor(@NotNull Project project2, @NotNull HighlightSeverity severity) {
        if (project2 == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(3);
        }
        if (severity == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(4);
        }
        if (SeverityRegistrar.getSeverityRegistrar(project2).compare(severity, HighlightSeverity.ERROR) >= 0) {
            Color color = LightColors.RED;
            if (color == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(5);
            }
            return color;
        }
        if (SeverityRegistrar.getSeverityRegistrar(project2).compare(severity, HighlightSeverity.WARNING) >= 0) {
            Color color = LightColors.YELLOW;
            if (color == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(6);
            }
            return color;
        }
        Color color = LightColors.GREEN;
        if (color == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(7);
        }
        return color;
    }

    @NotNull
    private static EditorNotificationPanel.Status getStatus(@NotNull Project project2, @NotNull HighlightSeverity severity) {
        if (project2 == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(8);
        }
        if (severity == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(9);
        }
        if (SeverityRegistrar.getSeverityRegistrar(project2).compare(severity, HighlightSeverity.ERROR) >= 0) {
            EditorNotificationPanel.Status status = EditorNotificationPanel.Status.Error;
            if (status == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(10);
            }
            return status;
        }
        if (SeverityRegistrar.getSeverityRegistrar(project2).compare(severity, HighlightSeverity.WARNING) >= 0) {
            EditorNotificationPanel.Status status = EditorNotificationPanel.Status.Warning;
            if (status == null) {
                FileLevelIntentionComponent.$$$reportNull$$$0(11);
            }
            return status;
        }
        EditorNotificationPanel.Status status = EditorNotificationPanel.Status.Success;
        if (status == null) {
            FileLevelIntentionComponent.$$$reportNull$$$0(12);
        }
        return status;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/FileLevelIntentionComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6, 7, 10, 11, 12 -> new IllegalStateException(string2);
        };
    }
}

