/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionShortcutManager;
import com.intellij.codeInsight.intention.impl.IntentionShortcutUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/intention/impl/IntentionActionAsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "intention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "(Lcom/intellij/codeInsight/intention/IntentionAction;)V", "actionId", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findIntention", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.lang.impl"})
public final class IntentionActionAsAction
extends AnAction {
    @NotNull
    private final String actionId;

    public IntentionActionAsAction(@NotNull IntentionAction intention) {
        Intrinsics.checkNotNullParameter((Object)intention, (String)"intention");
        super(() -> IntentionActionAsAction._init_$lambda$0(intention));
        this.actionId = IntentionShortcutUtils.getWrappedActionId(intention);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IntentionAction intentionAction = this.findIntention();
        if (intentionAction == null) {
            return;
        }
        IntentionAction intention = intentionAction;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"e.dataContext");
        DataContext dataContext3 = dataContext2;
        PsiFile psiFile = (PsiFile)dataContext3.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        Editor editor2 = (Editor)dataContext3.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        IntentionShortcutUtils.invokeAsAction(intention, editor3, file2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = (Editor)e.getDataContext().getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)e.getDataContext().getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        IntentionAction intentionAction = this.findIntention();
        e.getPresentation().setEnabled(intentionAction != null ? intentionAction.isAvailable(project3, editor3, file2) : false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final IntentionAction findIntention() {
        return IntentionShortcutManager.Companion.getInstance().findIntention$intellij_platform_lang_impl(this.actionId);
    }

    private static final String _init_$lambda$0(IntentionAction $intention) {
        Intrinsics.checkNotNullParameter((Object)$intention, (String)"$intention");
        Object[] objectArray = new Object[]{$intention.getFamilyName()};
        return CodeInsightBundle.message("intention.action.wrapper.name", objectArray);
    }
}

