/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.CustomizableIntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.IntentionShortcutManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware,
ShortcutProvider,
IntentionActionDelegate {
    private static final Logger LOG = Logger.getInstance(IntentionActionWithTextCaching.class);
    private final List<IntentionAction> myOptionIntentions;
    private final List<IntentionAction> myOptionErrorFixes;
    private final List<IntentionAction> myOptionInspectionFixes;
    @IntentionName
    private final String myText;
    private final IntentionAction myAction;
    private final @NlsContexts.PopupTitle String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(@NotNull IntentionAction action2, @NlsContexts.PopupTitle String displayName, @Nullable Icon icon2, @NotNull BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
        if (action2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(0);
        }
        if (markInvoked == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(1);
        }
        this.myOptionIntentions = new ArrayList<IntentionAction>();
        this.myOptionErrorFixes = new ArrayList<IntentionAction>();
        this.myOptionInspectionFixes = new ArrayList<IntentionAction>();
        this.myIcon = icon2;
        this.myText = action2.getText();
        LOG.assertTrue(this.myText != null, "action " + action2.getClass() + " text returned null");
        this.myAction = new MyIntentionAction(action2, markInvoked);
        this.myDisplayName = displayName;
    }

    @NotNull
    @IntentionName
    public String getText() {
        String string2 = this.myText;
        if (string2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(2);
        }
        return string2;
    }

    void addIntention(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(3);
        }
        this.myOptionIntentions.add(action2);
    }

    void addErrorFix(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(4);
        }
        this.myOptionErrorFixes.add(action2);
    }

    void addInspectionFix(@NotNull IntentionAction action2) {
        if (action2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(5);
        }
        this.myOptionInspectionFixes.add(action2);
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(6);
        }
        return intentionAction;
    }

    @NotNull
    List<IntentionAction> getOptionIntentions() {
        List<IntentionAction> list2 = this.myOptionIntentions;
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionErrorFixes() {
        List<IntentionAction> list2 = this.myOptionErrorFixes;
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionInspectionFixes() {
        List<IntentionAction> list2 = this.myOptionInspectionFixes;
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public List<IntentionAction> getOptionActions() {
        List<IntentionAction> list2 = ContainerUtil.concat(this.myOptionIntentions, this.myOptionErrorFixes, this.myOptionInspectionFixes);
        if (list2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NlsContexts.PopupTitle
    String getToolName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toString() {
        String string2 = this.getText();
        if (string2 == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (other == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(12);
        }
        if (this.myAction instanceof Comparable) {
            return ((Comparable)((Object)this.myAction)).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return -((Comparable)((Object)other.getAction())).compareTo(this.myAction);
        }
        return Comparing.compare(this.getText(), other.getText());
    }

    Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.myAction);
    }

    @Override
    @Nullable
    public ShortcutSet getShortcut() {
        ShortcutSet shortcut = this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)((Object)this.myAction)).getShortcut() : null;
        return shortcut != null ? shortcut : IntentionShortcutManager.getInstance().getShortcutSet(this.myAction);
    }

    @Override
    @NotNull
    public IntentionAction getDelegate() {
        IntentionAction intentionAction = this.getAction();
        if (intentionAction == null) {
            IntentionActionWithTextCaching.$$$reportNull$$$0(13);
        }
        return intentionAction;
    }

    boolean isShowSubmenu() {
        IntentionAction action2 = IntentionActionDelegate.unwrap(this.getDelegate());
        if (action2 instanceof CustomizableIntentionAction) {
            return ((CustomizableIntentionAction)this.myAction).isShowSubmenu();
        }
        return true;
    }

    public boolean isSelectable() {
        IntentionAction action2 = IntentionActionDelegate.unwrap(this.getDelegate());
        if (action2 instanceof CustomizableIntentionAction) {
            return ((CustomizableIntentionAction)this.myAction).isSelectable();
        }
        return true;
    }

    public boolean isShowIcon() {
        IntentionAction action2 = IntentionActionDelegate.unwrap(this.getDelegate());
        if (action2 instanceof CustomizableIntentionAction) {
            return ((CustomizableIntentionAction)action2).isShowIcon();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntentionActionWithTextCaching)) {
            return false;
        }
        IntentionActionWithTextCaching other = (IntentionActionWithTextCaching)o;
        return IntentionActionWithTextCaching.getActionClass(this) == IntentionActionWithTextCaching.getActionClass(other) && this.getText().equals(other.getText());
    }

    private static Class<? extends IntentionAction> getActionClass(IntentionActionWithTextCaching o1) {
        return IntentionActionDelegate.unwrap(o1.getAction()).getClass();
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8, 9, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markInvoked";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionIntentions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionErrorFixes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionInspectionFixes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIntention";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addErrorFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addInspectionFix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 7, 8, 9, 10, 11, 13 -> new IllegalStateException(string2);
        };
    }

    private class MyIntentionAction
    implements IntentionAction,
    CustomizableIntentionActionDelegate,
    Comparable<MyIntentionAction>,
    ShortcutProvider,
    PossiblyDumbAware {
        private final IntentionAction myAction;
        @NotNull
        private final BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> myMarkInvoked;

        MyIntentionAction(@NotNull IntentionAction action2, BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
            if (action2 == null) {
                MyIntentionAction.$$$reportNull$$$0(0);
            }
            if (markInvoked == null) {
                MyIntentionAction.$$$reportNull$$$0(1);
            }
            this.myAction = action2;
            this.myMarkInvoked = markInvoked;
        }

        @Override
        public boolean isDumbAware() {
            return DumbService.isDumbAware(this.myAction);
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = IntentionActionWithTextCaching.this.myText;
            if (string2 == null) {
                MyIntentionAction.$$$reportNull$$$0(2);
            }
            return string2;
        }

        public String toString() {
            return this.getDelegate() + " (" + this.getDelegate().getClass() + ")";
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string2 = this.myAction.getFamilyName();
            if (string2 == null) {
                MyIntentionAction.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
            if (project2 == null) {
                MyIntentionAction.$$$reportNull$$$0(4);
            }
            return this.myAction.isAvailable(project2, editor2, file2);
        }

        @Override
        public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
            if (project2 == null) {
                MyIntentionAction.$$$reportNull$$$0(5);
            }
            SlowOperations.allowSlowOperations(() -> this.myAction.invoke(project2, editor2, file2));
            this.myMarkInvoked.accept(IntentionActionWithTextCaching.this, this.myAction);
        }

        @Override
        public boolean startInWriteAction() {
            return this.myAction.startInWriteAction();
        }

        @Override
        @NotNull
        public IntentionAction getDelegate() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                MyIntentionAction.$$$reportNull$$$0(6);
            }
            return intentionAction;
        }

        @Override
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
            if (project2 == null) {
                MyIntentionAction.$$$reportNull$$$0(7);
            }
            if (editor2 == null) {
                MyIntentionAction.$$$reportNull$$$0(8);
            }
            if (file2 == null) {
                MyIntentionAction.$$$reportNull$$$0(9);
            }
            IntentionPreviewInfo intentionPreviewInfo = this.myAction.generatePreview(project2, editor2, file2);
            if (intentionPreviewInfo == null) {
                MyIntentionAction.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }

        @Override
        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                MyIntentionAction.$$$reportNull$$$0(11);
            }
            return this.myAction.getElementToMakeWritable(currentFile);
        }

        @Override
        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)((Object)this.myAction)).getShortcut() : IntentionShortcutManager.getInstance().getShortcutSet(this.myAction);
        }

        @Override
        public int compareTo(@NotNull MyIntentionAction other) {
            if (other == null) {
                MyIntentionAction.$$$reportNull$$$0(12);
            }
            if (this.myAction instanceof Comparable) {
                return ((Comparable)((Object)this.myAction)).compareTo(other.getDelegate());
            }
            if (other.getDelegate() instanceof Comparable) {
                return -((Comparable)((Object)other.getDelegate())).compareTo(this.myAction);
            }
            return Comparing.compare(this.getText(), other.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markInvoked";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3, 6, 10 -> new IllegalStateException(string2);
            };
        }
    }
}

