/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.IntentionActionAsAction;
import com.intellij.codeInsight.intention.impl.IntentionShortcutManager;
import com.intellij.codeInsight.intention.impl.IntentionShortcutUtils;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u00162\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0014\u0010\u001a\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0016\u0010\u001b\u001a\u00020\u0006*\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u0010\u001d\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0014\u0010\u001e\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\u0006*\u00020\u0016H\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#*\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/codeInsight/intention/impl/IntentionShortcutManager;", "Lcom/intellij/openapi/Disposable;", "()V", "registeredKeymap", "Lcom/intellij/openapi/keymap/Keymap;", "dispose", "", "findIntention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "wrappedActionId", "", "findIntention$intellij_platform_lang_impl", "getShortcutSet", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "intention", "hasShortcut", "", "promptForIntentionShortcut", "project", "Lcom/intellij/openapi/project/Project;", "registerIntentionsInActiveKeymap", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "removeFirstIntentionShortcut", "findIntentionWrapper", "Lcom/intellij/openapi/actionSystem/AnAction;", "register", "registerIntentionsInKeymap", "keymap", "unregister", "unregisterIntentionsInExtension", "extension", "Lcom/intellij/codeInsight/intention/IntentionActionBean;", "unregisterIntentionsInKeymap", "wrappedIntentionActions", "Lkotlin/sequences/Sequence;", "Companion", "InitListener", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIntentionShortcutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentionShortcutManager.kt\ncom/intellij/codeInsight/intention/impl/IntentionShortcutManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,151:1\n288#2,2:152\n1295#3,2:154\n1295#3,2:156\n1295#3,2:158\n8811#4,2:160\n9071#4,4:162\n*S KotlinDebug\n*F\n+ 1 IntentionShortcutManager.kt\ncom/intellij/codeInsight/intention/impl/IntentionShortcutManager\n*L\n85#1:152,2\n111#1:154,2\n116#1:156,2\n121#1:158,2\n130#1:160,2\n130#1:162,4\n*E\n"})
public final class IntentionShortcutManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Keymap registeredKeymap;

    public final boolean hasShortcut(@NotNull IntentionAction intention) {
        Intrinsics.checkNotNullParameter((Object)intention, (String)"intention");
        Shortcut[] shortcutArray = this.getShortcutSet(intention);
        return shortcutArray != null && (shortcutArray = shortcutArray.getShortcuts()) != null ? !(shortcutArray.length == 0) : false;
    }

    @Nullable
    public final ShortcutSet getShortcutSet(@NotNull IntentionAction intention) {
        Intrinsics.checkNotNullParameter((Object)intention, (String)"intention");
        ActionManager actionManager = ActionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance()");
        AnAction anAction = this.findIntentionWrapper(actionManager, intention);
        return anAction != null ? anAction.getShortcutSet() : null;
    }

    public final void removeFirstIntentionShortcut(@NotNull IntentionAction intention) {
        Intrinsics.checkNotNullParameter((Object)intention, (String)"intention");
        Object[] objectArray = this.getShortcutSet(intention);
        if (objectArray == null || (objectArray = objectArray.getShortcuts()) == null) {
            return;
        }
        Object[] shortcuts = objectArray;
        Shortcut shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])shortcuts);
        if (shortcut != null) {
            Shortcut it = shortcut;
            boolean bl = false;
            KeymapManager keymapManager = KeymapManager.getInstance();
            if (keymapManager != null && (keymapManager = keymapManager.getActiveKeymap()) != null) {
                keymapManager.removeShortcut(IntentionShortcutUtils.getWrappedActionId(intention), it);
            }
        }
        if (shortcuts.length <= 1) {
            ActionManager actionManager = ActionManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance()");
            this.unregister(actionManager, intention);
        }
    }

    public final void promptForIntentionShortcut(@NotNull IntentionAction intention, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)intention, (String)"intention");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ActionManager actionManager = ActionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance()");
        this.register(actionManager, intention);
        KeymapManager km = KeymapManager.getInstance();
        KeymapManager keymapManager = km;
        if (keymapManager == null || (keymapManager = keymapManager.getActiveKeymap()) == null) {
            return;
        }
        KeymapManager activeKeymap = keymapManager;
        ApplicationManager.getApplication().invokeLater(() -> IntentionShortcutManager.promptForIntentionShortcut$lambda$1(project2, intention, (Keymap)activeKeymap));
    }

    private final void register(ActionManager $this$register, IntentionAction intention) {
        if (this.findIntentionWrapper($this$register, intention) == null) {
            $this$register.registerAction(IntentionShortcutUtils.getWrappedActionId(intention), (AnAction)new IntentionActionAsAction(intention));
        }
    }

    private final void unregister(ActionManager $this$unregister, IntentionAction intention) {
        $this$unregister.unregisterAction(IntentionShortcutUtils.getWrappedActionId(intention));
    }

    private final AnAction findIntentionWrapper(ActionManager $this$findIntentionWrapper, IntentionAction intention) {
        return $this$findIntentionWrapper.getAction(IntentionShortcutUtils.getWrappedActionId(intention));
    }

    @Nullable
    public final IntentionAction findIntention$intellij_platform_lang_impl(@NotNull String wrappedActionId) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)wrappedActionId, (String)"wrappedActionId");
            List<IntentionAction> list2 = IntentionManager.getInstance().getAvailableIntentions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance().availableIntentions");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IntentionAction it = (IntentionAction)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)IntentionShortcutUtils.getWrappedActionId(it), (Object)wrappedActionId)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final void registerIntentionsInActiveKeymap(ActionManager actionManager) {
        this.registerIntentionsInKeymap(actionManager, KeymapManager.getInstance().getActiveKeymap());
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect(this);
        Topic topic = KeymapManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, new KeymapManagerListener(this, actionManager){
            final /* synthetic */ IntentionShortcutManager this$0;
            final /* synthetic */ ActionManager $actionManager;
            {
                this.this$0 = $receiver;
                this.$actionManager = $actionManager;
            }

            public void activeKeymapChanged(@Nullable Keymap keymap) {
                IntentionShortcutManager.access$unregisterIntentionsInKeymap(this.this$0, this.$actionManager);
                IntentionShortcutManager.access$registerIntentionsInKeymap(this.this$0, this.$actionManager, keymap);
            }
        });
        IntentionManagerImpl.EP_INTENTION_ACTIONS.addExtensionPointListener(new ExtensionPointListener<IntentionActionBean>(this, actionManager){
            final /* synthetic */ IntentionShortcutManager this$0;
            final /* synthetic */ ActionManager $actionManager;
            {
                this.this$0 = $receiver;
                this.$actionManager = $actionManager;
            }

            public void extensionAdded(@NotNull IntentionActionBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                IntentionShortcutManager.access$registerIntentionsInKeymap(this.this$0, this.$actionManager, IntentionShortcutManager.access$getRegisteredKeymap$p(this.this$0));
            }

            public void extensionRemoved(@NotNull IntentionActionBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                IntentionShortcutManager.access$unregisterIntentionsInExtension(this.this$0, this.$actionManager, extension2);
            }
        }, this);
    }

    private final void registerIntentionsInKeymap(ActionManager $this$registerIntentionsInKeymap, Keymap keymap) {
        Sequence<IntentionAction> sequence = keymap;
        if (sequence != null && (sequence = this.wrappedIntentionActions((Keymap)sequence)) != null) {
            Sequence<IntentionAction> $this$forEach$iv = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntentionAction it = (IntentionAction)element$iv;
                boolean bl = false;
                this.register($this$registerIntentionsInKeymap, it);
            }
        }
        this.registeredKeymap = keymap;
    }

    private final void unregisterIntentionsInKeymap(ActionManager $this$unregisterIntentionsInKeymap) {
        Sequence<IntentionAction> sequence = this.registeredKeymap;
        if (sequence != null && (sequence = this.wrappedIntentionActions((Keymap)sequence)) != null) {
            Sequence<IntentionAction> $this$forEach$iv = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntentionAction it = (IntentionAction)element$iv;
                boolean bl = false;
                this.unregister($this$unregisterIntentionsInKeymap, it);
            }
        }
        this.registeredKeymap = null;
    }

    private final void unregisterIntentionsInExtension(ActionManager $this$unregisterIntentionsInExtension, IntentionActionBean extension2) {
        block1: {
            Sequence<IntentionAction> sequence = this.registeredKeymap;
            if (sequence == null || (sequence = this.wrappedIntentionActions((Keymap)sequence)) == null) break block1;
            Sequence<IntentionAction> $this$forEach$iv = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntentionAction intention = (IntentionAction)element$iv;
                boolean bl = false;
                if (!(intention instanceof IntentionActionWrapper) || !Intrinsics.areEqual((Object)((IntentionActionWrapper)intention).getImplementationClassName(), (Object)extension2.className)) continue;
                this.unregister($this$unregisterIntentionsInExtension, intention);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<IntentionAction> wrappedIntentionActions(Keymap $this$wrappedIntentionActions) {
        void $this$associateByTo$iv$iv;
        IntentionAction[] intentionActionArray = IntentionManager.getInstance().getIntentionActions();
        Intrinsics.checkNotNullExpressionValue((Object)intentionActionArray, (String)"getInstance().intentionActions");
        Object[] $this$associateBy$iv = intentionActionArray;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        Object[] objectArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IntentionAction intentionAction = (IntentionAction)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            map2.put(IntentionShortcutUtils.getWrappedActionId((IntentionAction)it), element$iv$iv);
        }
        Map intentionsById = destination$iv$iv;
        Collection collection = $this$wrappedIntentionActions.getActionIdList();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"actionIdList");
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)wrappedIntentionActions.1.INSTANCE), (Function1)((Function1)new Function1<String, IntentionAction>((Map<String, ? extends IntentionAction>)intentionsById){
            final /* synthetic */ Map<String, IntentionAction> $intentionsById;
            {
                this.$intentionsById = $intentionsById;
                super(1);
            }

            @Nullable
            public final IntentionAction invoke(String it) {
                return this.$intentionsById.get(it);
            }
        }));
    }

    @Override
    public void dispose() {
    }

    private static final void promptForIntentionShortcut$lambda$1(Project $project, IntentionAction $intention, Keymap $activeKeymap) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$intention, (String)"$intention");
        Intrinsics.checkNotNullParameter((Object)$activeKeymap, (String)"$activeKeymap");
        Window window = WindowManager.getInstance().suggestParentWindow($project);
        if (window == null) {
            return;
        }
        Window window2 = window;
        String actionId = IntentionShortcutUtils.getWrappedActionId($intention);
        ShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)shortcutRestrictions, (String)"getInstance().getForActionId(actionId)");
        ShortcutRestrictions action2 = shortcutRestrictions;
        KeymapPanel.addKeyboardShortcut((String)actionId, (ShortcutRestrictions)action2, (Keymap)$activeKeymap, (Component)window2, (QuickList[])new QuickList[0]);
    }

    @JvmStatic
    @NotNull
    public static final IntentionShortcutManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ void access$unregisterIntentionsInKeymap(IntentionShortcutManager $this, ActionManager $receiver) {
        $this.unregisterIntentionsInKeymap($receiver);
    }

    public static final /* synthetic */ void access$registerIntentionsInKeymap(IntentionShortcutManager $this, ActionManager $receiver, Keymap keymap) {
        $this.registerIntentionsInKeymap($receiver, keymap);
    }

    public static final /* synthetic */ Keymap access$getRegisteredKeymap$p(IntentionShortcutManager $this) {
        return $this.registeredKeymap;
    }

    public static final /* synthetic */ void access$unregisterIntentionsInExtension(IntentionShortcutManager $this, ActionManager $receiver, IntentionActionBean extension2) {
        $this.unregisterIntentionsInExtension($receiver, extension2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/intention/impl/IntentionShortcutManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/intention/impl/IntentionShortcutManager;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nIntentionShortcutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentionShortcutManager.kt\ncom/intellij/codeInsight/intention/impl/IntentionShortcutManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,151:1\n39#2,3:152\n*S KotlinDebug\n*F\n+ 1 IntentionShortcutManager.kt\ncom/intellij/codeInsight/intention/impl/IntentionShortcutManager$Companion\n*L\n147#1:152,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntentionShortcutManager getInstance() {
            boolean $i$f$service = false;
            Class<IntentionShortcutManager> serviceClass$iv = IntentionShortcutManager.class;
            IntentionShortcutManager intentionShortcutManager = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (intentionShortcutManager == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return intentionShortcutManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/intention/impl/IntentionShortcutManager$InitListener;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer;", "()V", "customize", "", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "intellij.platform.lang.impl"})
    public static final class InitListener
    implements ActionConfigurationCustomizer {
        public void customize(@NotNull ActionManager actionManager) {
            Intrinsics.checkNotNullParameter((Object)actionManager, (String)"actionManager");
            Companion.getInstance().registerIntentionsInActiveKeymap(actionManager);
        }
    }
}

