/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.QuickEditActionKeys;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickEditAction
extends QuickEditActionKeys
implements IntentionAction,
LowPriorityAction {
    public static final Key<QuickEditHandler> QUICK_EDIT_HANDLER = Key.create("QUICK_EDIT_HANDLER");
    private String myLastLanguageName;

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            QuickEditAction.$$$reportNull$$$0(0);
        }
        return this.getRangePair(file2, editor2) != null;
    }

    @Nullable
    protected Pair<PsiElement, TextRange> getRangePair(PsiFile file2, Editor editor2) {
        int offset2 = editor2.getCaretModel().getOffset();
        PsiLanguageInjectionHost host = PsiTreeUtil.getParentOfType(file2.findElementAt(offset2), PsiLanguageInjectionHost.class, false);
        if (host == null || host instanceof PsiComment || ElementManipulators.getManipulator(host) == null) {
            return null;
        }
        List<Pair<PsiElement, TextRange>> injections = InjectedLanguageManager.getInstance(host.getProject()).getInjectedPsiFiles(host);
        if (injections == null || injections.isEmpty()) {
            return null;
        }
        int offsetInElement = offset2 - host.getTextRange().getStartOffset();
        Pair rangePair = (Pair)((Object)ContainerUtil.find(injections, pair -> ((TextRange)pair.second).containsRange(offsetInElement, offsetInElement)));
        if (rangePair != null) {
            Language language = ((PsiElement)rangePair.first).getContainingFile().getLanguage();
            Object action2 = host.getUserData(EDIT_ACTION_AVAILABLE);
            if (action2 == null) {
                action2 = language.getUserData(EDIT_ACTION_AVAILABLE);
            }
            if (action2 != null && action2.equals(false)) {
                return null;
            }
            this.myLastLanguageName = language.getDisplayName();
        }
        return rangePair;
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            QuickEditAction.$$$reportNull$$$0(1);
        }
        this.invokeImpl(project2, editor2, file2);
    }

    public QuickEditHandler invokeImpl(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        DocumentWindow documentWindow;
        if (project2 == null) {
            QuickEditAction.$$$reportNull$$$0(2);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        Pair<PsiElement, TextRange> pair = Objects.requireNonNull(this.getRangePair(file2, editor2));
        PsiFile injectedFile = (PsiFile)pair.first;
        QuickEditHandler handler2 = this.getHandler(project2, injectedFile, editor2, file2);
        if (!ApplicationManager.getApplication().isUnitTestMode() && (documentWindow = InjectedLanguageUtil.getDocumentWindow(injectedFile)) != null) {
            handler2.navigate(InjectedLanguageUtil.hostToInjectedUnescaped(documentWindow, offset2));
        }
        return handler2;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private QuickEditHandler getHandler(Project project2, PsiFile injectedFile, Editor editor2, PsiFile origFile) {
        QuickEditHandler handler2 = QuickEditAction.getExistingHandler(injectedFile);
        if (handler2 != null && handler2.isValid()) {
            QuickEditHandler quickEditHandler = handler2;
            if (quickEditHandler == null) {
                QuickEditAction.$$$reportNull$$$0(3);
            }
            return quickEditHandler;
        }
        handler2 = new QuickEditHandler(project2, injectedFile, origFile, editor2, this);
        Disposer.register(project2, handler2);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            injectedFile.putUserData(QUICK_EDIT_HANDLER, handler2);
        }
        QuickEditHandler quickEditHandler = handler2;
        if (quickEditHandler == null) {
            QuickEditAction.$$$reportNull$$$0(4);
        }
        return quickEditHandler;
    }

    public static QuickEditHandler getExistingHandler(@NotNull PsiFile injectedFile) {
        DocumentWindow documentWindow;
        if (injectedFile == null) {
            QuickEditAction.$$$reportNull$$$0(5);
        }
        if ((documentWindow = InjectedLanguageUtil.getDocumentWindow(injectedFile)) == null) {
            return null;
        }
        Segment[] hostRanges = documentWindow.getHostRanges();
        TextRange hostRange = TextRange.create(hostRanges[0].getStartOffset(), hostRanges[hostRanges.length - 1].getEndOffset());
        for (Editor editor2 : EditorFactory.getInstance().getAllEditors()) {
            QuickEditHandler handler2 = (QuickEditHandler)editor2.getUserData(QUICK_EDIT_HANDLER);
            if (handler2 == null || !handler2.tryReuse(injectedFile, hostRange)) continue;
            return handler2;
        }
        return null;
    }

    protected boolean isShowInBalloon() {
        return false;
    }

    @Nullable
    protected JComponent createBalloonComponent(@NotNull PsiFile file2) {
        if (file2 == null) {
            QuickEditAction.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = CodeInsightBundle.message("intention.text.edit.0.fragment", StringUtil.notNullize(this.myLastLanguageName, CodeInsightBundle.message("name.for.injected.file.default.lang.name", new Object[0])));
        if (string2 == null) {
            QuickEditAction.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message("intention.family.edit.injected.fragment", new Object[0]);
        if (string2 == null) {
            QuickEditAction.$$$reportNull$$$0(8);
        }
        return string2;
    }

    public static Balloon.Position getBalloonPosition(Editor editor2) {
        int line = editor2.getCaretModel().getVisualPosition().line;
        Rectangle area = editor2.getScrollingModel().getVisibleArea();
        int startLine = area.y / editor2.getLineHeight() + 1;
        return (line - startLine) * editor2.getLineHeight() < 200 ? Balloon.Position.below : Balloon.Position.above;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/QuickEditAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/QuickEditAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExistingHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

