/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.injected.editor.InjectedFileChangesHandler;
import com.intellij.injected.editor.InjectedFileChangesHandlerProvider;
import com.intellij.injected.editor.InjectionMeta;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.changesHandler.CommonInjectedFileChangesHandler;
import com.intellij.psi.impl.source.tree.injected.changesHandler.IndentAwareInjectedFileChangesHandler;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class QuickEditHandler
extends UserDataHolderBase
implements Disposable,
DocumentListener {
    private final Project myProject;
    private final QuickEditAction myAction;
    @NotNull
    private final Editor myEditor;
    private final Document myOrigDocument;
    @NotNull
    private final Document myNewDocument;
    private final PsiFile myNewFile;
    private final LightVirtualFile myNewVirtualFile;
    private final long myOrigCreationStamp;
    private EditorWindow mySplittedWindow;
    private boolean myCommittingToOriginal;
    @NotNull
    private final InjectedFileChangesHandler myEditChangesHandler;
    public static final Key<String> REPLACEMENT_KEY = Key.create("REPLACEMENT_KEY");
    private static final Key<Set<QuickEditHandler>> QUICK_EDIT_HANDLERS = Key.create("QUICK_EDIT_HANDLERS");

    QuickEditHandler(@NotNull Project project2, @NotNull PsiFile injectedFile, @NotNull PsiFile origFile, @NotNull Editor editor2, @NotNull QuickEditAction action2) {
        if (project2 == null) {
            QuickEditHandler.$$$reportNull$$$0(0);
        }
        if (injectedFile == null) {
            QuickEditHandler.$$$reportNull$$$0(1);
        }
        if (origFile == null) {
            QuickEditHandler.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            QuickEditHandler.$$$reportNull$$$0(3);
        }
        if (action2 == null) {
            QuickEditHandler.$$$reportNull$$$0(4);
        }
        this.myProject = project2;
        this.myEditor = editor2;
        this.myAction = action2;
        this.myOrigDocument = editor2.getDocument();
        Place shreds = InjectedLanguageUtilBase.getShreds(injectedFile);
        FileType fileType = injectedFile.getFileType();
        Language language = injectedFile.getLanguage();
        PsiLanguageInjectionHost.Shred firstShred = ContainerUtil.getFirstItem(shreds);
        PsiFileFactory factory2 = PsiFileFactory.getInstance(project2);
        String text2 = InjectedLanguageManager.getInstance(project2).getUnescapedText(injectedFile);
        @Nls String newFileName = CodeInsightBundle.message("name.for.injected.file.0.fragment.1.2.3", StringUtil.notNullize(language.getDisplayName(), CodeInsightBundle.message("name.for.injected.file.default.lang.name", new Object[0])), origFile.getName(), firstShred.getHost().getTextRange().getStartOffset(), fileType.getDefaultExtension());
        this.myNewFile = factory2.createFileFromText(newFileName, language, (CharSequence)text2, true, false);
        this.myNewVirtualFile = Objects.requireNonNull((LightVirtualFile)this.myNewFile.getVirtualFile());
        this.myNewVirtualFile.setOriginalFile(injectedFile.getVirtualFile());
        assert (this.myNewFile.getTextLength() == this.myNewVirtualFile.getContent().length()) : "PSI / Virtual file text mismatch";
        this.myNewFile.putUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION, injectedFile.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION));
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(project2).getInjectionHost(injectedFile.getViewProvider());
        this.myNewFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, SmartPointerManager.getInstance(project2).createSmartPsiElementPointer(host));
        this.myNewDocument = Objects.requireNonNull(PsiDocumentManager.getInstance(project2).getDocument(this.myNewFile), "doc for file " + this.myNewFile.getName());
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myNewDocument, (ReadonlyFragmentModificationHandler)new MyQuietHandler());
        this.myOrigCreationStamp = this.myOrigDocument.getModificationStamp();
        EditorFactory editorFactory = Objects.requireNonNull(EditorFactory.getInstance());
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){
            int useCount;

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getEditor().getDocument() != QuickEditHandler.this.myNewDocument) {
                    return;
                }
                ++this.useCount;
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEditor().getDocument() == QuickEditHandler.this.myOrigDocument) {
                    ApplicationManager.getApplication().invokeLater(() -> QuickEditHandler.this.closeEditor(), QuickEditHandler.this.myProject.getDisposed());
                    return;
                }
                if (event.getEditor().getDocument() != QuickEditHandler.this.myNewDocument) {
                    return;
                }
                if (--this.useCount > 0) {
                    return;
                }
                if (Boolean.TRUE.equals(QuickEditHandler.this.myNewVirtualFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    return;
                }
                Disposer.dispose(QuickEditHandler.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/QuickEditHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        InjectedFileChangesHandlerProvider changesHandlerFactory = (InjectedFileChangesHandlerProvider)InjectedFileChangesHandlerProvider.EP.forLanguage(firstShred.getHost().getLanguage());
        this.myEditChangesHandler = changesHandlerFactory != null ? changesHandlerFactory.createFileChangesHandler((List)shreds, editor2, this.myNewDocument, injectedFile) : (ContainerUtil.or(shreds, it -> InjectionMeta.INJECTION_INDENT.get(it.getHost()) != null) ? new IndentAwareInjectedFileChangesHandler(shreds, editor2, this.myNewDocument, injectedFile) : new CommonInjectedFileChangesHandler(shreds, editor2, this.myNewDocument, injectedFile));
        Disposer.register(this, (Disposable)this.myEditChangesHandler);
        ((StreamEx)StreamEx.of((Collection)shreds).map(it -> it.getHost()).nonNull().distinct()).forEach(h -> {
            Set<QuickEditHandler> editHandlers = h.getCopyableUserData(QUICK_EDIT_HANDLERS);
            if (editHandlers == null) {
                editHandlers = new SmartHashSet<QuickEditHandler>();
                h.putCopyableUserData(QUICK_EDIT_HANDLERS, editHandlers);
            }
            editHandlers.add(this);
            Set<QuickEditHandler> finalEditHandlers = editHandlers;
            Disposer.register(this, () -> finalEditHandlers.remove(this));
        });
        this.initGuardedBlocks(shreds);
        this.myOrigDocument.addDocumentListener(this, this);
        this.myNewDocument.addDocumentListener(this, this);
    }

    @NotNull
    public static Set<QuickEditHandler> getFragmentEditors(@NotNull PsiLanguageInjectionHost host) {
        Set<QuickEditHandler> handlers2;
        if (host == null) {
            QuickEditHandler.$$$reportNull$$$0(5);
        }
        if ((handlers2 = host.getCopyableUserData(QUICK_EDIT_HANDLERS)) == null) {
            Set<QuickEditHandler> set2 = Collections.emptySet();
            if (set2 == null) {
                QuickEditHandler.$$$reportNull$$$0(6);
            }
            return set2;
        }
        Set<QuickEditHandler> set3 = handlers2;
        if (set3 == null) {
            QuickEditHandler.$$$reportNull$$$0(7);
        }
        return set3;
    }

    public boolean isValid() {
        return this.myNewVirtualFile.isValid() && this.myEditChangesHandler.isValid();
    }

    public void navigate(int injectedOffset) {
        if (this.myAction.isShowInBalloon()) {
            JComponent component2 = this.myAction.createBalloonComponent(this.myNewFile);
            if (component2 != null) {
                QuickEditHandler.showBalloon(this.myEditor, this.myNewFile, component2);
            }
        } else {
            Editor editor2;
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)this.myProject);
            FileEditor[] editors2 = fileEditorManager.getEditors((VirtualFile)this.myNewVirtualFile);
            if (editors2.length == 0) {
                EditorWindow currentWindow = fileEditorManager.getCurrentWindow();
                this.mySplittedWindow = Objects.requireNonNull(currentWindow).split(0, false, (VirtualFile)this.myNewVirtualFile, true);
            }
            if ((editor2 = fileEditorManager.openTextEditor(new OpenFileDescriptor(this.myProject, this.myNewVirtualFile, injectedOffset), true)) instanceof EditorEx) {
                editor2.putUserData(QuickEditAction.QUICK_EDIT_HANDLER, (Object)this);
                FoldingModelEx foldingModel = ((EditorEx)editor2).getFoldingModel();
                foldingModel.runBatchFoldingOperation(() -> {
                    CharSequence sequence = this.myNewDocument.getImmutableCharSequence();
                    for (RangeMarker o : ContainerUtil.reverse(((DocumentEx)this.myNewDocument).getGuardedBlocks())) {
                        String replacement = o.getUserData(REPLACEMENT_KEY);
                        if (StringUtil.isEmpty(replacement)) continue;
                        int start = o.getStartOffset();
                        int end = o.getEndOffset();
                        if ((start += StringUtil.countChars(sequence, '\n', start, end, true)) > (end -= StringUtil.countChars(sequence, '\n', end, start, true))) continue;
                        FoldRegion region = foldingModel.getFoldRegion(start, end);
                        if (region == null) {
                            region = foldingModel.createFoldRegion(start, end, replacement, null, true);
                        }
                        if (region == null) continue;
                        region.setExpanded(false);
                    }
                });
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER), ModalityState.any());
    }

    public static void showBalloon(Editor editor2, PsiFile newFile, JComponent component2) {
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(component2).setShadow(true).setAnimationCycle(0).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnAction(false).setFillColor(UIUtil.getPanelBackground()).createBalloon();
        DumbAwareAction.create(e -> balloon.hide()).registerCustomShortcutSet(CommonShortcuts.ESCAPE, component2);
        Disposer.register(newFile.getProject(), (Disposable)balloon);
        Balloon.Position position = QuickEditAction.getBalloonPosition(editor2);
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(editor2);
        if (position == Balloon.Position.above) {
            Point p = point.getPoint();
            point = new RelativePoint(point.getComponent(), new Point(p.x, p.y - editor2.getLineHeight()));
        }
        balloon.show(point, position);
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            QuickEditHandler.$$$reportNull$$$0(8);
        }
        if (UndoManager.getInstance(this.myProject).isUndoOrRedoInProgress()) {
            if (e.getDocument() == this.myOrigDocument) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myOrigCreationStamp > this.myOrigDocument.getModificationStamp()) {
                        this.closeEditor();
                    }
                }, this.myProject.getDisposed());
            }
        } else if (e.getDocument() == this.myNewDocument) {
            this.commitToOriginal(e);
            if (!this.isValid()) {
                ApplicationManager.getApplication().invokeLater(() -> this.closeEditor(), this.myProject.getDisposed());
            }
        } else if (e.getDocument() == this.myOrigDocument) {
            if (this.myCommittingToOriginal) {
                return;
            }
            InjectedFileChangesHandler injectedFileChangesHandler = Objects.requireNonNull(this.myEditChangesHandler, "seems that 'myEditChangesHandler' was not initialized");
            if (!injectedFileChangesHandler.handlesRange(TextRange.from(e.getOffset(), e.getOldLength()))) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                this.closeEditor();
                if (owner != null) {
                    owner.requestFocus();
                }
            }, this.myProject.getDisposed());
        }
    }

    private void closeEditor() {
        List editors2;
        boolean unsplit = false;
        if (this.mySplittedWindow != null && !this.mySplittedWindow.isDisposed() && (editors2 = this.mySplittedWindow.getAllComposites()).size() == 1 && Comparing.equal(((EditorComposite)editors2.get(0)).getFile(), this.myNewVirtualFile)) {
            unsplit = true;
        }
        if (unsplit) {
            ((FileEditorManagerImpl)FileEditorManager.getInstance(this.myProject)).closeFile((VirtualFile)this.myNewVirtualFile, this.mySplittedWindow);
        }
        FileEditorManager.getInstance(this.myProject).closeFile(this.myNewVirtualFile);
    }

    @TestOnly
    public void closeEditorForTest() {
        this.closeEditor();
    }

    private void initGuardedBlocks(Place shreds) {
        int origOffset = -1;
        int curOffset = 0;
        for (PsiLanguageInjectionHost.Shred shred : shreds) {
            Segment hostRangeMarker = shred.getHostRangeMarker();
            int start = shred.getRange().getStartOffset() + shred.getPrefix().length();
            int end = shred.getRange().getEndOffset() - shred.getSuffix().length();
            if (curOffset < start) {
                RangeMarker guard = this.myNewDocument.createGuardedBlock(curOffset, start);
                if (curOffset == 0 && shred == shreds.get(0)) {
                    guard.setGreedyToLeft(true);
                }
                String padding = origOffset < 0 ? "" : this.myOrigDocument.getText().substring(origOffset, hostRangeMarker.getStartOffset());
                guard.putUserData(REPLACEMENT_KEY, QuickEditHandler.fixQuotes(padding));
            }
            curOffset = end;
            origOffset = hostRangeMarker.getEndOffset();
        }
        if (curOffset < this.myNewDocument.getTextLength()) {
            RangeMarker guard = this.myNewDocument.createGuardedBlock(curOffset, this.myNewDocument.getTextLength());
            guard.setGreedyToRight(true);
            guard.putUserData(REPLACEMENT_KEY, "");
        }
    }

    private void commitToOriginal(DocumentEvent e) {
        this.myCommittingToOriginal = true;
        try {
            PostprocessReformattingAspect.getInstance((Project)this.myProject).disablePostprocessFormattingInside(() -> this.myEditChangesHandler.commitToOriginal(e));
            PsiDocumentManager.getInstance(this.myProject).doPostponedOperationsAndUnblockDocument(this.myOrigDocument);
        }
        finally {
            this.myCommittingToOriginal = false;
        }
    }

    private static String fixQuotes(String padding) {
        if (((String)padding).isEmpty()) {
            return padding;
        }
        if (((String)padding).startsWith("'")) {
            padding = "\"" + ((String)padding).substring(1);
        }
        if (((String)padding).endsWith("'")) {
            padding = ((String)padding).substring(0, ((String)padding).length() - 1) + "\"";
        }
        return padding;
    }

    @Override
    public void dispose() {
    }

    @TestOnly
    public PsiFile getNewFile() {
        return this.myNewFile;
    }

    public boolean tryReuse(@NotNull PsiFile injectedFile, @NotNull TextRange hostRange) {
        if (injectedFile == null) {
            QuickEditHandler.$$$reportNull$$$0(9);
        }
        if (hostRange == null) {
            QuickEditHandler.$$$reportNull$$$0(10);
        }
        return this.myEditChangesHandler.tryReuse(injectedFile, hostRange);
    }

    @Override
    public String toString() {
        return "QuickEditHandler@" + this.hashCode() + super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/QuickEditHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/QuickEditHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragmentEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentEditors";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryReuse";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7 -> new IllegalStateException(string2);
        };
    }

    private static class MyQuietHandler
    implements ReadonlyFragmentModificationHandler {
        private MyQuietHandler() {
        }

        @Override
        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }
}

