/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.statistic.IntentionsCollector;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.util.PairProcessor;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(ShowIntentionActionsHandler.class);

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(2);
        }
        this.invoke(project2, editor2, file2, false);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, boolean showFeedbackOnEmptyMenu) {
        LookupEx lookup2;
        if (project2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
            file2 = InjectedLanguageManager.getInstance(file2.getProject()).getTopLevelFile(file2);
        }
        if ((lookup2 = LookupManager.getActiveLookup(editor2)) != null) {
            lookup2.showElementActions(null);
            return;
        }
        if (!LightEdit.owns((Project)project2)) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
            ShowIntentionActionsHandler.letAutoImportComplete(editor2, file2, codeAnalyzer);
        }
        IntentionsUI.getInstance(project2).hide();
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor2);
        if (state != null && !state.isFinished()) {
            CommandProcessor.getInstance().executeCommand(project2, () -> state.gotoEnd(false), LangBundle.message("command.name.finish.template", new Object[0]), null);
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.showIntentionHint(project2, editor2, file2, ShowIntentionActionsHandler.calcIntentions(project2, editor2, file2), showFeedbackOnEmptyMenu);
    }

    protected void showIntentionHint(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull ShowIntentionsPass.IntentionsInfo intentions, boolean showFeedbackOnEmptyMenu) {
        if (project2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(8);
        }
        if (intentions == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(9);
        }
        if (!intentions.isEmpty()) {
            editor2.getScrollingModel().runActionOnScrollingFinished(() -> {
                CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project2, file2, editor2, intentions);
                cachedIntentions.wrapAndUpdateGutters();
                if (cachedIntentions.getAllActions().isEmpty()) {
                    ShowIntentionActionsHandler.showEmptyMenuFeedback(editor2, showFeedbackOnEmptyMenu);
                } else {
                    IntentionHintComponent.showIntentionHint(project2, file2, editor2, true, cachedIntentions);
                }
            });
        } else {
            ShowIntentionActionsHandler.showEmptyMenuFeedback(editor2, showFeedbackOnEmptyMenu);
        }
    }

    private static void showEmptyMenuFeedback(@NotNull Editor editor2, boolean showFeedbackOnEmptyMenu) {
        if (editor2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(10);
        }
        if (showFeedbackOnEmptyMenu) {
            HintManager.getInstance().showInformationHint(editor2, LangBundle.message("hint.text.no.context.actions.available.at.this.location", new Object[0]));
        }
    }

    @NotNull
    @ApiStatus.Internal
    public static ShowIntentionsPass.IntentionsInfo calcIntentions(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("must not wait for intentions inside write action");
        }
        String progressTitle2 = CodeInsightBundle.message("progress.title.searching.for.context.actions", new Object[0]);
        DumbService dumbService = DumbService.getInstance(project2);
        boolean useAlternativeResolve = dumbService.isAlternativeResolveEnabled();
        ThrowableComputable prioritizedRunnable = () -> ProgressManager.getInstance().computePrioritized(() -> {
            DaemonCodeAnalyzerImpl.waitForUnresolvedReferencesQuickFixesUnderCaret(file2, editor2);
            return ReadAction.compute(() -> ShowIntentionsPass.getActionsToShow(editor2, file2, false));
        });
        ThrowableComputable process2 = useAlternativeResolve ? () -> (ShowIntentionsPass.IntentionsInfo)dumbService.computeWithAlternativeResolveEnabled(prioritizedRunnable) : prioritizedRunnable;
        ShowIntentionsPass.IntentionsInfo intentions = ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, progressTitle2, true, project2);
        ShowIntentionsPass.getActionsToShowSync(editor2, file2, intentions);
        ShowIntentionsPass.IntentionsInfo intentionsInfo = intentions;
        if (intentionsInfo == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(14);
        }
        return intentionsInfo;
    }

    private static void letAutoImportComplete(@NotNull Editor editor2, @NotNull PsiFile file2, DaemonCodeAnalyzerImpl codeAnalyzer) {
        if (editor2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(16);
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> codeAnalyzer.autoImportReferenceAtCursor(editor2, file2));
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    public static boolean availableFor(@NotNull PsiFile psiFile, @NotNull Editor editor2, @NotNull IntentionAction action2) {
        if (psiFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(17);
        }
        if (editor2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(18);
        }
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(19);
        }
        if (!psiFile.isValid()) {
            return false;
        }
        try {
            Project project2 = psiFile.getProject();
            action2 = IntentionActionDelegate.unwrap(action2);
            if (action2 instanceof SuppressIntentionActionFromFix) {
                ThreeState shouldBeAppliedToInjectionHost = ((SuppressIntentionActionFromFix)action2).isShouldBeAppliedToInjectionHost();
                if (editor2 instanceof EditorWindow && shouldBeAppliedToInjectionHost == ThreeState.YES) {
                    return false;
                }
                if (!(editor2 instanceof EditorWindow) && shouldBeAppliedToInjectionHost == ThreeState.NO) {
                    return false;
                }
            }
            if (action2 instanceof PsiElementBaseIntentionAction) {
                PsiElementBaseIntentionAction psiAction = (PsiElementBaseIntentionAction)action2;
                if (!psiAction.checkFile(psiFile)) {
                    return false;
                }
                PsiElement leaf = psiFile.findElementAt(editor2.getCaretModel().getOffset());
                if (leaf == null || !psiAction.isAvailable(project2, editor2, leaf)) {
                    return false;
                }
            } else if (!action2.isAvailable(project2, editor2, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e) {
            return false;
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            return false;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseBetweenHostAndInjected(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @Nullable PsiFile injectedFile, @NotNull PairProcessor<? super PsiFile, ? super Editor> predicate2) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(20);
        }
        if (hostEditor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(21);
        }
        if (predicate2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(22);
        }
        try {
            Editor editorToApply = null;
            PsiFile fileToApply = null;
            Editor injectedEditor = null;
            if (injectedFile != null && !(hostEditor instanceof IntentionPreviewEditor) && predicate2.process(injectedFile, (Editor)(injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, injectedFile)))) {
                editorToApply = injectedEditor;
                fileToApply = injectedFile;
            }
            if (editorToApply == null && hostEditor != injectedEditor && predicate2.process(hostFile, (Editor)hostEditor)) {
                editorToApply = hostEditor;
                fileToApply = hostFile;
            }
            if (editorToApply == null) {
                return null;
            }
            return Pair.create(fileToApply, editorToApply);
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            return null;
        }
    }

    public static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action2, @NotNull @NlsContexts.Command String commandName2) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(23);
        }
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(24);
        }
        if (commandName2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(25);
        }
        Project project2 = hostFile.getProject();
        ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats().registerInvocation();
        try (AccessToken ignored = SlowOperations.startSection("action.perform");){
            PsiDocumentManager.getInstance(project2).commitAllDocuments();
            Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(hostFile, hostEditor, action2);
            if (pair == null) {
                boolean bl = false;
                return bl;
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> ShowIntentionActionsHandler.invokeIntention(action2, (Editor)pair.second, (PsiFile)pair.first), commandName2, null);
            ShowIntentionActionsHandler.checkPsiTextConsistency(hostFile);
        }
        return true;
    }

    private static void checkPsiTextConsistency(@NotNull PsiFile hostFile) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(26);
        }
        if ((Registry.is("ide.check.stub.text.consistency") || ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest()) && hostFile.isValid()) {
            StubTextInconsistencyException.checkStubTextConsistency(hostFile);
        }
    }

    private static void invokeIntention(@NotNull IntentionAction action2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(28);
        }
        IntentionsCollector.record(file2.getProject(), action2, file2.getLanguage());
        PsiElement elementToMakeWritable = action2.getElementToMakeWritable(file2);
        if (elementToMakeWritable != null && !FileModificationService.getInstance().preparePsiElementsForWrite(elementToMakeWritable)) {
            return;
        }
        if (action2.startInWriteAction()) {
            WriteAction.run(() -> action2.invoke(file2.getProject(), editor2, file2));
        } else {
            action2.invoke(file2.getProject(), editor2, file2);
        }
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseFileForAction(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action2) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(29);
        }
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(30);
        }
        if (hostEditor == null) {
            return Pair.create(hostFile, null);
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, hostEditor.getCaretModel().getOffset());
        return ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, injectedFile, (psiFile, editor2) -> ShowIntentionActionsHandler.availableFor(psiFile, editor2, action2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 19: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcIntentions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showIntentionHint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showEmptyMenuFeedback";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcIntentions";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "letAutoImportComplete";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "availableFor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "chooseBetweenHostAndInjected";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "chooseActionAndInvoke";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiTextConsistency";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "invokeIntention";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "chooseFileForAction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 14 -> new IllegalStateException(string2);
        };
    }
}

