/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ex.ToolLanguageUtil;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionWrapper
implements IntentionAction,
ShortcutProvider,
IntentionActionDelegate,
PossiblyDumbAware,
Comparable<IntentionAction> {
    private final IntentionActionBean extension;
    private String fullFamilyName;
    private volatile Set<String> applicableToLanguages;

    public IntentionActionWrapper(@NotNull IntentionActionBean extension2) {
        if (extension2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(0);
        }
        this.extension = extension2;
    }

    @NotNull
    public String getDescriptionDirectoryName() {
        return IntentionActionWrapper.getDescriptionDirectoryName(this.getImplementationClassName());
    }

    @NotNull
    static String getDescriptionDirectoryName(@NotNull String fqn) {
        if (fqn == null) {
            IntentionActionWrapper.$$$reportNull$$$0(1);
        }
        String string2 = fqn.substring(fqn.lastIndexOf(46) + 1).replaceAll("\\$", "");
        if (string2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = this.getDelegate().getText();
        if (string2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = this.getDelegate().getFamilyName();
        if (string2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public boolean isApplicable(@NotNull Collection<String> fileLanguageIds) {
        String language;
        if (fileLanguageIds == null) {
            IntentionActionWrapper.$$$reportNull$$$0(5);
        }
        if ((language = this.extension.language) == null || "any".equals(language) || language.isBlank()) {
            return true;
        }
        Set<String> languages = this.applicableToLanguages;
        if (languages == null) {
            this.applicableToLanguages = languages = ToolLanguageUtil.getAllMatchingLanguages(language, true);
        }
        return ContainerUtil.intersects(fileLanguageIds, languages);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(6);
        }
        return this.getDelegate().isAvailable(project2, editor2, file2);
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(7);
        }
        this.getDelegate().invoke(project2, editor2, file2);
    }

    @Override
    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(10);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.getDelegate().generatePreview(project2, editor2, file2);
        if (intentionPreviewInfo == null) {
            IntentionActionWrapper.$$$reportNull$$$0(11);
        }
        return intentionPreviewInfo;
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(12);
        }
        return this.getDelegate().getElementToMakeWritable(file2);
    }

    @NotNull
    public String getFullFamilyName() {
        String result2 = this.fullFamilyName;
        if (result2 == null) {
            CharSequence[] categories = this.extension.getCategories();
            result2 = categories != null ? String.join((CharSequence)"/", categories) + "/" + this.getFamilyName() : this.getFamilyName();
            this.fullFamilyName = result2;
        }
        String string2 = result2;
        if (string2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Override
    public boolean isDumbAware() {
        return DumbService.isDumbAware(this.getDelegate());
    }

    @Override
    @NotNull
    public IntentionAction getDelegate() {
        IntentionAction intentionAction = (IntentionAction)this.extension.getInstance();
        if (intentionAction == null) {
            IntentionActionWrapper.$$$reportNull$$$0(14);
        }
        return intentionAction;
    }

    @Override
    @NotNull
    public String getImplementationClassName() {
        String string2 = this.extension.className;
        if (string2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    ClassLoader getImplementationClassLoader() {
        ClassLoader classLoader = this.extension.getLoaderForClass();
        if (classLoader == null) {
            IntentionActionWrapper.$$$reportNull$$$0(16);
        }
        return classLoader;
    }

    public String toString() {
        String text2;
        try {
            text2 = this.getText();
        }
        catch (PsiInvalidElementAccessException e) {
            text2 = e.getMessage();
        }
        return "Intention: (" + this.getDelegate().getClass() + "): '" + text2 + "'";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getDelegate().equals(obj);
    }

    @Override
    @Nullable
    public ShortcutSet getShortcut() {
        IntentionAction delegate2 = this.getDelegate();
        return delegate2 instanceof ShortcutProvider ? ((ShortcutProvider)((Object)delegate2)).getShortcut() : null;
    }

    @Override
    public int compareTo(@NotNull IntentionAction other) {
        if (other == null) {
            IntentionActionWrapper.$$$reportNull$$$0(17);
        }
        if (other instanceof IntentionActionWrapper) {
            IntentionAction action1 = this.getDelegate();
            IntentionAction action2 = ((IntentionActionWrapper)other).getDelegate();
            if (action1 instanceof Comparable && action2 instanceof Comparable) {
                return ((Comparable)((Object)action1)).compareTo(action2);
            }
        }
        return this.getText().compareTo(other.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 11, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguageIds";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionDirectoryName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFamilyName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClassName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionDirectoryName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 11, 13, 14, 15, 16 -> new IllegalStateException(string2);
        };
    }
}

