/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionUsagePanel;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPane;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPaneKt;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SettingsUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IntentionDescriptionPanel {
    private static final Logger LOG = Logger.getInstance(IntentionDescriptionPanel.class);
    private final JPanel myPanel;
    private final JPanel myAfterPanel;
    private final JPanel myBeforePanel;
    private final DescriptionEditorPane myDescriptionBrowser;
    private final List<IntentionUsagePanel> myBeforeUsagePanels = new ArrayList<IntentionUsagePanel>();
    private final List<IntentionUsagePanel> myAfterUsagePanels = new ArrayList<IntentionUsagePanel>();
    @NonNls
    private static final String BEFORE_TEMPLATE = "before.java.template";
    @NonNls
    private static final String AFTER_TEMPLATE = "after.java.template";
    private static final float DIVIDER_PROPORTION_DEFAULT = 0.25f;

    public IntentionDescriptionPanel() {
        this.myDescriptionBrowser = new DescriptionEditorPane();
        JScrollPane descriptionScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myDescriptionBrowser);
        descriptionScrollPane.setBorder(null);
        JPanel examplePanel = new JPanel(new GridBagLayout());
        GridBag constraint = new GridBag().setDefaultInsets(12, 0, 0, 0).setDefaultFill(1).setDefaultWeightY(0.5).setDefaultWeightX(1.0);
        this.myBeforePanel = new JPanel();
        examplePanel.add((Component)UI.PanelFactory.panel((JComponent)this.myBeforePanel).withLabel(CodeInsightBundle.message("border.title.before", new Object[0])).moveLabelOnTop().resizeX(true).resizeY(true).createPanel(), constraint.nextLine());
        this.myAfterPanel = new JPanel();
        examplePanel.add((Component)UI.PanelFactory.panel((JComponent)this.myAfterPanel).withLabel(CodeInsightBundle.message("border.title.after", new Object[0])).moveLabelOnTop().resizeX(true).resizeY(true).createPanel(), constraint.nextLine());
        OnePixelSplitter mySplitter = new OnePixelSplitter(true, "IntentionDescriptionPanel.VERTICAL_DIVIDER_PROPORTION", 0.25f);
        mySplitter.setFirstComponent((JComponent)descriptionScrollPane);
        mySplitter.setSecondComponent((JComponent)examplePanel);
        this.myPanel = mySplitter;
        this.myDescriptionBrowser.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    URI url = new URI(e.getDescription());
                    if (url.getScheme().equals("settings")) {
                        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context2 -> {
                            if (context2 != null) {
                                Settings settings = (Settings)Settings.KEY.getData(context2);
                                SearchTextField searchTextField = (SearchTextField)SearchTextField.KEY.getData(context2);
                                String configId = url.getHost();
                                String search2 = url.getQuery();
                                if (settings != null) {
                                    Configurable configurable2 = settings.find(configId);
                                    settings.select(configurable2).doWhenDone(() -> {
                                        if (searchTextField != null && search2 != null) {
                                            searchTextField.setText(search2);
                                        }
                                    });
                                } else {
                                    Project project2 = (Project)context2.getData(CommonDataKeys.PROJECT);
                                    ShowSettingsUtilImpl.showSettingsDialog((Project)project2, (String)configId, (String)search2);
                                }
                            }
                        });
                    } else {
                        BrowserUtil.browse((URI)url);
                    }
                }
                catch (URISyntaxException ex) {
                    LOG.error(ex);
                }
            }
        });
    }

    public void reset(IntentionActionMetaData actionMetaData, String filter2) {
        try {
            TextDescriptor url = actionMetaData.getDescription();
            String description = StringUtil.isEmpty(url.getText()) ? CodeInsightBundle.message("under.construction.string", new Object[0]) : SearchUtil.markup((String)SettingsUtil.wrapWithPoweredByMessage(url.getText(), actionMetaData.getLoader()), (String)filter2);
            DescriptionEditorPaneKt.readHTML(this.myDescriptionBrowser, description);
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeUsagePanels, actionMetaData.getExampleUsagesBefore());
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterUsagePanels, actionMetaData.getExampleUsagesAfter());
            SwingUtilities.invokeLater(() -> this.myPanel.revalidate());
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public void reset(String intentionCategory) {
        try {
            DescriptionEditorPaneKt.readHTML(this.myDescriptionBrowser, CodeInsightBundle.message("intention.settings.category.text", intentionCategory));
            PlainTextDescriptor beforeTemplate = new PlainTextDescriptor(CodeInsightBundle.message("templates.intention.settings.category.before", new Object[0]), BEFORE_TEMPLATE);
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeUsagePanels, new TextDescriptor[]{beforeTemplate});
            PlainTextDescriptor afterTemplate = new PlainTextDescriptor(CodeInsightBundle.message("templates.intention.settings.category.after", new Object[0]), AFTER_TEMPLATE);
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterUsagePanels, new TextDescriptor[]{afterTemplate});
            SwingUtilities.invokeLater(() -> this.myPanel.revalidate());
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void showUsages(JPanel panel2, List<IntentionUsagePanel> usagePanels, TextDescriptor @Nullable [] exampleUsages) throws IOException {
        boolean reuse;
        GridBagConstraints gb = null;
        boolean bl = reuse = exampleUsages != null && panel2.getComponents().length == exampleUsages.length;
        if (!reuse) {
            IntentionDescriptionPanel.disposeUsagePanels(usagePanels);
            panel2.setLayout(new GridBagLayout());
            panel2.removeAll();
            gb = new GridBagConstraints();
            gb.anchor = 18;
            gb.fill = 1;
            gb.gridheight = 0;
            gb.gridwidth = 1;
            gb.gridx = 0;
            gb.gridy = 0;
            gb.insets = JBUI.emptyInsets();
            gb.ipadx = 5;
            gb.ipady = 5;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
        }
        if (exampleUsages != null) {
            for (int i2 = 0; i2 < exampleUsages.length; ++i2) {
                IntentionUsagePanel usagePanel;
                TextDescriptor exampleUsage = exampleUsages[i2];
                String name = exampleUsage.getFileName();
                FileTypeManagerEx fileTypeManager = FileTypeManagerEx.getInstanceEx();
                String extension2 = fileTypeManager.getExtension(name);
                FileType fileType = fileTypeManager.getFileTypeByExtension(extension2);
                if (reuse) {
                    usagePanel = (IntentionUsagePanel)panel2.getComponent(i2);
                } else {
                    usagePanel = new IntentionUsagePanel();
                    usagePanels.add(usagePanel);
                }
                usagePanel.reset(exampleUsage.getText(), fileType);
                if (reuse) continue;
                panel2.add((Component)usagePanel, gb);
                ++gb.gridx;
            }
        }
        panel2.revalidate();
        panel2.repaint();
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void dispose() {
        IntentionDescriptionPanel.disposeUsagePanels(this.myBeforeUsagePanels);
        IntentionDescriptionPanel.disposeUsagePanels(this.myAfterUsagePanels);
    }

    private static void disposeUsagePanels(List<? extends IntentionUsagePanel> usagePanels) {
        for (IntentionUsagePanel intentionUsagePanel : usagePanels) {
            Disposer.dispose(intentionUsagePanel);
        }
        usagePanels.clear();
    }

    @Deprecated
    public void init(int preferredWidth) {
    }
}

