/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettingsKt;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.IntentionsMetadataService;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(value="intentionSettings.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\b\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "ignoredActions", "", "", "getMetaData", "", "Lcom/intellij/codeInsight/intention/impl/config/IntentionActionMetaData;", "getState", "isEnabled", "", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "metaData", "isShowLightBulb", "loadState", "", "element", "setEnabled", "enabled", "unregisterMetaData", "intentionAction", "Companion", "IntentionSearchableOptionContributor", "intellij.platform.lang.impl"})
public final class IntentionManagerSettings
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private volatile Set<String> ignoredActions = SetsKt.emptySet();

    public final boolean isShowLightBulb(@NotNull IntentionAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        return !this.ignoredActions.contains(action2.getFamilyName());
    }

    @Override
    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<Element> children2 = element.getChildren("ignoreAction");
        LinkedHashSet<String> ignoredActions = new LinkedHashSet<String>(children2.size());
        for (Element e : children2) {
            String string2 = e.getAttributeValue("name");
            Intrinsics.checkNotNull((Object)string2);
            ignoredActions.add(string2);
        }
        this.ignoredActions = ignoredActions;
    }

    @Override
    @NotNull
    public Element getState() {
        Element element = new Element("state");
        for (String name : this.ignoredActions) {
            element.addContent(new Element("ignoreAction").setAttribute("name", name));
        }
        return element;
    }

    @NotNull
    public final List<IntentionActionMetaData> getMetaData() {
        return IntentionsMetadataService.Companion.getInstance().getUniqueMetadata();
    }

    public final boolean isEnabled(@NotNull IntentionActionMetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        return !this.ignoredActions.contains(IntentionManagerSettingsKt.access$getFamilyName(metaData));
    }

    public final void setEnabled(@NotNull IntentionActionMetaData metaData, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        this.ignoredActions = enabled ? SetsKt.minus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(metaData)) : SetsKt.plus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(metaData));
    }

    public final boolean isEnabled(@NotNull IntentionAction action2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        try {
            string2 = IntentionManagerSettingsKt.access$getFamilyName(action2);
        }
        catch (ExtensionNotApplicableException ignored) {
            return false;
        }
        String familyName = string2;
        return !this.ignoredActions.contains(familyName);
    }

    public final void setEnabled(@NotNull IntentionAction action2, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.ignoredActions = enabled ? SetsKt.minus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(action2)) : SetsKt.plus(this.ignoredActions, (Object)IntentionManagerSettingsKt.access$getFamilyName(action2));
    }

    public final void unregisterMetaData(@NotNull IntentionAction intentionAction) {
        Intrinsics.checkNotNullParameter((Object)intentionAction, (String)"intentionAction");
        IntentionsMetadataService.Companion.getInstance().unregisterMetaData(intentionAction);
    }

    @JvmStatic
    @NotNull
    public static final IntentionManagerSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nIntentionManagerSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentionManagerSettings.kt\ncom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,113:1\n39#2,3:114\n*S KotlinDebug\n*F\n+ 1 IntentionManagerSettings.kt\ncom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$Companion\n*L\n24#1:114,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntentionManagerSettings getInstance() {
            boolean $i$f$service = false;
            Class<IntentionManagerSettings> serviceClass$iv = IntentionManagerSettings.class;
            IntentionManagerSettings intentionManagerSettings = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (intentionManagerSettings == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return intentionManagerSettings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$IntentionSearchableOptionContributor;", "Lcom/intellij/ide/ui/search/SearchableOptionContributor;", "()V", "processOptions", "", "processor", "Lcom/intellij/ide/ui/search/SearchableOptionProcessor;", "Companion", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nIntentionManagerSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentionManagerSettings.kt\ncom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$IntentionSearchableOptionContributor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n10#2:114\n*S KotlinDebug\n*F\n+ 1 IntentionManagerSettings.kt\ncom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$IntentionSearchableOptionContributor\n*L\n93#1:114\n*E\n"})
    private static final class IntentionSearchableOptionContributor
    extends SearchableOptionContributor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

        public void processOptions(@NotNull SearchableOptionProcessor processor) {
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            for (IntentionActionMetaData metaData : Companion.getInstance().getMetaData()) {
                try {
                    String family;
                    String string2;
                    Intrinsics.checkNotNullExpressionValue((Object)metaData.getDescription().getText(), (String)"metaData.description.text");
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                    String descriptionText = HTML_PATTERN.matcher(string3).replaceAll(" ");
                    String displayName = IntentionSettingsConfigurable.getDisplayNameText();
                    String configurableId = "preferences.intentionPowerPack";
                    Intrinsics.checkNotNullExpressionValue((Object)metaData.getFamily(), (String)"metaData.family");
                    processor.addOptions(descriptionText, family, family, configurableId, displayName, false);
                    processor.addOptions(family, family, family, configurableId, displayName, true);
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(IntentionManagerSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                    logger.error(e);
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$IntentionSearchableOptionContributor$Companion;", "", "()V", "HTML_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

