/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionDescriptionPanel;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsTree;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IntentionSettingsPanel
implements MasterDetails {
    private JPanel myPanel;
    private final IntentionSettingsTree myIntentionSettingsTree;
    private final IntentionDescriptionPanel myIntentionDescriptionPanel;
    private JPanel myTreePanel;
    private JPanel myDescriptionPanel;
    private DetailsComponent myDetailsComponent;
    private final Alarm myResetAlarm;

    public IntentionSettingsPanel() {
        this.$$$setupUI$$$();
        this.myIntentionDescriptionPanel = new IntentionDescriptionPanel();
        this.myResetAlarm = new Alarm();
        this.myIntentionSettingsTree = new IntentionSettingsTree(){

            @Override
            protected void selectionChanged(Object selected) {
                if (selected instanceof IntentionActionMetaData) {
                    IntentionActionMetaData actionMetaData = (IntentionActionMetaData)selected;
                    Runnable runnable = () -> {
                        IntentionSettingsPanel.this.intentionSelected(actionMetaData);
                        if (IntentionSettingsPanel.this.myDetailsComponent != null) {
                            String[] text2 = ArrayUtil.append(actionMetaData.myCategory, actionMetaData.getFamily());
                            IntentionSettingsPanel.this.myDetailsComponent.setText(text2);
                        }
                    };
                    IntentionSettingsPanel.this.myResetAlarm.cancelAllRequests();
                    IntentionSettingsPanel.this.myResetAlarm.addRequest(runnable, 100);
                } else {
                    IntentionSettingsPanel.this.categorySelected((String)selected);
                    if (IntentionSettingsPanel.this.myDetailsComponent != null) {
                        IntentionSettingsPanel.this.myDetailsComponent.setText(new String[]{(String)selected});
                    }
                }
            }

            @Override
            protected List<IntentionActionMetaData> filterModel(String filter2, boolean force) {
                List<IntentionActionMetaData> list2 = IntentionManagerSettings.getInstance().getMetaData();
                if (filter2 == null || filter2.length() == 0) {
                    return list2;
                }
                HashSet<String> quoted = new HashSet<String>();
                List keySetList = SearchUtil.findKeys((String)filter2, quoted);
                List<IntentionActionMetaData> result2 = new ArrayList<IntentionActionMetaData>();
                for (IntentionActionMetaData metaData : list2) {
                    if (!IntentionSettingsPanel.isIntentionAccepted(metaData, filter2, force, keySetList, quoted)) continue;
                    result2.add(metaData);
                }
                Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter2);
                if (force && result2.isEmpty() && filters.size() > 1) {
                    result2 = this.filterModel(filter2, false);
                }
                return result2;
            }
        };
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)this.myIntentionSettingsTree.getComponent(), "Center");
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        this.myDescriptionPanel.setLayout(new BorderLayout());
        this.myDescriptionPanel.add((Component)this.myIntentionDescriptionPanel.getComponent(), "Center");
    }

    private void intentionSelected(IntentionActionMetaData actionMetaData) {
        this.myIntentionDescriptionPanel.reset(actionMetaData, this.myIntentionSettingsTree.getFilter());
    }

    private void categorySelected(String intentionCategory) {
        this.myIntentionDescriptionPanel.reset(intentionCategory);
    }

    public void reset() {
        this.myIntentionSettingsTree.reset();
    }

    public void initUi() {
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myDescriptionPanel);
    }

    public JComponent getToolbar() {
        return this.myIntentionSettingsTree.getToolbarPanel();
    }

    public JComponent getMaster() {
        return this.myTreePanel;
    }

    public DetailsComponent getDetails() {
        return this.myDetailsComponent;
    }

    public void apply() {
        this.myIntentionSettingsTree.apply();
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public JTree getIntentionTree() {
        return this.myIntentionSettingsTree.getTree();
    }

    public boolean isModified() {
        return this.myIntentionSettingsTree.isModified();
    }

    public void dispose() {
        this.myIntentionSettingsTree.dispose();
        this.myIntentionDescriptionPanel.dispose();
    }

    public void selectIntention(String familyName) {
        this.myIntentionSettingsTree.selectIntention(familyName);
    }

    private static boolean isIntentionAccepted(IntentionActionMetaData metaData, @NonNls String filter2, boolean forceInclude, List<? extends Set<String>> keySetList, @NotNull Set<String> quoted) {
        if (quoted == null) {
            IntentionSettingsPanel.$$$reportNull$$$0(0);
        }
        if (StringUtil.containsIgnoreCase(metaData.getFamily(), filter2)) {
            return true;
        }
        for (String category : metaData.myCategory) {
            if (category == null || !StringUtil.containsIgnoreCase(category, filter2)) continue;
            return true;
        }
        for (String string2 : quoted) {
            if (StringUtil.containsIgnoreCase(metaData.getFamily(), string2)) {
                return true;
            }
            for (String category : metaData.myCategory) {
                if (category == null || !StringUtil.containsIgnoreCase(category, string2)) continue;
                return true;
            }
            try {
                TextDescriptor description = metaData.getDescription();
                if (StringUtil.containsIgnoreCase(description.getText(), string2)) {
                    if (forceInclude) continue;
                    return true;
                }
                if (!forceInclude) continue;
                return false;
            }
            catch (IOException iOException) {
            }
        }
        for (Set set2 : keySetList) {
            if (set2.contains(metaData.getFamily())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    public Runnable showOption(String option) {
        return () -> {
            this.myIntentionSettingsTree.filter(this.myIntentionSettingsTree.filterModel(option, true));
            this.myIntentionSettingsTree.setFilter(option);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(557);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(1.0);
        jPanel3.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myDescriptionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 5), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel4);
        this.myTreePanel = jPanel = new JPanel();
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "com/intellij/codeInsight/intention/impl/config/IntentionSettingsPanel", "isIntentionAccepted"));
    }
}

