/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionsMetadataService;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewComputableKt;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewDiffResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0002J\b\u0010\u001c\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable;", "Ljava/util/concurrent/Callable;", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalFile", "Lcom/intellij/psi/PsiFile;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "call", "generateFallbackDiff", "editorCopy", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewEditor;", "psiFileCopy", "generatePreview", "invokePreview", "origFile", "origEditor", "mapInjectedOffsetToUnescaped", "", "injectedFile", "injectedOffset", "setupEditor", "", "tryCreateDiffContent", "tryCreateFallbackDescriptionContent", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIntentionPreviewComputable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentionPreviewComputable.kt\ncom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,254:1\n661#2,11:255\n10#3:266\n10#3:267\n10#3:268\n*S KotlinDebug\n*F\n+ 1 IntentionPreviewComputable.kt\ncom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable\n*L\n51#1:255,11\n72#1:266\n77#1:267\n173#1:268\n*E\n"})
public final class IntentionPreviewComputable
implements Callable<IntentionPreviewInfo> {
    @NotNull
    private final Project project;
    @NotNull
    private final IntentionAction action;
    @NotNull
    private final PsiFile originalFile;
    @NotNull
    private final Editor originalEditor;

    public IntentionPreviewComputable(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
        this.project = project2;
        this.action = action2;
        this.originalFile = originalFile;
        this.originalEditor = originalEditor;
    }

    @Override
    @NotNull
    public IntentionPreviewInfo call() {
        IntentionPreviewInfo diffContent = this.tryCreateDiffContent();
        if (diffContent != null) {
            return diffContent;
        }
        return this.tryCreateFallbackDescriptionContent();
    }

    private final IntentionPreviewInfo tryCreateFallbackDescriptionContent() {
        Object object;
        Object v1;
        Iterable $this$singleOrNull$iv;
        block5: {
            IntentionAction intentionAction = IntentionActionDelegate.unwrap(this.action);
            Intrinsics.checkNotNullExpressionValue((Object)intentionAction, (String)"unwrap(action)");
            IntentionAction originalAction = intentionAction;
            $this$singleOrNull$iv = IntentionsMetadataService.Companion.getInstance().getMetaData();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IntentionActionMetaData md = (IntentionActionMetaData)element$iv;
                boolean bl = false;
                if (!(IntentionActionDelegate.unwrap(md.getAction()).getClass() == originalAction.getClass())) continue;
                if (found$iv) {
                    v1 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        IntentionActionMetaData intentionActionMetaData = v1;
        if (intentionActionMetaData == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        IntentionActionMetaData actionMetaData = intentionActionMetaData;
        try {
            String string2 = actionMetaData.getDescription().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"actionMetaData.description.text");
            object = string2;
            $this$singleOrNull$iv = IntentionPreviewComputableKt.access$getHTML_COMMENT_REGEX$p();
            String string3 = "";
            object = new IntentionPreviewInfo.Html($this$singleOrNull$iv.replace((CharSequence)object, string3));
        }
        catch (IOException ex) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"{\n      IntentionPreviewInfo.EMPTY\n    }");
            object = intentionPreviewInfo;
        }
        return object;
    }

    private final IntentionPreviewInfo tryCreateDiffContent() {
        try {
            return this.generatePreview();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (SideEffectGuard.SideEffectNotAllowedException e) {
            RuntimeException wrapper2 = new RuntimeException(e.getMessage());
            wrapper2.setStackTrace(e.getStackTrace());
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntentionPreviewComputable.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error("Side effect occurred on invoking the intention '" + this.action.getText() + "' on a copy of the file", wrapper2);
            return null;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntentionPreviewComputable.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error("Exceptions occurred on invoking the intention '" + this.action.getText() + "' on a copy of the file.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IntentionPreviewInfo generatePreview() {
        IntentionPreviewInfo intentionPreviewInfo;
        if (this.project.isDisposed()) {
            return null;
        }
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(this.originalFile, this.originalEditor, this.action);
        if (pair == null) {
            return null;
        }
        Pair<PsiFile, Editor> origPair = pair;
        ProgressManager.checkCanceled();
        boolean writable = this.originalEditor.getDocument().isWritable();
        try {
            Object a = origPair.first;
            Intrinsics.checkNotNullExpressionValue(a, (String)"origPair.first");
            PsiFile psiFile = (PsiFile)a;
            Object b = origPair.second;
            Intrinsics.checkNotNullExpressionValue(b, (String)"origPair.second");
            intentionPreviewInfo = this.invokePreview(psiFile, (Editor)b);
        }
        catch (Throwable throwable) {
            this.originalEditor.getDocument().setReadOnly(!writable);
            throw throwable;
        }
        this.originalEditor.getDocument().setReadOnly(!writable);
        return intentionPreviewInfo;
    }

    private final IntentionPreviewInfo invokePreview(PsiFile origFile, Editor origEditor) {
        IntentionPreviewInfo intentionPreviewInfo;
        Object manager;
        boolean anotherFile;
        Ref.ObjectRef info2 = new Ref.ObjectRef();
        IntentionPreviewInfo intentionPreviewInfo2 = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo2, (String)"EMPTY");
        info2.element = intentionPreviewInfo2;
        PsiElement psiElement = this.action.getElementToMakeWritable(origFile);
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        if (psiFile == null) {
            psiFile = origFile;
        }
        PsiFile fileToCopy = psiFile;
        PsiFile psiFileCopy = null;
        IntentionPreviewEditor editorCopy = null;
        boolean bl = anotherFile = !Intrinsics.areEqual((Object)fileToCopy, (Object)origFile);
        if (!anotherFile) {
            PsiFileFactory fileFactory = PsiFileFactory.getInstance(this.project);
            if (!Intrinsics.areEqual((Object)origFile, (Object)this.originalFile)) {
                manager = InjectedLanguageManager.getInstance(this.project);
                PsiFile psiFile2 = fileFactory.createFileFromText(origFile.getName(), origFile.getFileType(), (CharSequence)((InjectedLanguageManager)manager).getUnescapedText(origFile));
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"fileFactory.createFileFr\u2026tUnescapedText(origFile))");
                fileToCopy = psiFile2;
            }
            PsiFile psiFile3 = IntentionPreviewUtils.obtainCopyForPreview(fileToCopy);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"obtainCopyForPreview(fileToCopy)");
            psiFileCopy = psiFile3;
            EditorSettings editorSettings = this.originalEditor.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"originalEditor.settings");
            editorCopy = new IntentionPreviewEditor(psiFileCopy, editorSettings);
            this.setupEditor(editorCopy, origFile, origEditor);
        } else {
            PsiFile psiFile4 = IntentionPreviewUtils.obtainCopyForPreview(fileToCopy);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"obtainCopyForPreview(fileToCopy)");
            psiFileCopy = psiFile4;
            EditorSettings editorSettings = this.originalEditor.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"originalEditor.settings");
            editorCopy = new IntentionPreviewEditor(psiFileCopy, editorSettings);
        }
        this.originalEditor.getDocument().setReadOnly(true);
        ProgressManager.checkCanceled();
        CodeStyleSettings settings = CodeStyle.getSettings((Editor)((Editor)editorCopy));
        IntentionPreviewUtils.previewSession((Editor)editorCopy, () -> IntentionPreviewComputable.invokePreview$lambda$3(this, info2, editorCopy, psiFileCopy));
        if (Intrinsics.areEqual((Object)info2.element, (Object)IntentionPreviewInfo.FALLBACK_DIFF) && Intrinsics.areEqual((Object)fileToCopy, (Object)origFile)) {
            IntentionPreviewInfo intentionPreviewInfo3 = SideEffectGuard.computeWithoutSideEffects(() -> IntentionPreviewComputable.invokePreview$lambda$4(this, editorCopy, psiFileCopy));
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo3, (String)"computeWithoutSideEffect\u2026ditorCopy, psiFileCopy) }");
            info2.element = intentionPreviewInfo3;
        }
        Reference.reachabilityFence(settings);
        manager = PsiDocumentManager.getInstance(this.project);
        ((PsiDocumentManager)manager).commitDocument(editorCopy.getDocument());
        ((PsiDocumentManager)manager).doPostponedOperationsAndUnblockDocument(editorCopy.getDocument());
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance()");
        ComparisonManager comparisonManager2 = comparisonManager;
        IntentionPreviewInfo result2 = (IntentionPreviewInfo)info2.element;
        if (Intrinsics.areEqual((Object)result2, (Object)IntentionPreviewInfo.DIFF) ? true : Intrinsics.areEqual((Object)result2, (Object)IntentionPreviewInfo.DIFF_NO_TRIM)) {
            Document document = psiFileCopy.getViewProvider().getDocument();
            ComparisonPolicy policy = Intrinsics.areEqual((Object)info2.element, (Object)IntentionPreviewInfo.DIFF) ? ComparisonPolicy.TRIM_WHITESPACES : ComparisonPolicy.DEFAULT;
            PsiFile psiFile5 = fileToCopy;
            String string2 = anotherFile ? psiFileCopy.getName() : null;
            boolean bl2 = !anotherFile;
            List list2 = comparisonManager2.compareLines((CharSequence)fileToCopy.getText(), (CharSequence)document.getText(), policy, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"compareLines(fileToCopy.\u2026ogressIndicator.INSTANCE)");
            intentionPreviewInfo = new IntentionPreviewDiffResult(psiFileCopy, psiFile5, list2, bl2, string2, policy);
        } else if (Intrinsics.areEqual((Object)result2, (Object)IntentionPreviewInfo.EMPTY) ? true : Intrinsics.areEqual((Object)result2, (Object)IntentionPreviewInfo.FALLBACK_DIFF)) {
            intentionPreviewInfo = null;
        } else if (result2 instanceof IntentionPreviewInfo.CustomDiff) {
            PsiFileFactory fileFactory = PsiFileFactory.getInstance(this.project);
            PsiFile psiFile6 = fileFactory.createFileFromText("__dummy__", ((IntentionPreviewInfo.CustomDiff)result2).fileType(), (CharSequence)((IntentionPreviewInfo.CustomDiff)result2).modifiedText());
            PsiFile psiFile7 = fileFactory.createFileFromText("__dummy__", ((IntentionPreviewInfo.CustomDiff)result2).fileType(), (CharSequence)((IntentionPreviewInfo.CustomDiff)result2).originalText());
            List list3 = comparisonManager2.compareLines((CharSequence)((IntentionPreviewInfo.CustomDiff)result2).originalText(), (CharSequence)((IntentionPreviewInfo.CustomDiff)result2).modifiedText(), ComparisonPolicy.TRIM_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            String string3 = ((IntentionPreviewInfo.CustomDiff)result2).fileName();
            ComparisonPolicy comparisonPolicy = ComparisonPolicy.TRIM_WHITESPACES;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile6, (String)"createFileFromText(\"__du\u2026), result.modifiedText())");
            Intrinsics.checkNotNullExpressionValue((Object)psiFile7, (String)"createFileFromText(\"__du\u2026), result.originalText())");
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"compareLines(result.orig\u2026ogressIndicator.INSTANCE)");
            intentionPreviewInfo = new IntentionPreviewDiffResult(psiFile6, psiFile7, list3, false, string3, comparisonPolicy);
        } else {
            intentionPreviewInfo = result2;
        }
        return intentionPreviewInfo;
    }

    private final IntentionPreviewInfo generateFallbackDiff(IntentionPreviewEditor editorCopy, PsiFile psiFileCopy) {
        boolean thirdParty;
        FileModifier fileModifier;
        if (!this.action.startInWriteAction()) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        PsiElement psiElement = this.action.getElementToMakeWritable(this.originalFile);
        if ((psiElement != null ? psiElement.getContainingFile() : null) != this.originalFile) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        IntentionAction intentionAction = IntentionPreviewComputableKt.findCopyIntention(this.project, (Editor)editorCopy, psiFileCopy, this.action);
        if (intentionAction == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        IntentionAction action2 = intentionAction;
        IntentionAction intentionAction2 = IntentionActionDelegate.unwrap(action2);
        Intrinsics.checkNotNullExpressionValue((Object)intentionAction2, (String)"unwrap(action)");
        IntentionAction unwrapped = intentionAction2;
        if (unwrapped instanceof QuickFixWrapper) {
            LocalQuickFix localQuickFix = ((QuickFixWrapper)unwrapped).getFix();
            Intrinsics.checkNotNullExpressionValue((Object)localQuickFix, (String)"unwrapped.fix");
            fileModifier = localQuickFix;
        } else {
            fileModifier = unwrapped;
        }
        Class<?> cls = fileModifier.getClass();
        ClassLoader loader = cls.getClassLoader();
        boolean bl = thirdParty = !(loader instanceof PluginAwareClassLoader) || !PluginManagerCore.isDevelopedByJetBrains(((PluginAwareClassLoader)((Object)loader)).getPluginDescriptor());
        if (!thirdParty) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(IntentionPreviewComputable.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error("Intention preview fallback is used for action " + cls.getName() + "|" + action2.getFamilyName());
        }
        ProgressManager.checkCanceled();
        IntentionPreviewUtils.previewSession((Editor)editorCopy, () -> IntentionPreviewComputable.generateFallbackDiff$lambda$6(this, action2, editorCopy, psiFileCopy));
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    private final void setupEditor(IntentionPreviewEditor editorCopy, PsiFile origFile, Editor origEditor) {
        ProgressManager.checkCanceled();
        TextRange selection = null;
        int caretOffset = 0;
        if (!Intrinsics.areEqual((Object)origFile, (Object)this.originalFile)) {
            SelectionModel selectionModel = origEditor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"origEditor.selectionModel");
            SelectionModel selectionModel2 = selectionModel;
            int start = this.mapInjectedOffsetToUnescaped(origFile, selectionModel2.getSelectionStart());
            int end = selectionModel2.getSelectionEnd() == selectionModel2.getSelectionStart() ? start : this.mapInjectedOffsetToUnescaped(origFile, selectionModel2.getSelectionEnd());
            selection = new TextRange(start, end);
            CaretModel caretModel = origEditor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"origEditor.caretModel");
            CaretModel caretModel2 = caretModel;
            int n = caretModel2.getOffset();
            caretOffset = n == selectionModel2.getSelectionStart() ? start : (n == selectionModel2.getSelectionEnd() ? end : this.mapInjectedOffsetToUnescaped(origFile, caretModel2.getOffset()));
        } else {
            selection = new TextRange(this.originalEditor.getSelectionModel().getSelectionStart(), this.originalEditor.getSelectionModel().getSelectionEnd());
            caretOffset = this.originalEditor.getCaretModel().getOffset();
        }
        editorCopy.getCaretModel().moveToOffset(caretOffset);
        editorCopy.getSelectionModel().setSelection(selection.getStartOffset(), selection.getEndOffset());
    }

    private final int mapInjectedOffsetToUnescaped(PsiFile injectedFile, int injectedOffset) {
        Ref.IntRef unescapedOffset = new Ref.IntRef();
        Ref.IntRef escapedOffset = new Ref.IntRef();
        injectedFile.accept(new PsiRecursiveElementWalkingVisitor(unescapedOffset, escapedOffset, injectedOffset){
            final /* synthetic */ Ref.IntRef $unescapedOffset;
            final /* synthetic */ Ref.IntRef $escapedOffset;
            final /* synthetic */ int $injectedOffset;
            {
                this.$unescapedOffset = $unescapedOffset;
                this.$escapedOffset = $escapedOffset;
                this.$injectedOffset = $injectedOffset;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String leafText = InjectedLanguageUtilBase.getUnescapedLeafText(element, false);
                if (leafText != null) {
                    this.$unescapedOffset.element += leafText.length();
                    this.$escapedOffset.element += element.getTextLength();
                    if (this.$escapedOffset.element >= this.$injectedOffset) {
                        this.$unescapedOffset.element -= this.$escapedOffset.element - this.$injectedOffset;
                        this.stopWalking();
                    }
                }
                super.visitElement(element);
            }
        });
        return unescapedOffset.element;
    }

    private static final IntentionPreviewInfo invokePreview$lambda$3$lambda$2$lambda$1(IntentionPreviewComputable this$0, IntentionPreviewEditor $editorCopy, PsiFile $psiFileCopy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$editorCopy), (String)"$editorCopy");
        Intrinsics.checkNotNullParameter((Object)$psiFileCopy, (String)"$psiFileCopy");
        return this$0.action.generatePreview(this$0.project, (Editor)$editorCopy, $psiFileCopy);
    }

    private static final void invokePreview$lambda$3$lambda$2(Ref.ObjectRef $info, IntentionPreviewComputable this$0, IntentionPreviewEditor $editorCopy, PsiFile $psiFileCopy) {
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$editorCopy), (String)"$editorCopy");
        Intrinsics.checkNotNullParameter((Object)$psiFileCopy, (String)"$psiFileCopy");
        IntentionPreviewInfo intentionPreviewInfo = SideEffectGuard.computeWithoutSideEffects(() -> IntentionPreviewComputable.invokePreview$lambda$3$lambda$2$lambda$1(this$0, $editorCopy, $psiFileCopy));
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"computeWithoutSideEffect\u2026y, psiFileCopy)\n        }");
        $info.element = intentionPreviewInfo;
    }

    private static final void invokePreview$lambda$3(IntentionPreviewComputable this$0, Ref.ObjectRef $info, IntentionPreviewEditor $editorCopy, PsiFile $psiFileCopy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        Intrinsics.checkNotNullParameter((Object)((Object)$editorCopy), (String)"$editorCopy");
        Intrinsics.checkNotNullParameter((Object)$psiFileCopy, (String)"$psiFileCopy");
        PostprocessReformattingAspect.getInstance((Project)this$0.project).postponeFormattingInside(() -> IntentionPreviewComputable.invokePreview$lambda$3$lambda$2($info, this$0, $editorCopy, $psiFileCopy));
    }

    private static final IntentionPreviewInfo invokePreview$lambda$4(IntentionPreviewComputable this$0, IntentionPreviewEditor $editorCopy, PsiFile $psiFileCopy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$editorCopy), (String)"$editorCopy");
        Intrinsics.checkNotNullParameter((Object)$psiFileCopy, (String)"$psiFileCopy");
        return this$0.generateFallbackDiff($editorCopy, $psiFileCopy);
    }

    private static final void generateFallbackDiff$lambda$6$lambda$5(IntentionAction $action, IntentionPreviewComputable this$0, IntentionPreviewEditor $editorCopy, PsiFile $psiFileCopy) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$editorCopy), (String)"$editorCopy");
        Intrinsics.checkNotNullParameter((Object)$psiFileCopy, (String)"$psiFileCopy");
        $action.invoke(this$0.project, (Editor)$editorCopy, $psiFileCopy);
    }

    private static final void generateFallbackDiff$lambda$6(IntentionPreviewComputable this$0, IntentionAction $action, IntentionPreviewEditor $editorCopy, PsiFile $psiFileCopy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)((Object)$editorCopy), (String)"$editorCopy");
        Intrinsics.checkNotNullParameter((Object)$psiFileCopy, (String)"$psiFileCopy");
        PostprocessReformattingAspect.getInstance((Project)this$0.project).postponeFormattingInside(() -> IntentionPreviewComputable.generateFallbackDiff$lambda$6$lambda$5($action, this$0, $editorCopy, $psiFileCopy));
    }
}

