/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EmptySoftWrapModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\f\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewEditor;", "Lcom/intellij/openapi/editor/impl/ImaginaryEditor;", "psiFileCopy", "Lcom/intellij/psi/PsiFile;", "settings", "Lcom/intellij/openapi/editor/EditorSettings;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/EditorSettings;)V", "getSettings", "getSoftWrapModel", "Lcom/intellij/openapi/editor/SoftWrapModel;", "isOneLineMode", "", "isViewer", "logicalPositionToOffset", "", "pos", "Lcom/intellij/openapi/editor/LogicalPosition;", "logicalToVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "logicalPos", "notImplemented", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "offsetToLogicalPosition", "offset", "visualToLogicalPosition", "visiblePos", "intellij.platform.lang.impl"})
public final class IntentionPreviewEditor
extends ImaginaryEditor {
    @NotNull
    private final EditorSettings settings;

    public IntentionPreviewEditor(@NotNull PsiFile psiFileCopy, @NotNull EditorSettings settings) {
        Intrinsics.checkNotNullParameter((Object)psiFileCopy, (String)"psiFileCopy");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Project project2 = psiFileCopy.getProject();
        Document document = psiFileCopy.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        super(project2, document);
        this.settings = settings;
    }

    @NotNull
    protected RuntimeException notImplemented() {
        return new IntentionPreviewUnsupportedOperationException();
    }

    public boolean isViewer() {
        return true;
    }

    public boolean isOneLineMode() {
        return false;
    }

    @NotNull
    public EditorSettings getSettings() {
        return this.settings;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Document document = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        Document document2 = document;
        int lineStart = document2.getLineStartOffset(pos.line);
        int lineEnd = document2.getLineEndOffset(pos.line);
        return Math.min(lineEnd, lineStart + pos.column);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        Intrinsics.checkNotNullParameter((Object)logicalPos, (String)"logicalPos");
        return new VisualPosition(logicalPos.line, logicalPos.column);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        Intrinsics.checkNotNullParameter((Object)visiblePos, (String)"visiblePos");
        return new LogicalPosition(visiblePos.line, visiblePos.column);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset2) {
        int clamped = RangesKt.coerceIn((int)offset2, (int)0, (int)this.getDocument().getTextLength());
        Document document = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        Document document2 = document;
        int line = document2.getLineNumber(clamped);
        int col = clamped - document2.getLineStartOffset(line);
        return new LogicalPosition(line, col);
    }

    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        return (SoftWrapModel)new EmptySoftWrapModel();
    }
}

