/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewComponent;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewComputable;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewDiffResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewModel;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JWindow;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u000201B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u0012J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J,\u0010%\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'2\n\b\u0003\u0010(\u001a\u0004\u0018\u00010)H\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\u0016\u0010+\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u001cJ\u0012\u0010-\u001a\u00020\u001c2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewPopupUpdateProcessor;", "Lcom/intellij/ui/popup/PopupUpdateProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "originalFile", "Lcom/intellij/psi/PsiFile;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "component", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComponent;", "editorsToRelease", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "hideForIndex", "", "index", "justActivated", "", "originalPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "popup", "popupWindow", "Ljavax/swing/JWindow;", "getPopupWindow", "()Ljavax/swing/JWindow;", "show", "activate", "", "adjustPosition", "cancel", "hide", "hideTemporarily", "isShown", "renderPreview", "result", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "select", "editors", "", "html", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo$Html;", "selectNoPreview", "setup", "parentIndex", "updatePopup", "intentionAction", "", "Companion", "IntentionPreviewPopupKey", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nIntentionPreviewPopupUpdateProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentionPreviewPopupUpdateProcessor.kt\ncom/intellij/codeInsight/intention/impl/preview/IntentionPreviewPopupUpdateProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n1855#2,2:273\n1855#2,2:275\n*S KotlinDebug\n*F\n+ 1 IntentionPreviewPopupUpdateProcessor.kt\ncom/intellij/codeInsight/intention/impl/preview/IntentionPreviewPopupUpdateProcessor\n*L\n171#1:273,2\n201#1:275,2\n*E\n"})
public final class IntentionPreviewPopupUpdateProcessor
extends PopupUpdateProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile originalFile;
    @NotNull
    private final Editor originalEditor;
    private int index;
    private boolean show;
    private int hideForIndex;
    @Nullable
    private JBPopup originalPopup;
    @NotNull
    private final List<EditorEx> editorsToRelease;
    private JBPopup popup;
    private IntentionPreviewComponent component;
    private boolean justActivated;
    public static final int MAX_HEIGHT = 300;
    public static final int MIN_WIDTH = 300;

    public IntentionPreviewPopupUpdateProcessor(@NotNull Project project2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
        super(project2);
        this.project = project2;
        this.originalFile = originalFile;
        this.originalEditor = originalEditor;
        this.index = -2;
        this.hideForIndex = -1;
        this.editorsToRelease = new ArrayList();
    }

    private final JWindow getPopupWindow() {
        JBPopup jBPopup = this.popup;
        if (jBPopup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
            jBPopup = null;
        }
        return UIUtil.getParentOfType(JWindow.class, jBPopup.getContent());
    }

    public void updatePopup(@Nullable Object intentionAction) {
        JComponent value;
        IntentionPreviewComponent intentionPreviewComponent;
        block14: {
            JBPopup origPopup;
            block13: {
                if (!this.show || this.index == this.hideForIndex) {
                    return;
                }
                this.hideForIndex = -1;
                if (this.popup == null) break block13;
                JBPopup jBPopup = this.popup;
                if (jBPopup == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                    jBPopup = null;
                }
                if (!jBPopup.isDisposed()) break block14;
            }
            if ((origPopup = this.originalPopup) == null || origPopup.isDisposed()) {
                return;
            }
            this.component = new IntentionPreviewComponent((Disposable)origPopup);
            IntentionPreviewComponent intentionPreviewComponent2 = this.component;
            if (intentionPreviewComponent2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
                intentionPreviewComponent2 = null;
            }
            intentionPreviewComponent2.getMultiPanel().select((Object)-2, true);
            JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
            IntentionPreviewComponent intentionPreviewComponent3 = this.component;
            if (intentionPreviewComponent3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
                intentionPreviewComponent3 = null;
            }
            JBPopup jBPopup = jBPopupFactory.createComponentPopupBuilder((JComponent)((Object)intentionPreviewComponent3), null).setCancelCallback(() -> IntentionPreviewPopupUpdateProcessor.updatePopup$lambda$0(this)).setCancelKeyEnabled(false).setShowBorder(false).addUserData((Object)new IntentionPreviewPopupKey()).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"getInstance().createComp\u2026))\n        .createPopup()");
            this.popup = jBPopup;
            IntentionPreviewComponent intentionPreviewComponent4 = this.component;
            if (intentionPreviewComponent4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
                intentionPreviewComponent4 = null;
            }
            intentionPreviewComponent4.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ IntentionPreviewPopupUpdateProcessor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(@Nullable ComponentEvent e) {
                    JBPopup jBPopup;
                    Integer key;
                    JBPopup jBPopup2 = IntentionPreviewPopupUpdateProcessor.access$getPopup$p(this.this$0);
                    if (jBPopup2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                        jBPopup2 = null;
                    }
                    Dimension size = jBPopup2.getSize();
                    IntentionPreviewComponent intentionPreviewComponent = IntentionPreviewPopupUpdateProcessor.access$getComponent$p(this.this$0);
                    if (intentionPreviewComponent == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"component");
                        intentionPreviewComponent = null;
                    }
                    Integer n = key = (Integer)intentionPreviewComponent.getMultiPanel().getKey();
                    int n2 = -1;
                    if (n == null || n != n2) {
                        size = new Dimension(RangesKt.coerceAtLeast((int)size.width, (int)300), size.height);
                    }
                    if ((jBPopup = IntentionPreviewPopupUpdateProcessor.access$getPopup$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                        jBPopup = null;
                    }
                    jBPopup.getContent().setPreferredSize(size);
                    IntentionPreviewPopupUpdateProcessor.access$adjustPosition(this.this$0, IntentionPreviewPopupUpdateProcessor.access$getOriginalPopup$p(this.this$0));
                    JBPopup jBPopup3 = IntentionPreviewPopupUpdateProcessor.access$getPopup$p(this.this$0);
                    if (jBPopup3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                        jBPopup3 = null;
                    }
                    jBPopup3.setSize(size);
                }
            });
            this.adjustPosition(this.originalPopup);
        }
        if ((intentionPreviewComponent = this.component) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent = null;
        }
        if ((value = (JComponent)intentionPreviewComponent.getMultiPanel().getValue((Object)this.index, false)) != null) {
            IntentionPreviewPopupUpdateProcessor.select$default(this, this.index, null, null, 6, null);
            return;
        }
        Intrinsics.checkNotNull((Object)intentionAction, (String)"null cannot be cast to non-null type com.intellij.codeInsight.intention.IntentionAction");
        IntentionAction action2 = (IntentionAction)intentionAction;
        IntentionPreviewComponent intentionPreviewComponent5 = this.component;
        if (intentionPreviewComponent5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent5 = null;
        }
        intentionPreviewComponent5.startLoading();
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(new IntentionPreviewComputable(this.project, action2, this.originalFile, this.originalEditor));
        JBPopup jBPopup = this.popup;
        if (jBPopup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
            jBPopup = null;
        }
        Object[] objectArray = new Object[]{this};
        nonBlockingReadAction.expireWith((Disposable)jBPopup).coalesceBy(objectArray).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> IntentionPreviewPopupUpdateProcessor.updatePopup$lambda$1((Function1)new Function1<IntentionPreviewInfo, Unit>(this){
            final /* synthetic */ IntentionPreviewPopupUpdateProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(IntentionPreviewInfo it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                IntentionPreviewPopupUpdateProcessor.access$renderPreview(this.this$0, it);
            }
        }, arg_0)).submit(AppExecutorUtil.getAppExecutorService());
    }

    public final void hideTemporarily() {
        if (!this.show) {
            return;
        }
        this.hideForIndex = this.index;
        this.selectNoPreview();
    }

    private final void adjustPosition(JBPopup originalPopup) {
        if (originalPopup != null && originalPopup.getContent().isShowing()) {
            PopupPositionManager.PositionAdjuster positionAdjuster = new PopupPositionManager.PositionAdjuster(originalPopup.getContent());
            JBPopup jBPopup = this.popup;
            if (jBPopup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                jBPopup = null;
            }
            PopupPositionManager.Position[] positionArray = new PopupPositionManager.Position[]{PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT};
            positionAdjuster.adjust(jBPopup, positionArray);
        }
    }

    private final void renderPreview(IntentionPreviewInfo result2) {
        IntentionPreviewInfo intentionPreviewInfo = result2;
        if (intentionPreviewInfo instanceof IntentionPreviewDiffResult) {
            List<EditorEx> editors2 = IntentionPreviewModel.Companion.createEditors(this.project, (IntentionPreviewDiffResult)result2);
            if (editors2.isEmpty()) {
                this.selectNoPreview();
                return;
            }
            this.editorsToRelease.addAll((Collection<EditorEx>)editors2);
            IntentionPreviewPopupUpdateProcessor.select$default(this, this.index, editors2, null, 4, null);
        } else if (intentionPreviewInfo instanceof IntentionPreviewInfo.Html) {
            IntentionPreviewPopupUpdateProcessor.select$default(this, this.index, null, (IntentionPreviewInfo.Html)result2, 2, null);
        } else {
            this.selectNoPreview();
        }
    }

    private final void selectNoPreview() {
        if (this.justActivated) {
            IntentionPreviewPopupUpdateProcessor.select$default(this, -1, null, null, 6, null);
        } else {
            JWindow jWindow = this.getPopupWindow();
            if (jWindow != null) {
                jWindow.setVisible(false);
            }
        }
    }

    public final void setup(@NotNull JBPopup popup2, int parentIndex) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        this.index = parentIndex;
        this.originalPopup = popup2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isShown() {
        if (!this.show) return false;
        JWindow jWindow = this.getPopupWindow();
        if (jWindow == null) return true;
        if (jWindow.isVisible()) return true;
        return false;
    }

    public final void hide() {
        if (this.popup != null) {
            JBPopup jBPopup = this.popup;
            if (jBPopup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                jBPopup = null;
            }
            if (!jBPopup.isDisposed()) {
                JBPopup jBPopup2 = this.popup;
                if (jBPopup2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                    jBPopup2 = null;
                }
                jBPopup2.cancel();
            }
        }
    }

    public final void show() {
        this.show = true;
    }

    private final boolean cancel() {
        Iterable $this$forEach$iv = this.editorsToRelease;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorEx editor2 = (EditorEx)element$iv;
            boolean bl = false;
            EditorFactory.getInstance().releaseEditor((Editor)editor2);
        }
        this.editorsToRelease.clear();
        IntentionPreviewComponent intentionPreviewComponent = this.component;
        if (intentionPreviewComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent = null;
        }
        intentionPreviewComponent.removeAll();
        this.show = false;
        return true;
    }

    private final void select(int index2, List<? extends EditorEx> editors2, @NlsSafe IntentionPreviewInfo.Html html) {
        IntentionPreviewComponent intentionPreviewComponent;
        IntentionPreviewComponent intentionPreviewComponent2;
        this.justActivated = false;
        JWindow jWindow = this.getPopupWindow();
        if (jWindow != null) {
            jWindow.setVisible(true);
        }
        if ((intentionPreviewComponent2 = this.component) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent2 = null;
        }
        intentionPreviewComponent2.stopLoading();
        IntentionPreviewComponent intentionPreviewComponent3 = this.component;
        if (intentionPreviewComponent3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent3 = null;
        }
        intentionPreviewComponent3.setEditors(editors2);
        IntentionPreviewComponent intentionPreviewComponent4 = this.component;
        if (intentionPreviewComponent4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent4 = null;
        }
        intentionPreviewComponent4.setHtml(html);
        IntentionPreviewComponent intentionPreviewComponent5 = this.component;
        if (intentionPreviewComponent5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent5 = null;
        }
        intentionPreviewComponent5.getMultiPanel().select((Object)index2, true);
        IntentionPreviewComponent intentionPreviewComponent6 = this.component;
        if (intentionPreviewComponent6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent6 = null;
        }
        Dimension size = intentionPreviewComponent6.getPreferredSize();
        JBPopup jBPopup = this.popup;
        if (jBPopup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
            jBPopup = null;
        }
        Point point = jBPopup.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"popup.locationOnScreen");
        Point location2 = point;
        Rectangle screen = ScreenUtil.getScreenRectangle(location2);
        if (screen != null) {
            Point origLocation;
            JComponent content2;
            int delta = screen.width + screen.x - location2.x;
            JBPopup jBPopup2 = this.originalPopup;
            JComponent jComponent = content2 = jBPopup2 != null ? jBPopup2.getContent() : null;
            Point point2 = origLocation = (jComponent != null ? jComponent.isShowing() : false) ? content2.getLocationOnScreen() : null;
            if (origLocation != null && location2.x < origLocation.x) {
                delta = RangesKt.coerceAtMost((int)delta, (int)(origLocation.x - screen.x - 5));
            }
            size.width = RangesKt.coerceAtMost((int)size.width, (int)delta);
        }
        if ((intentionPreviewComponent = this.component) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            intentionPreviewComponent = null;
        }
        Iterable $this$forEach$iv = intentionPreviewComponent.getEditors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorEx it = (EditorEx)element$iv;
            boolean bl = false;
            it.getSoftWrapModel().addSoftWrapChangeListener(new SoftWrapChangeListener(it, this){
                final /* synthetic */ EditorEx $it;
                final /* synthetic */ IntentionPreviewPopupUpdateProcessor this$0;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                }

                public void recalculationEnds() {
                    EditorEx editorEx = this.$it;
                    Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                    int height = ((EditorImpl)editorEx).offsetToXY((int)((EditorImpl)this.$it).getDocument().getTextLength()).y + ((EditorImpl)this.$it).getLineHeight() + 6;
                    ((EditorImpl)this.$it).getComponent().setPreferredSize(new Dimension(((EditorImpl)this.$it).getComponent().getPreferredSize().width, Math.min(height, 300)));
                    ((EditorImpl)this.$it).getComponent().getParent().invalidate();
                    JBPopup jBPopup = IntentionPreviewPopupUpdateProcessor.access$getPopup$p(this.this$0);
                    if (jBPopup == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
                        jBPopup = null;
                    }
                    jBPopup.pack(true, true);
                }

                public void softWrapsChanged() {
                }
            });
            it.getComponent().setPreferredSize(new Dimension(Math.max(size.width, 300), Math.min(it.getComponent().getPreferredSize().height, 300)));
        }
        JBPopup jBPopup3 = this.popup;
        if (jBPopup3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popup");
            jBPopup3 = null;
        }
        jBPopup3.pack(true, true);
    }

    static /* synthetic */ void select$default(IntentionPreviewPopupUpdateProcessor intentionPreviewPopupUpdateProcessor, int n, List list2, IntentionPreviewInfo.Html html, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            html = null;
        }
        intentionPreviewPopupUpdateProcessor.select(n, list2, html);
    }

    public final void activate() {
        this.justActivated = true;
    }

    private static final Boolean updatePopup$lambda$0(IntentionPreviewPopupUpdateProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.cancel();
    }

    private static final void updatePopup$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @TestOnly
    @Nullable
    public static final String getPreviewText(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        return Companion.getPreviewText(project2, action2, originalFile, originalEditor);
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final String getPreviewContent(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        return Companion.getPreviewContent(project2, action2, originalFile, originalEditor);
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final IntentionPreviewInfo getPreviewInfo(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        return Companion.getPreviewInfo(project2, action2, originalFile, originalEditor);
    }

    public static final /* synthetic */ JBPopup access$getPopup$p(IntentionPreviewPopupUpdateProcessor $this) {
        return $this.popup;
    }

    public static final /* synthetic */ IntentionPreviewComponent access$getComponent$p(IntentionPreviewPopupUpdateProcessor $this) {
        return $this.component;
    }

    public static final /* synthetic */ void access$adjustPosition(IntentionPreviewPopupUpdateProcessor $this, JBPopup originalPopup) {
        $this.adjustPosition(originalPopup);
    }

    public static final /* synthetic */ JBPopup access$getOriginalPopup$p(IntentionPreviewPopupUpdateProcessor $this) {
        return $this.originalPopup;
    }

    public static final /* synthetic */ void access$renderPreview(IntentionPreviewPopupUpdateProcessor $this, IntentionPreviewInfo result2) {
        $this.renderPreview(result2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewPopupUpdateProcessor$IntentionPreviewPopupKey;", "", "()V", "intellij.platform.lang.impl"})
    public static final class IntentionPreviewPopupKey {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J*\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewPopupUpdateProcessor$Companion;", "", "()V", "MAX_HEIGHT", "", "MIN_WIDTH", "getPreviewContent", "", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalFile", "Lcom/intellij/psi/PsiFile;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "getPreviewInfo", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "getPreviewText", "getShortcutSet", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "getShortcutText", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShortcutText() {
            String string2 = KeymapUtil.getPreferredShortcutText((Shortcut[])this.getShortcutSet().getShortcuts());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPreferredShortcutText\u2026tShortcutSet().shortcuts)");
            return string2;
        }

        @NotNull
        public final ShortcutSet getShortcutSet() {
            ShortcutSet shortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc");
            Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getActiveKeymapShortcuts\u2026ons.ACTION_QUICK_JAVADOC)");
            return shortcutSet;
        }

        @JvmStatic
        @TestOnly
        @Nullable
        public final String getPreviewText(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
            IntentionPreviewInfo intentionPreviewInfo = this.getPreviewInfo(project2, action2, originalFile, originalEditor);
            Object object = intentionPreviewInfo instanceof IntentionPreviewDiffResult ? (IntentionPreviewDiffResult)intentionPreviewInfo : null;
            return object != null && (object = ((IntentionPreviewDiffResult)object).getPsiFile()) != null ? object.getText() : null;
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final String getPreviewContent(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
            IntentionPreviewInfo info2 = this.getPreviewInfo(project2, action2, originalFile, originalEditor);
            if (info2 instanceof IntentionPreviewDiffResult) {
                String string3 = ((IntentionPreviewDiffResult)info2).getPsiFile().getText();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"info.psiFile.text");
            } else if (info2 instanceof IntentionPreviewInfo.Html) {
                String string4 = ((IntentionPreviewInfo.Html)info2).content().toString();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"info.content().toString()");
            } else {
                string2 = "";
            }
            return string2;
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final IntentionPreviewInfo getPreviewInfo(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
            IntentionPreviewInfo intentionPreviewInfo;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Intrinsics.checkNotNullParameter((Object)originalEditor, (String)"originalEditor");
            IntentionPreviewInfo intentionPreviewInfo2 = ProgressManager.getInstance().runProcess(() -> Companion.getPreviewInfo$lambda$0(project2, action2, originalFile, originalEditor), (ProgressIndicator)new EmptyProgressIndicator());
            if (intentionPreviewInfo2 == null) {
                IntentionPreviewInfo intentionPreviewInfo3 = IntentionPreviewInfo.EMPTY;
                intentionPreviewInfo = intentionPreviewInfo3;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo3, (String)"EMPTY");
            } else {
                intentionPreviewInfo = intentionPreviewInfo2;
            }
            return intentionPreviewInfo;
        }

        private static final IntentionPreviewInfo getPreviewInfo$lambda$0(Project $project, IntentionAction $action, PsiFile $originalFile, Editor $originalEditor) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
            Intrinsics.checkNotNullParameter((Object)$originalFile, (String)"$originalFile");
            Intrinsics.checkNotNullParameter((Object)$originalEditor, (String)"$originalEditor");
            return new IntentionPreviewComputable($project, $action, $originalFile, $originalEditor).generatePreview();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

