/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.preview;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.DeferredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface IntentionPreviewInfo {
    public static final IntentionPreviewInfo EMPTY = new IntentionPreviewInfo(){

        public String toString() {
            return "EMPTY";
        }
    };
    @ApiStatus.Internal
    public static final IntentionPreviewInfo FALLBACK_DIFF = new IntentionPreviewInfo(){

        public String toString() {
            return "FALLBACK";
        }
    };
    public static final IntentionPreviewInfo DIFF = new IntentionPreviewInfo(){

        public String toString() {
            return "DIFF";
        }
    };
    public static final IntentionPreviewInfo DIFF_NO_TRIM = new IntentionPreviewInfo(){

        public String toString() {
            return "DIFF_NO_TRIM";
        }
    };

    @NotNull
    public static IntentionPreviewInfo rename(@NotNull PsiFile file2, @NotNull @NlsSafe String newName2) {
        if (file2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(0);
        }
        if (newName2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(1);
        }
        Icon icon2 = file2.getIcon(0);
        HtmlChunk iconChunk = IntentionPreviewInfo.getIconChunk(icon2, "file");
        HtmlChunk fragment = new HtmlBuilder().append(iconChunk).append(file2.getName()).append(" ").append(HtmlChunk.htmlEntity("&rarr;")).append(" ").append(iconChunk).append(newName2).toFragment();
        return new Html(fragment.wrapWith("p"));
    }

    @NotNull
    private static HtmlChunk getIconChunk(@Nullable Icon icon2, @NotNull String id) {
        if (id == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(2);
        }
        if (icon2 instanceof DeferredIcon) {
            icon2 = ((DeferredIcon)icon2).evaluate();
        }
        HtmlChunk htmlChunk = icon2 == null ? HtmlChunk.empty() : new HtmlBuilder().append(HtmlChunk.icon(id, icon2)).nbsp().toFragment();
        if (htmlChunk == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(3);
        }
        return htmlChunk;
    }

    @NotNull
    public static IntentionPreviewInfo moveToDirectory(@NotNull VirtualFile file2, @NotNull VirtualFile directory) {
        if (file2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(4);
        }
        if (directory == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(5);
        }
        Icon fileIcon = IconUtil.getIcon((VirtualFile)file2, (int)0, null);
        Icon dirIcon = IconUtil.getIcon((VirtualFile)directory, (int)0, null);
        @NlsSafe String location2 = VfsUtilCore.getRelativeLocation(directory, file2.getParent());
        if (location2 == null) {
            location2 = directory.getPath();
        }
        HtmlBuilder builder2 = new HtmlBuilder().append(HtmlChunk.icon("file", fileIcon)).nbsp().append(file2.getName()).append(" ").append(HtmlChunk.htmlEntity("&rarr;")).append(" ").append(HtmlChunk.icon("dir", dirIcon)).nbsp().append(location2);
        return new Html(builder2.wrapWith("p"));
    }

    @NotNull
    public static IntentionPreviewInfo movePsi(@NotNull PsiNamedElement source, @NotNull PsiNamedElement target2) {
        Icon targetIcon;
        Icon sourceIcon;
        if (source == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(6);
        }
        if (target2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(7);
        }
        if ((sourceIcon = source.getIcon(0)) instanceof DeferredIcon) {
            sourceIcon = ((DeferredIcon)sourceIcon).evaluate();
        }
        if ((targetIcon = target2.getIcon(0)) instanceof DeferredIcon) {
            targetIcon = ((DeferredIcon)targetIcon).evaluate();
        }
        HtmlChunk moveFragment = IntentionPreviewInfo.getHtmlMoveFragment(sourceIcon, targetIcon, source.getName(), target2.getName());
        return new Html(moveFragment.wrapWith("p"));
    }

    @NotNull
    public static IntentionPreviewInfo moveMultiplePsi(@NotNull List<PsiNamedElement> sources, @NotNull PsiNamedElement target2) {
        if (sources == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(8);
        }
        if (target2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(9);
        }
        return IntentionPreviewInfo.moveMultiplePsi(sources, target2, null);
    }

    @NotNull
    public static IntentionPreviewInfo moveMultiplePsi(@NotNull List<PsiNamedElement> sources, @NotNull PsiNamedElement target2, @Nullable @Nls String explicitTargetName) {
        if (sources == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(10);
        }
        if (target2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(11);
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        Icon targetIcon = IntentionPreviewInfo.getIcon(target2);
        builder2.appendWithSeparators(HtmlChunk.br(), ContainerUtil.map(sources, source -> IntentionPreviewInfo.getHtmlMoveFragment(IntentionPreviewInfo.getIcon(source), targetIcon, source.getName(), explicitTargetName == null ? target2.getName() : explicitTargetName)));
        return new Html(builder2.wrapWith("p"));
    }

    private static Icon getIcon(@NotNull PsiNamedElement source) {
        Icon icon2;
        if (source == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(12);
        }
        if ((icon2 = source.getIcon(0)) instanceof DeferredIcon) {
            icon2 = ((DeferredIcon)icon2).evaluate();
        }
        return icon2;
    }

    @NotNull
    private static HtmlChunk getHtmlMoveFragment(@Nullable Icon sourceIcon, @Nullable Icon targetIcon, @Nullable @Nls String sourceName, @Nullable @Nls String targetName) {
        HtmlChunk htmlChunk = new HtmlBuilder().append(IntentionPreviewInfo.getIconChunk(sourceIcon, "source_" + sourceName)).append(Objects.requireNonNull(sourceName)).append(" ").append(HtmlChunk.htmlEntity("&rarr;")).append(" ").append(IntentionPreviewInfo.getIconChunk(targetIcon, "target_" + targetName)).append(Objects.requireNonNull(targetName)).toFragment();
        if (htmlChunk == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(13);
        }
        return htmlChunk;
    }

    @NotNull
    public static IntentionPreviewInfo navigate(@NotNull NavigatablePsiElement target2) {
        if (target2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(14);
        }
        PsiFile file2 = target2.getContainingFile();
        Icon icon2 = file2.getIcon(0);
        int offset2 = target2.getTextOffset();
        Document document = file2.getViewProvider().getDocument();
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(HtmlChunk.htmlEntity("&rarr;")).append(" ");
        builder2.append(IntentionPreviewInfo.getIconChunk(icon2, "icon"));
        builder2.append(file2.getName());
        if (document.getTextLength() > offset2) {
            int lineNumber = document.getLineNumber(offset2);
            builder2.append(AnalysisBundle.message("html.preview.navigate.line", new Object[0])).append(String.valueOf(lineNumber + 1));
        }
        return new Html(builder2.wrapWith("p"));
    }

    public static IntentionPreviewInfo addListOption(@NotNull List<@NlsSafe String> updatedList, @NotNull String addedOption, @NotNull @Nls String title) {
        if (updatedList == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(15);
        }
        if (addedOption == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(16);
        }
        if (title == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(17);
        }
        return IntentionPreviewInfo.addListOption(updatedList, title, Predicate.isEqual(addedOption));
    }

    public static IntentionPreviewInfo addListOption(@NotNull List<@NlsSafe String> updatedList, @NotNull @Nls String title, @NotNull Predicate<String> toSelect2) {
        if (updatedList == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(18);
        }
        if (title == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(19);
        }
        if (toSelect2 == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(20);
        }
        int maxToList = Math.min(7, updatedList.size() + 2);
        HtmlChunk.Element select2 = HtmlChunk.tag("select").attr("multiple", "multiple").attr("size", maxToList).children(ContainerUtil.map2Array(updatedList, HtmlChunk.class, pref -> {
            HtmlChunk.Element chunk = HtmlChunk.tag("option").addText((String)pref);
            return toSelect2.test((String)pref) ? chunk.attr("selected", "selected") : chunk;
        }));
        HtmlChunk content2 = new HtmlBuilder().append(title).br().br().append(select2).toFragment();
        return new Html(content2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedList";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedOption";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconChunk";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlMoveFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIconChunk";
                break;
            }
            case 3: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveToDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "movePsi";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveMultiplePsi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addListOption";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 13 -> new IllegalStateException(string2);
        };
    }

    public static class Html
    implements IntentionPreviewInfo {
        @NotNull
        private final HtmlChunk myContent;

        public Html(@NotNull HtmlChunk content2) {
            if (content2 == null) {
                Html.$$$reportNull$$$0(0);
            }
            this.myContent = content2;
        }

        public Html(@Nls @NotNull String contentHtml) {
            if (contentHtml == null) {
                Html.$$$reportNull$$$0(1);
            }
            this(HtmlChunk.raw(contentHtml));
        }

        @NotNull
        public HtmlChunk content() {
            HtmlChunk htmlChunk = this.myContent;
            if (htmlChunk == null) {
                Html.$$$reportNull$$$0(2);
            }
            return htmlChunk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentHtml";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$Html";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$Html";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    public static class CustomDiff
    implements IntentionPreviewInfo {
        @NotNull
        private final FileType myFileType;
        @NotNull
        private final String myOrigText;
        @NotNull
        private final String myModifiedText;
        @Nullable
        private final String myFileName;

        public CustomDiff(@NotNull FileType type, @NotNull String origText, @NotNull String modifiedText) {
            if (type == null) {
                CustomDiff.$$$reportNull$$$0(0);
            }
            if (origText == null) {
                CustomDiff.$$$reportNull$$$0(1);
            }
            if (modifiedText == null) {
                CustomDiff.$$$reportNull$$$0(2);
            }
            this(type, null, origText, modifiedText);
        }

        public CustomDiff(@NotNull FileType type, @Nullable String name, @NotNull String origText, @NotNull String modifiedText) {
            if (type == null) {
                CustomDiff.$$$reportNull$$$0(3);
            }
            if (origText == null) {
                CustomDiff.$$$reportNull$$$0(4);
            }
            if (modifiedText == null) {
                CustomDiff.$$$reportNull$$$0(5);
            }
            this.myFileType = type;
            this.myFileName = name;
            this.myOrigText = origText;
            this.myModifiedText = modifiedText;
        }

        @Nullable
        public String fileName() {
            return this.myFileName;
        }

        @NotNull
        public FileType fileType() {
            FileType fileType = this.myFileType;
            if (fileType == null) {
                CustomDiff.$$$reportNull$$$0(6);
            }
            return fileType;
        }

        @NotNull
        public String originalText() {
            String string2 = this.myOrigText;
            if (string2 == null) {
                CustomDiff.$$$reportNull$$$0(7);
            }
            return string2;
        }

        @NotNull
        public String modifiedText() {
            String string2 = this.myModifiedText;
            if (string2 == null) {
                CustomDiff.$$$reportNull$$$0(8);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origText";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedText";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$CustomDiff";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$CustomDiff";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "originalText";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modifiedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 6, 7, 8 -> new IllegalStateException(string2);
            };
        }
    }
}

