/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.preview;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionPreviewUtils {
    private static final Key<Boolean> PREVIEW_MARKER = Key.create("PREVIEW_MARKER");
    private static final ThreadLocal<Editor> PREVIEW_EDITOR = new ThreadLocal();

    @ApiStatus.Internal
    @NotNull
    public static PsiFile obtainCopyForPreview(@NotNull PsiFile file2) {
        if (file2 == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(0);
        }
        PsiFile copy2 = (PsiFile)file2.copy();
        copy2.putUserData(PREVIEW_MARKER, true);
        PsiFile psiFile = copy2;
        if (psiFile == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    public static boolean isPreviewElement(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(2);
        }
        return (file2 = element.getContainingFile()) != null && Boolean.TRUE.equals(file2.getUserData(PREVIEW_MARKER));
    }

    public static boolean prepareElementForWrite(@NotNull PsiElement element) {
        if (element == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(3);
        }
        if (IntentionPreviewUtils.isPreviewElement(element)) {
            return true;
        }
        return FileModificationService.getInstance().preparePsiElementForWrite(element);
    }

    public static <E extends Throwable> void write(@NotNull ThrowableRunnable<E> action2) throws E {
        if (action2 == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(4);
        }
        if (PREVIEW_EDITOR.get() != null) {
            action2.run();
        } else {
            WriteAction.run(action2);
        }
    }

    public static <T, E extends Throwable> T writeAndCompute(@NotNull ThrowableComputable<T, E> action2) throws E {
        if (action2 == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(5);
        }
        if (PREVIEW_EDITOR.get() != null) {
            return action2.compute();
        }
        return WriteAction.compute(action2);
    }

    @ApiStatus.Internal
    public static void previewSession(@NotNull Editor editor2, @NotNull Runnable runnable) {
        if (editor2 == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            IntentionPreviewUtils.$$$reportNull$$$0(7);
        }
        PREVIEW_EDITOR.set(editor2);
        try {
            runnable.run();
        }
        finally {
            PREVIEW_EDITOR.remove();
        }
    }

    @Nullable
    public static Editor getPreviewEditor() {
        return PREVIEW_EDITOR.get();
    }

    public static boolean isIntentionPreviewActive() {
        return PREVIEW_EDITOR.get() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainCopyForPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainCopyForPreview";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareElementForWrite";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeAndCompute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "previewSession";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

