/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ComparingClassifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ForceableComparable;
import com.intellij.util.ProcessingContext;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingComparingClassifier
extends ComparingClassifier<LookupElement> {
    private final Map<LookupElement, Comparable> myWeights = new IdentityHashMap<LookupElement, Comparable>();
    private final LookupElementWeigher myWeigher;
    private Ref<Comparable> myFirstWeight;
    private volatile boolean myPrimitive = true;
    private int myPrefixChanges = -1;

    public CachingComparingClassifier(Classifier<LookupElement> next2, LookupElementWeigher weigher) {
        super(next2, weigher.toString(), weigher.isNegated());
        this.myWeigher = weigher;
    }

    @Override
    @Nullable
    public final Comparable getWeight(LookupElement element, ProcessingContext context2) {
        Comparable w = this.myWeights.get(element);
        if (w == null && this.myWeigher.isPrefixDependent()) {
            w = this.myWeigher.weigh(element, context2.get(CompletionLookupArranger.WEIGHING_CONTEXT));
            this.myWeights.put(element, w);
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context2) {
        if (element == null) {
            CachingComparingClassifier.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(1);
        }
        CachingComparingClassifier cachingComparingClassifier = this;
        synchronized (cachingComparingClassifier) {
            this.myWeights.remove(element);
        }
        super.removeElement(element, context2);
    }

    @Override
    @NotNull
    public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context2) {
        if (source == null) {
            CachingComparingClassifier.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(3);
        }
        if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
            Iterable<LookupElement> iterable = this.myNext.classify(source, context2);
            if (iterable == null) {
                CachingComparingClassifier.$$$reportNull$$$0(4);
            }
            return iterable;
        }
        this.checkPrefixChanged(context2);
        Iterable<LookupElement> iterable = super.classify(source, context2);
        if (iterable == null) {
            CachingComparingClassifier.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    private synchronized void checkPrefixChanged(ProcessingContext context2) {
        int actualPrefixChanges = context2.get(CompletionLookupArranger.PREFIX_CHANGES);
        if (this.myWeigher.isPrefixDependent() && this.myPrefixChanges != actualPrefixChanges) {
            this.myPrefixChanges = actualPrefixChanges;
            this.myWeights.clear();
        }
    }

    @Override
    @NotNull
    public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items2, @NotNull ProcessingContext context2) {
        if (items2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(7);
        }
        this.checkPrefixChanged(context2);
        List<Pair<LookupElement, Object>> list2 = super.getSortingWeights(items2, context2);
        if (list2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(8);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElement(@NotNull LookupElement t, @NotNull ProcessingContext context2) {
        Comparable weight;
        if (t == null) {
            CachingComparingClassifier.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(10);
        }
        if ((weight = this.myWeigher.weigh(t, context2.get(CompletionLookupArranger.WEIGHING_CONTEXT))) instanceof ForceableComparable) {
            ((ForceableComparable)((Object)weight)).force();
        }
        CachingComparingClassifier cachingComparingClassifier = this;
        synchronized (cachingComparingClassifier) {
            if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
                if (this.myFirstWeight == null) {
                    this.myFirstWeight = Ref.create(weight);
                } else if (!Comparing.equal(this.myFirstWeight.get(), weight)) {
                    this.myPrimitive = false;
                }
            }
            this.myWeights.put(t, weight);
        }
        super.addElement(t, context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/CachingComparingClassifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/CachingComparingClassifier";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingWeights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSortingWeights";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 8 -> new IllegalStateException(string2);
        };
    }
}

