/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.TailType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;

public class CommaTailType
extends TailType {
    public static final TailType INSTANCE = new CommaTailType();

    @Override
    public int processTail(Editor editor2, int tailOffset) {
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor2);
        Language language = PsiUtilCore.getLanguageAtOffset(PsiEditorUtil.getPsiFile((Editor)editor2), tailOffset);
        CodeStyleSettingsFacade codeStyleFacade = CodeStyle.getFacade((PsiFile)psiFile).withLanguage(language);
        if (codeStyleFacade.isSpaceBeforeComma()) {
            tailOffset = CommaTailType.insertChar(editor2, tailOffset, ' ');
        }
        tailOffset = CommaTailType.insertChar(editor2, tailOffset, ',');
        if (codeStyleFacade.isSpaceAfterComma()) {
            tailOffset = CommaTailType.insertChar(editor2, tailOffset, ' ');
        }
        return tailOffset;
    }

    public String toString() {
        return "COMMA";
    }
}

