/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.SmartList;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupElementPresentation {
    private Icon myIcon;
    private Icon myTypeIcon;
    private boolean myTypeIconRightAligned;
    private String myItemText;
    private String myTypeText;
    private boolean myStrikeout;
    private Color myItemTextForeground = JBColor.namedColor("CompletionPopup.foreground", JBColor.foreground());
    private boolean myItemTextBold;
    private boolean myItemTextUnderlined;
    private boolean myItemTextItalic;
    private boolean myTypeGrayed;
    @Nullable
    private List<TextFragment> myTail;
    private volatile boolean myFrozen;

    public void setIcon(@Nullable Icon icon2) {
        this.ensureMutable();
        this.myIcon = icon2;
    }

    public void setItemText(@Nullable String text2) {
        this.ensureMutable();
        this.myItemText = text2;
    }

    public void setStrikeout(boolean strikeout) {
        this.ensureMutable();
        this.myStrikeout = strikeout;
    }

    public void setItemTextBold(boolean bold) {
        this.ensureMutable();
        this.myItemTextBold = bold;
    }

    public void setItemTextItalic(boolean itemTextItalic) {
        this.ensureMutable();
        this.myItemTextItalic = itemTextItalic;
    }

    public void setTailText(@Nullable String text2) {
        this.setTailText(text2, false);
    }

    public void clearTail() {
        this.ensureMutable();
        this.myTail = null;
    }

    public void appendTailText(@NotNull String text2, boolean grayed) {
        if (text2 == null) {
            LookupElementPresentation.$$$reportNull$$$0(0);
        }
        this.appendTailText(new TextFragment(text2, grayed, false, null));
    }

    public void appendTailTextItalic(@NotNull String text2, boolean grayed) {
        if (text2 == null) {
            LookupElementPresentation.$$$reportNull$$$0(1);
        }
        this.appendTailText(new TextFragment(text2, grayed, true, null));
    }

    private void appendTailText(@NotNull TextFragment fragment) {
        if (fragment == null) {
            LookupElementPresentation.$$$reportNull$$$0(2);
        }
        this.ensureMutable();
        if (fragment.text.isEmpty()) {
            return;
        }
        if (this.myTail == null) {
            this.myTail = new SmartList<TextFragment>();
        }
        this.myTail.add(fragment);
    }

    public void setTailText(@Nullable String text2, boolean grayed) {
        this.clearTail();
        if (text2 != null) {
            this.appendTailText(new TextFragment(text2, grayed, false, null));
        }
    }

    public void setTailText(@Nullable String text2, @Nullable Color foreground) {
        this.clearTail();
        if (text2 != null) {
            this.appendTailText(new TextFragment(text2, false, false, foreground));
        }
    }

    public void setTypeText(@Nullable String text2) {
        this.setTypeText(text2, null);
    }

    public void setTypeText(@Nullable String text2, @Nullable Icon icon2) {
        this.ensureMutable();
        this.myTypeText = text2;
        this.myTypeIcon = icon2;
    }

    @Deprecated(forRemoval=true)
    public boolean isReal() {
        return true;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public Icon getTypeIcon() {
        return this.myTypeIcon;
    }

    @Nullable
    public String getItemText() {
        return this.myItemText;
    }

    @NotNull
    public List<TextFragment> getTailFragments() {
        List<TextFragment> list2 = this.myTail == null ? Collections.emptyList() : Collections.unmodifiableList(this.myTail);
        if (list2 == null) {
            LookupElementPresentation.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public String getTailText() {
        if (this.myTail == null) {
            return null;
        }
        return StringUtil.join(this.myTail, fragment -> fragment.text, "");
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isStrikeout() {
        return this.myStrikeout;
    }

    public boolean isItemTextBold() {
        return this.myItemTextBold;
    }

    public boolean isItemTextItalic() {
        return this.myItemTextItalic;
    }

    public boolean isItemTextUnderlined() {
        return this.myItemTextUnderlined;
    }

    public void setItemTextUnderlined(boolean itemTextUnderlined) {
        this.ensureMutable();
        this.myItemTextUnderlined = itemTextUnderlined;
    }

    @NotNull
    public Color getItemTextForeground() {
        Color color = this.myItemTextForeground;
        if (color == null) {
            LookupElementPresentation.$$$reportNull$$$0(4);
        }
        return color;
    }

    public void setItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementPresentation.$$$reportNull$$$0(5);
        }
        this.ensureMutable();
        this.myItemTextForeground = itemTextForeground;
    }

    public void copyFrom(@NotNull LookupElementPresentation presentation2) {
        if (presentation2 == null) {
            LookupElementPresentation.$$$reportNull$$$0(6);
        }
        this.myIcon = presentation2.myIcon;
        this.myTypeIcon = presentation2.myTypeIcon;
        this.myItemText = presentation2.myItemText;
        List<TextFragment> thatTail = presentation2.myTail;
        this.myTail = thatTail == null ? null : new SmartList<TextFragment>((Collection<TextFragment>)thatTail);
        this.myTypeText = presentation2.myTypeText;
        this.myStrikeout = presentation2.myStrikeout;
        this.myItemTextBold = presentation2.myItemTextBold;
        this.myItemTextItalic = presentation2.myItemTextItalic;
        this.myTypeGrayed = presentation2.myTypeGrayed;
        this.myTypeIconRightAligned = presentation2.myTypeIconRightAligned;
        this.myItemTextUnderlined = presentation2.myItemTextUnderlined;
        this.myItemTextForeground = presentation2.myItemTextForeground;
    }

    public boolean isTypeGrayed() {
        return this.myTypeGrayed;
    }

    public void setTypeGrayed(boolean typeGrayed) {
        this.ensureMutable();
        this.myTypeGrayed = typeGrayed;
    }

    private void ensureMutable() {
        if (this.myFrozen) {
            throw new IllegalStateException("This lookup element presentation can't be changed");
        }
    }

    public boolean isTypeIconRightAligned() {
        return this.myTypeIconRightAligned;
    }

    public void setTypeIconRightAligned(boolean typeIconRightAligned) {
        this.ensureMutable();
        this.myTypeIconRightAligned = typeIconRightAligned;
    }

    public static LookupElementPresentation renderElement(LookupElement element) {
        LookupElementPresentation presentation2 = new LookupElementPresentation();
        element.renderElement(presentation2);
        return presentation2;
    }

    @ApiStatus.Internal
    public void freeze() {
        this.myFrozen = true;
    }

    public String toString() {
        return "LookupElementPresentation{itemText='" + this.myItemText + "', tail=" + this.myTail + ", typeText='" + this.myTypeText + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupElementPresentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextForeground";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupElementPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTailFragments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemTextForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendTailText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendTailTextItalic";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItemTextForeground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }

    public static final class TextFragment {
        public final String text;
        private final boolean myGrayed;
        private final boolean myItalic;
        @Nullable
        private final Color myFgColor;

        private TextFragment(String text2, boolean grayed, boolean italic, @Nullable Color fgColor) {
            this.text = text2;
            this.myGrayed = grayed;
            this.myItalic = italic;
            this.myFgColor = fgColor;
        }

        public String toString() {
            return "TextFragment{text='" + this.text + "'" + (this.myGrayed ? ", grayed" : "") + (this.myItalic ? ", italic" : "") + (String)(this.myFgColor != null ? ", fgColor=" + this.myFgColor : "") + "}";
        }

        public boolean isGrayed() {
            return this.myGrayed;
        }

        public boolean isItalic() {
            return this.myItalic;
        }

        @Nullable
        public Color getForegroundColor() {
            return this.myFgColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextFragment)) {
                return false;
            }
            TextFragment fragment = (TextFragment)o;
            return this.myGrayed == fragment.myGrayed && this.myItalic == fragment.myItalic && Objects.equals(this.text, fragment.text) && Objects.equals(this.myFgColor, fragment.myFgColor);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.myGrayed, this.myItalic, this.myFgColor);
        }
    }
}

