/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J0\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0007J\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/lookup/LookupUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCaseCorrectedLookupString", "", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "prefix", "getInjectedDocument", "Lcom/intellij/injected/editor/DocumentWindow;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "insertLookupInDocument", "caretOffset", "document", "Lcom/intellij/openapi/editor/Document;", "lookupString", "insertLookupInDocumentWindowIfNeeded", "performGuardedChange", "", "action", "Ljava/lang/Runnable;", "intellij.platform.analysis.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLookupUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupUtil.kt\ncom/intellij/codeInsight/lookup/LookupUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n1#2:114\n10#3:115\n*S KotlinDebug\n*F\n+ 1 LookupUtil.kt\ncom/intellij/codeInsight/lookup/LookupUtil\n*L\n20#1:115\n*E\n"})
public final class LookupUtil {
    @NotNull
    public static final LookupUtil INSTANCE = new LookupUtil();
    @NotNull
    private static final Logger LOG;

    private LookupUtil() {
    }

    @JvmStatic
    public static final int insertLookupInDocumentWindowIfNeeded(@NotNull Project project2, @NotNull Editor editor2, int caretOffset, int prefix, @NotNull String lookupString) {
        int n;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        DocumentWindow document = INSTANCE.getInjectedDocument(project2, editor2, caretOffset);
        if (document == null) {
            Document document2 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
            return INSTANCE.insertLookupInDocument(caretOffset, document2, prefix, lookupString);
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        int offset2 = document.hostToInjected(caretOffset);
        int lookupStart = Math.min(offset2, Math.max(offset2 - prefix, 0));
        int diff = -1;
        if (file2 != null) {
            List<TextRange> list2 = InjectedLanguageManager.getInstance(project2).intersectWithAllEditableFragments(file2, TextRange.create(lookupStart, offset2));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project)\n   \u2026ate(lookupStart, offset))");
            List<TextRange> ranges2 = list2;
            if (!((Collection)ranges2).isEmpty()) {
                diff = ranges2.get(0).getStartOffset() - lookupStart;
                if (ranges2.size() == 1 && diff == 0) {
                    diff = -1;
                }
            }
        }
        if (diff == -1) {
            Document document3 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"editor.document");
            n = INSTANCE.insertLookupInDocument(caretOffset, document3, prefix, lookupString);
        } else {
            String string2;
            Document document4 = document;
            if (diff == 0) {
                string2 = lookupString;
            } else {
                String string3 = lookupString.substring(diff);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            }
            n = document.injectedToHost(INSTANCE.insertLookupInDocument(offset2, document4, prefix - diff, string2));
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final String getCaseCorrectedLookupString(@NotNull LookupElement item, @NotNull PrefixMatcher prefixMatcher, @NotNull String prefix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string3 = item.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"item.lookupString");
        String lookupString = string3;
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        int length = prefix.length();
        if (length == 0 || !prefixMatcher.prefixMatches(prefix)) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        int i2 = 0;
        while (i2 < length && (isAllLower || isAllUpper || sameCase)) {
            char c2 = prefix.charAt(i2);
            boolean isLower = Character.isLowerCase(c2);
            boolean isUpper = Character.isUpperCase(c2);
            if (!isLower && !isUpper) {
                ++i2;
                continue;
            }
            isAllLower = isAllLower && isLower;
            isAllUpper = isAllUpper && isUpper;
            sameCase = sameCase && i2 < lookupString.length() && isLower == Character.isLowerCase(lookupString.charAt(i2));
            ++i2;
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            String string4 = StringUtil.toLowerCase(lookupString);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(lookupString)");
            return string4;
        }
        if (isAllUpper) {
            String string5 = StringUtil.toUpperCase(lookupString);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(lookupString)");
        } else {
            string2 = lookupString;
        }
        return string2;
    }

    private final DocumentWindow getInjectedDocument(Project project2, Editor editor2, int offset2) {
        PsiFile hostFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (hostFile != null) {
            List<DocumentWindow> list2 = InjectedLanguageManager.getInstance(project2).getCachedInjectedDocumentsInRange(hostFile, TextRange.create(offset2, offset2));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project)\n   \u2026e.create(offset, offset))");
            List<DocumentWindow> injected = list2;
            for (DocumentWindow documentWindow : injected) {
                if (!documentWindow.isValid() || !documentWindow.containsRange(offset2, offset2)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    private final int insertLookupInDocument(int caretOffset, Document document, int prefix, String lookupString) {
        int lookupStart = Math.min(caretOffset, Math.max(caretOffset - prefix, 0));
        int len = document.getTextLength();
        LOG.assertTrue(0 <= lookupStart ? lookupStart <= len : false, "ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len);
        LOG.assertTrue(0 <= caretOffset ? caretOffset <= len : false, "co: " + caretOffset + " doc: " + len);
        document.replaceString(lookupStart, caretOffset, lookupString);
        return lookupStart + lookupString.length();
    }

    @JvmStatic
    public static final void performGuardedChange(@Nullable Editor editor2, @NotNull Runnable action2) {
        LookupEx lookup2;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Editor editor3 = editor2;
        if (editor3 != null) {
            Editor p0 = editor3;
            boolean bl = false;
            v1 = LookupManager.getActiveLookup(p0);
        } else {
            v1 = lookup2 = null;
        }
        if (lookup2 == null) {
            action2.run();
        } else {
            lookup2.performGuardedChange(action2);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LookupUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

