/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@ApiStatus.Internal
public class AsyncRendering {
    private static final Key<LookupElementPresentation> LAST_COMPUTED_PRESENTATION = Key.create("LAST_COMPUTED_PRESENTATION");
    private static final Key<CancellablePromise<?>> LAST_COMPUTATION = Key.create("LAST_COMPUTATION");
    private static final Executor ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("ExpensiveRendering");
    private final LookupImpl myLookup;

    AsyncRendering(LookupImpl lookup2) {
        this.myLookup = lookup2;
    }

    @NotNull
    LookupElementPresentation getLastComputed(@NotNull LookupElement element) {
        if (element == null) {
            AsyncRendering.$$$reportNull$$$0(0);
        }
        LookupElementPresentation lookupElementPresentation = Objects.requireNonNull(element.getUserData(LAST_COMPUTED_PRESENTATION));
        if (lookupElementPresentation == null) {
            AsyncRendering.$$$reportNull$$$0(1);
        }
        return lookupElementPresentation;
    }

    static void rememberPresentation(LookupElement element, LookupElementPresentation presentation2) {
        element.putUserData(LAST_COMPUTED_PRESENTATION, presentation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleRendering(@NotNull LookupElement element, @NotNull LookupElementRenderer<?> renderer) {
        if (element == null) {
            AsyncRendering.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            AsyncRendering.$$$reportNull$$$0(3);
        }
        Key<CancellablePromise<?>> key = LAST_COMPUTATION;
        synchronized (key) {
            AsyncRendering.cancelRendering(element);
            Ref<CancellablePromise<Void>> promiseRef = Ref.create();
            CancellablePromise<Void> promise = ReadAction.nonBlocking(() -> {
                if (element.isValid()) {
                    this.renderInBackground(element, renderer);
                }
                Key<CancellablePromise<?>> key = LAST_COMPUTATION;
                synchronized (key) {
                    element.replace(LAST_COMPUTATION, (CancellablePromise)promiseRef.get(), null);
                }
            }).expireWith(this.myLookup).submit(ourExecutor);
            element.putUserData(LAST_COMPUTATION, promise);
            promiseRef.set(promise);
        }
    }

    private void renderInBackground(LookupElement element, LookupElementRenderer renderer) {
        LookupElementPresentation presentation2 = new LookupElementPresentation();
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> renderer.renderElement(element, presentation2));
        presentation2.freeze();
        AsyncRendering.rememberPresentation(element, presentation2);
        this.myLookup.myCellRenderer.scheduleUpdateLookupWidthFromVisibleItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelRendering(@NotNull LookupElement item) {
        if (item == null) {
            AsyncRendering.$$$reportNull$$$0(4);
        }
        Key<CancellablePromise<?>> key = LAST_COMPUTATION;
        synchronized (key) {
            CancellablePromise<?> promise = item.getUserData(LAST_COMPUTATION);
            if (promise != null) {
                promise.cancel();
                item.putUserData(LAST_COMPUTATION, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/AsyncRendering";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/AsyncRendering";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastComputed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLastComputed";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRendering";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cancelRendering";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

