/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.BackspaceHandler;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupTypedHandler;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ScrollingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupActionHandler
extends EditorActionHandler {
    protected final EditorActionHandler myOriginalHandler;

    public LookupActionHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public boolean executeInCommand(@NotNull Editor editor2, DataContext dataContext2) {
        if (editor2 == null) {
            LookupActionHandler.$$$reportNull$$$0(0);
        }
        return LookupManager.getActiveLookup(editor2) == null;
    }

    public void doExecute(@NotNull Editor editor2, Caret caret, DataContext dataContext2) {
        LookupImpl lookup2;
        if (editor2 == null) {
            LookupActionHandler.$$$reportNull$$$0(1);
        }
        if ((lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2)) == null || !lookup2.isAvailableToUser()) {
            Project project2 = editor2.getProject();
            if (project2 != null && lookup2 != null) {
                LookupManager.getInstance(project2).hideActiveLookup();
            }
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, caret, dataContext2);
            }
            return;
        }
        lookup2.markSelectionTouched();
        this.executeInLookup(lookup2, dataContext2, caret);
    }

    protected abstract void executeInLookup(LookupImpl var1, DataContext var2, @Nullable Caret var3);

    public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        LookupImpl lookup2;
        if (editor2 == null) {
            LookupActionHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            LookupActionHandler.$$$reportNull$$$0(3);
        }
        return (lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2)) != null || this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor2, caret, dataContext2);
    }

    private static void executeUpOrDown(LookupImpl lookup2, boolean up) {
        if (!lookup2.isFocused()) {
            boolean semiFocused = lookup2.getLookupFocusDegree() == LookupFocusDegree.SEMI_FOCUSED;
            lookup2.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
            if (!up && !semiFocused) {
                return;
            }
        }
        if (up) {
            ScrollingUtil.moveUp(lookup2.getList(), (int)0);
        } else {
            ScrollingUtil.moveDown(lookup2.getList(), (int)0);
        }
        lookup2.markSelectionTouched();
        lookup2.refreshUi(false, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RightHandler
    extends LookupActionHandler {
        public RightHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup2, DataContext context2, Caret caret) {
            Editor editor2 = lookup2.getEditor();
            int offset2 = editor2.getCaretModel().getOffset();
            CharSequence seq = editor2.getDocument().getCharsSequence();
            if (seq.length() <= offset2 || !lookup2.isCompletion()) {
                this.myOriginalHandler.execute(editor2, caret, context2);
                return;
            }
            char c2 = seq.charAt(offset2);
            CharFilter.Result lookupAction = LookupTypedHandler.getLookupAction(c2, lookup2);
            if (lookupAction != CharFilter.Result.ADD_TO_PREFIX || Character.isWhitespace(c2)) {
                this.myOriginalHandler.execute(editor2, caret, context2);
                return;
            }
            if (!lookup2.performGuardedChange(() -> {
                CaretAction action2 = lookupCaret -> {
                    lookupCaret.removeSelection();
                    int caretOffset = lookupCaret.getOffset();
                    if (caretOffset < seq.length()) {
                        lookupCaret.moveToOffset(caretOffset + 1);
                    }
                };
                if (caret == null) {
                    editor2.getCaretModel().runForEachCaret(action2);
                } else {
                    action2.perform(caret);
                }
            })) {
                return;
            }
            lookup2.fireBeforeAppendPrefix(c2);
            lookup2.appendPrefix(c2);
            CompletionProgressIndicator completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
            if (completion != null) {
                completion.prefixUpdated();
            }
        }
    }

    public static class LeftHandler
    extends LookupActionHandler {
        public LeftHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup2, DataContext context2, Caret caret) {
            if (!lookup2.isCompletion()) {
                this.myOriginalHandler.execute(lookup2.getEditor(), caret, context2);
                return;
            }
            if (!lookup2.performGuardedChange(() -> lookup2.getEditor().getSelectionModel().removeSelection())) {
                return;
            }
            BackspaceHandler.truncatePrefix(context2, lookup2, this.myOriginalHandler, lookup2.getLookupStart() - 1, caret);
        }
    }

    public static class PageUpHandler
    extends LookupActionHandler {
        public PageUpHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup2, DataContext context2, Caret caret) {
            lookup2.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
            ScrollingUtil.movePageUp(lookup2.getList());
        }
    }

    public static class PageDownHandler
    extends LookupActionHandler {
        public PageDownHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup2, DataContext context2, Caret caret) {
            lookup2.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
            ScrollingUtil.movePageDown(lookup2.getList());
        }
    }

    public static class UpHandler
    extends LookupActionHandler {
        public UpHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup2, DataContext context2, Caret caret) {
            if (!UISettings.getInstance().getCycleScrolling() && !lookup2.isFocused() && lookup2.getList().getSelectedIndex() == 0) {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(lookup2.getEditor(), caret, context2);
                }
                return;
            }
            LookupActionHandler.executeUpOrDown(lookup2, true);
        }
    }

    private static final class UpDownInEditorHandler
    extends EditorActionHandler {
        private final boolean myUp;

        private UpDownInEditorHandler(boolean up) {
            this.myUp = up;
        }

        public boolean executeInCommand(@NotNull Editor editor2, DataContext dataContext2) {
            if (editor2 == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(0);
            }
            return false;
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(2);
            }
            return LookupManager.getActiveLookup(editor2) != null;
        }

        protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                UpDownInEditorHandler.$$$reportNull$$$0(3);
            }
            LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2);
            assert (lookup2 != null);
            lookup2.hideLookup(true);
            EditorActionManager.getInstance().getActionHandler(this.myUp ? "EditorUp" : "EditorDown").execute(editor2, caret, dataContext2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupActionHandler$UpDownInEditorHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeInCommand";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DownInLookupAction
    extends EditorAction {
        public DownInLookupAction() {
            super((EditorActionHandler)new DownHandler(null));
        }
    }

    public static class UpInLookupAction
    extends EditorAction {
        public UpInLookupAction() {
            super((EditorActionHandler)new UpHandler(null));
        }
    }

    public static class DownAction
    extends EditorAction {
        public DownAction() {
            super((EditorActionHandler)new UpDownInEditorHandler(false));
        }
    }

    public static class UpAction
    extends EditorAction {
        public UpAction() {
            super((EditorActionHandler)new UpDownInEditorHandler(true));
        }
    }

    public static class DownHandler
    extends LookupActionHandler {
        public DownHandler(EditorActionHandler originalHandler) {
            super(originalHandler);
        }

        @Override
        protected void executeInLookup(LookupImpl lookup2, DataContext context2, Caret caret) {
            LookupActionHandler.executeUpOrDown(lookup2, false);
        }
    }
}

