/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.MathUtil;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupOffsets
implements DocumentListener {
    @NotNull
    private String myAdditionalPrefix = "";
    private boolean myStableStart;
    @Nullable
    private Supplier<String> myStartMarkerDisposeInfo = null;
    @NotNull
    private RangeMarker myLookupStartMarker;
    private int myRemovedPrefix;
    private RangeMarker myLookupOriginalStartMarker;
    private final Editor myEditor;

    public LookupOffsets(Editor editor2) {
        this.myEditor = editor2;
        int caret = this.getPivotOffset();
        this.myLookupOriginalStartMarker = this.createLeftGreedyMarker(caret);
        this.myLookupStartMarker = this.createLeftGreedyMarker(caret);
        this.myEditor.getDocument().addDocumentListener(this);
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        int start;
        if (e == null) {
            LookupOffsets.$$$reportNull$$$0(0);
        }
        if (!this.myLookupStartMarker.isValid()) {
            start = this.calculateStartOffset(0, true);
            this.myLookupStartMarker.dispose();
            this.myLookupStartMarker = this.createLeftGreedyMarker(start);
            this.myStartMarkerDisposeInfo = null;
        }
        if (!this.myLookupOriginalStartMarker.isValid()) {
            start = this.calculateStartOffset(0, false);
            this.myLookupOriginalStartMarker.dispose();
            this.myLookupOriginalStartMarker = this.createLeftGreedyMarker(start);
        }
        if (this.myStartMarkerDisposeInfo == null && !this.myLookupStartMarker.isValid()) {
            Throwable throwable = new Throwable();
            String eString = e.toString();
            this.myStartMarkerDisposeInfo = () -> eString + "\n" + ExceptionUtil.getThrowableText(throwable);
        }
    }

    private RangeMarker createLeftGreedyMarker(int start) {
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(start, start);
        marker.setGreedyToLeft(true);
        return marker;
    }

    private int getPivotOffset() {
        return this.myEditor.getSelectionModel().hasSelection() ? this.myEditor.getSelectionModel().getSelectionStart() : this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public String getAdditionalPrefix() {
        String string2 = this.myAdditionalPrefix;
        if (string2 == null) {
            LookupOffsets.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public void appendPrefix(char c2) {
        this.myAdditionalPrefix = this.myAdditionalPrefix + c2;
    }

    public boolean truncatePrefix() {
        int len = this.myAdditionalPrefix.length();
        if (len == 0) {
            ++this.myRemovedPrefix;
            return false;
        }
        this.myAdditionalPrefix = this.myAdditionalPrefix.substring(0, len - 1);
        return true;
    }

    void destabilizeLookupStart() {
        this.myStableStart = false;
    }

    void checkMinPrefixLengthChanges(Collection<? extends LookupElement> items2, LookupImpl lookup2) {
        if (this.myStableStart) {
            return;
        }
        if (!lookup2.isCalculating() && !items2.isEmpty()) {
            this.myStableStart = true;
        }
        int minPrefixLength = items2.isEmpty() ? 0 : Integer.MAX_VALUE;
        for (LookupElement lookupElement : items2) {
            if (lookupElement instanceof EmptyLookupItem) continue;
            minPrefixLength = Math.min(lookup2.itemMatcher(lookupElement).getPrefix().length(), minPrefixLength);
        }
        int start = this.calculateStartOffset(minPrefixLength, true);
        if (this.myLookupStartMarker.isValid() && this.myLookupStartMarker.getStartOffset() == start && this.myLookupStartMarker.getEndOffset() == start) {
            return;
        }
        this.myLookupStartMarker.dispose();
        this.myLookupStartMarker = this.createLeftGreedyMarker(start);
        this.myStartMarkerDisposeInfo = null;
    }

    private int calculateStartOffset(int minLookupItemPrefixLength, boolean considerPrefixes) {
        int start = this.getPivotOffset() - minLookupItemPrefixLength;
        if (considerPrefixes) {
            start = start - this.myAdditionalPrefix.length() + this.myRemovedPrefix;
        }
        start = MathUtil.clamp(start, 0, this.myEditor.getDocument().getTextLength());
        return start;
    }

    int getLookupStart(@Nullable Throwable disposeTrace) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid lookup start: " + this.myLookupStartMarker + ", " + this.myEditor + ", disposeTrace=" + (disposeTrace == null ? null : ExceptionUtil.getThrowableText(disposeTrace)) + "\n================\n start dispose trace=" + (this.myStartMarkerDisposeInfo == null ? null : this.myStartMarkerDisposeInfo.get())));
        }
        return this.myLookupStartMarker.getStartOffset();
    }

    int getLookupOriginalStart() {
        return this.myLookupOriginalStartMarker.isValid() ? this.myLookupOriginalStartMarker.getStartOffset() : -1;
    }

    boolean performGuardedChange(Runnable change2) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid start: " + this.myEditor + ", trace=" + (this.myStartMarkerDisposeInfo == null ? null : this.myStartMarkerDisposeInfo.get())));
        }
        change2.run();
        return this.myLookupStartMarker.isValid();
    }

    void clearAdditionalPrefix() {
        this.myAdditionalPrefix = "";
        this.myRemovedPrefix = 0;
    }

    void disposeMarkers() {
        this.myEditor.getDocument().removeDocumentListener(this);
        this.myLookupStartMarker.dispose();
        this.myLookupOriginalStartMarker.dispose();
    }

    public int getPrefixLength(LookupElement item, LookupImpl lookup2) {
        return lookup2.itemPattern(item).length() - this.myRemovedPrefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupOffsets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

