/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.application.options.CodeCompletionConfigurable;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.Advertiser;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LookupUi {
    private static final Logger LOG = Logger.getInstance(LookupUi.class);
    @NotNull
    private final LookupImpl myLookup;
    private final Advertiser myAdvertiser;
    private final JBList myList;
    private final ModalityState myModalityState;
    private final Alarm myHintAlarm;
    private final JScrollPane myScrollPane;
    private final AsyncProcessIcon myProcessIcon;
    private final ActionButton myMenuButton;
    private final ActionButton myHintButton;
    private final JComponent myBottomPanel;
    private int myMaximumHeight;
    private Boolean myPositionedAbove;

    LookupUi(@NotNull LookupImpl lookup2, Advertiser advertiser, JBList list2, boolean showBottomPanel) {
        if (lookup2 == null) {
            LookupUi.$$$reportNull$$$0(0);
        }
        this.myHintAlarm = new Alarm();
        this.myProcessIcon = new AsyncProcessIcon("Completion progress");
        this.myMaximumHeight = Integer.MAX_VALUE;
        this.myPositionedAbove = null;
        this.myLookup = lookup2;
        this.myAdvertiser = advertiser;
        this.myList = list2;
        this.myProcessIcon.setVisible(false);
        this.myLookup.resort(false);
        MenuAction menuAction = new MenuAction();
        menuAction.add((AnAction)new ChangeSortingAction());
        menuAction.add((AnAction)new DelegatedAction(ActionManager.getInstance().getAction("QuickJavaDoc")){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setVisible(!CodeInsightSettings.getInstance().AUTO_POPUP_JAVADOC_INFO);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupUi$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupUi$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        });
        menuAction.add((AnAction)new DelegatedAction(ActionManager.getInstance().getAction("QuickImplementations")));
        menuAction.addSeparator();
        menuAction.add(new ShowCompletionSettingsAction());
        Presentation presentation2 = new Presentation();
        presentation2.setIcon(AllIcons.Actions.More);
        presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
        this.myMenuButton = new ActionButton((AnAction)menuAction, presentation2, "EditorPopup", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        DataManager.registerDataProvider((JComponent)this.myMenuButton, dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myLookup.getProject();
            }
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return this.myLookup.getEditor();
            }
            return null;
        });
        HintAction hintAction = new HintAction();
        this.myHintButton = new ActionButton((AnAction)hintAction, hintAction.getTemplatePresentation().clone(), "EditorPopup", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        this.myHintButton.setVisible(false);
        this.myBottomPanel = new JPanel(new LookupBottomLayout());
        this.myBottomPanel.add(this.myAdvertiser.getAdComponent());
        this.myBottomPanel.add((Component)this.myProcessIcon);
        this.myBottomPanel.add((Component)this.myHintButton);
        this.myBottomPanel.add((Component)this.myMenuButton);
        LookupLayeredPane layeredPane2 = new LookupLayeredPane();
        if (showBottomPanel) {
            layeredPane2.mainPanel.add((Component)this.myBottomPanel, "South");
        }
        this.myScrollPane = ScrollPaneFactory.createScrollPane(lookup2.getList(), (boolean)true);
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        ComponentUtil.putClientProperty(this.myScrollPane.getVerticalScrollBar(), JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS, true);
        if (ExperimentalUI.isNewUI()) {
            Insets bodyInsets = LookupCellRenderer.bodyInsets();
            this.myScrollPane.setBorder(new EmptyBorder(bodyInsets.top, 0, showBottomPanel ? 0 : bodyInsets.bottom, 0));
            this.myBottomPanel.setBackground(JBUI.CurrentTheme.CompletionPopup.Advertiser.background());
            this.myBottomPanel.setBorder(JBUI.CurrentTheme.CompletionPopup.Advertiser.border());
        } else {
            this.myBottomPanel.setOpaque(false);
        }
        ((Container)lookup2.getComponent()).add((Component)((Object)layeredPane2), "Center");
        layeredPane2.mainPanel.add((Component)this.myScrollPane, "Center");
        this.myModalityState = ModalityState.stateForComponent(lookup2.getTopLevelEditor().getComponent());
        this.addListeners();
        Disposer.register(lookup2, (Disposable)this.myProcessIcon);
        Disposer.register(lookup2, (Disposable)this.myHintAlarm);
    }

    private void addListeners() {
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (LookupUi.this.myLookup.isLookupDisposed()) {
                    return;
                }
                LookupUi.this.myHintAlarm.cancelAllRequests();
                LookupUi.this.updateHint();
            }
        });
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(e -> {
            if (this.myLookup.myUpdating || this.myLookup.isLookupDisposed()) {
                return;
            }
            this.myLookup.myCellRenderer.scheduleUpdateLookupWidthFromVisibleItems();
        });
    }

    private void updateHint() {
        Collection<LookupElementAction> actions;
        LookupElement item;
        this.myLookup.checkValid();
        if (this.myHintButton.isVisible()) {
            this.myHintButton.setVisible(false);
        }
        if ((item = this.myLookup.getCurrentItem()) != null && item.isValid() && !(actions = this.myLookup.getActionsFor(item)).isEmpty()) {
            this.myHintAlarm.addRequest(() -> {
                if (ShowHideIntentionIconLookupAction.shouldShowLookupHint() && !((CompletionExtender)this.myList.getExpandableItemsHandler()).isShowing() && !this.myProcessIcon.isVisible()) {
                    this.myHintButton.setVisible(true);
                }
            }, 500, this.myModalityState);
        }
    }

    void setCalculating(boolean calculating) {
        Runnable iconUpdater = () -> {
            if (calculating && this.myHintButton.isVisible()) {
                this.myHintButton.setVisible(false);
            }
            this.myProcessIcon.setVisible(calculating);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!calculating && !this.myLookup.isLookupDisposed()) {
                    this.updateHint();
                }
            }, this.myModalityState);
        };
        if (calculating) {
            this.myProcessIcon.resume();
        } else {
            this.myProcessIcon.suspend();
        }
        new Alarm((Disposable)this.myLookup).addRequest(iconUpdater, 100, this.myModalityState);
    }

    void refreshUi(boolean selectionVisible, boolean itemsChanged, boolean reused, boolean onExplicitAction) {
        Editor editor2 = this.myLookup.getTopLevelEditor();
        if (editor2.getComponent().getRootPane() == null || editor2 instanceof EditorWindow && !((EditorWindow)editor2).isValid()) {
            return;
        }
        if (this.myLookup.myResizePending || itemsChanged) {
            this.myMaximumHeight = Integer.MAX_VALUE;
        }
        Rectangle rectangle = this.calculatePosition();
        this.myMaximumHeight = rectangle.height;
        if (this.myLookup.myResizePending || itemsChanged) {
            this.myLookup.myResizePending = false;
            this.myLookup.pack();
            rectangle = this.calculatePosition();
        }
        HintManagerImpl.updateLocation((LightweightHint)this.myLookup, (Editor)editor2, (Point)rectangle.getLocation());
        if (reused || selectionVisible || onExplicitAction) {
            this.myLookup.ensureSelectionVisible(false);
        }
    }

    boolean isPositionedAboveCaret() {
        return this.myPositionedAbove != null && this.myPositionedAbove != false;
    }

    Rectangle calculatePosition() {
        JRootPane rootPane;
        Component lookupComponent = this.myLookup.getComponent();
        Dimension dim = ((JComponent)lookupComponent).getPreferredSize();
        int lookupStart = this.myLookup.getLookupStart();
        Editor editor2 = this.myLookup.getTopLevelEditor();
        if (lookupStart < 0 || lookupStart > editor2.getDocument().getTextLength()) {
            LOG.error(lookupStart + "; offset=" + editor2.getCaretModel().getOffset() + "; element=" + this.myLookup.getPsiElement());
        }
        LogicalPosition pos = editor2.offsetToLogicalPosition(lookupStart);
        Point location2 = editor2.logicalPositionToXY(pos);
        location2.y += editor2.getLineHeight();
        location2.x -= this.myLookup.myCellRenderer.getTextIndent();
        Window window = ComponentUtil.getWindow(lookupComponent);
        if (window != null) {
            Point point = SwingUtilities.convertPoint(lookupComponent, 0, 0, window);
            location2.x -= point.x;
        }
        SwingUtilities.convertPointToScreen(location2, editor2.getContentComponent());
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle(editor2.getContentComponent());
        if (!this.isPositionedAboveCaret()) {
            int shiftLow = screenRectangle.y + screenRectangle.height - (location2.y + dim.height);
            this.myPositionedAbove = shiftLow < 0 && shiftLow < location2.y - dim.height && location2.y >= dim.height;
        }
        if (this.isPositionedAboveCaret()) {
            location2.y -= dim.height + editor2.getLineHeight();
        }
        if (!screenRectangle.contains(location2)) {
            location2 = ScreenUtil.findNearestPointOnBorder(screenRectangle, location2);
        }
        Rectangle candidate = new Rectangle(location2, dim);
        ScreenUtil.cropRectangleToFitTheScreen(candidate);
        if (this.isPositionedAboveCaret()) {
            Point caretLocation = editor2.logicalPositionToXY(pos);
            SwingUtilities.convertPointToScreen(caretLocation, editor2.getContentComponent());
            int offset2 = location2.y + dim.height - caretLocation.y;
            if (offset2 > 0) {
                candidate.height -= offset2;
            }
        }
        if ((rootPane = editor2.getComponent().getRootPane()) != null) {
            SwingUtilities.convertPointFromScreen(location2, rootPane.getLayeredPane());
        } else {
            LOG.error("editor.disposed=" + editor2.isDisposed() + "; lookup.disposed=" + this.myLookup.isLookupDisposed() + "; editorShowing=" + editor2.getContentComponent().isShowing());
        }
        this.myMaximumHeight = candidate.height;
        return new Rectangle(location2.x, location2.y, dim.width, candidate.height);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/impl/LookupUi", "<init>"));
    }

    private static final class MenuAction
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        private MenuAction() {
            this.setPopup(true);
        }
    }

    private final class ChangeSortingAction
    extends DumbAwareAction
    implements HintManagerImpl.ActionToIgnore {
        private ChangeSortingAction() {
            super(ActionsBundle.messagePointer((String)"action.ChangeSortingAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            UISettings settings;
            if (e == null) {
                ChangeSortingAction.$$$reportNull$$$0(0);
            }
            settings.setSortLookupElementsLexicographically(!(settings = UISettings.getInstance()).getSortLookupElementsLexicographically());
            LookupUi.this.myLookup.resort(false);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeSortingAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setIcon(UISettings.getInstance().getSortLookupElementsLexicographically() ? PlatformIcons.CHECK_ICON : null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ChangeSortingAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupUi$ChangeSortingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupUi$ChangeSortingAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class DelegatedAction
    extends DumbAwareAction
    implements HintManagerImpl.ActionToIgnore {
        private final AnAction delegateAction;

        private DelegatedAction(AnAction action2) {
            this.delegateAction = action2;
            this.getTemplatePresentation().setText(this.delegateAction.getTemplateText(), true);
            this.copyShortcutFrom(this.delegateAction);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DelegatedAction.$$$reportNull$$$0(0);
            }
            this.delegateAction.actionPerformed(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupUi$DelegatedAction", "actionPerformed"));
        }
    }

    private static class ShowCompletionSettingsAction
    extends AnAction
    implements DumbAware {
        ShowCompletionSettingsAction() {
            super(LangBundle.message("action.code.completion.settings.text", new Object[0]), null, AllIcons.General.Settings);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowCompletionSettingsAction.$$$reportNull$$$0(0);
            }
            ShowSettingsUtil.getInstance().showSettingsDialog(ShowCompletionSettingsAction.getEventProject((AnActionEvent)e), CodeCompletionConfigurable.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupUi$ShowCompletionSettingsAction", "actionPerformed"));
        }
    }

    private final class HintAction
    extends DumbAwareAction {
        private HintAction() {
            super(AllIcons.Actions.IntentionBulb);
            AnAction showIntentionAction = ActionManager.getInstance().getAction("ShowIntentionActions");
            if (showIntentionAction != null) {
                this.copyShortcutFrom(showIntentionAction);
                this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer("action.presentation.LookupUi.text", new Object[0]));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HintAction.$$$reportNull$$$0(0);
            }
            LookupUi.this.myLookup.showElementActions(e.getInputEvent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupUi$HintAction", "actionPerformed"));
        }
    }

    private class LookupBottomLayout
    implements LayoutManager {
        private LookupBottomLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent2) {
            Insets insets = parent2.getInsets();
            Dimension adSize = LookupUi.this.myAdvertiser.getAdComponent().getPreferredSize();
            Dimension hintButtonSize = LookupUi.this.myHintButton.getPreferredSize();
            Dimension menuButtonSize = LookupUi.this.myMenuButton.getPreferredSize();
            return new Dimension(adSize.width + hintButtonSize.width + menuButtonSize.width + insets.left + insets.right, Math.max(adSize.height, menuButtonSize.height) + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent2) {
            Insets insets = parent2.getInsets();
            Dimension adSize = LookupUi.this.myAdvertiser.getAdComponent().getMinimumSize();
            Dimension hintButtonSize = LookupUi.this.myHintButton.getMinimumSize();
            Dimension menuButtonSize = LookupUi.this.myMenuButton.getMinimumSize();
            return new Dimension(adSize.width + hintButtonSize.width + menuButtonSize.width + insets.left + insets.right, Math.max(adSize.height, menuButtonSize.height) + insets.top + insets.bottom);
        }

        @Override
        public void layoutContainer(Container parent2) {
            Insets insets = parent2.getInsets();
            Dimension size = parent2.getSize();
            int innerHeight = size.height - insets.top - insets.bottom;
            Dimension menuButtonSize = LookupUi.this.myMenuButton.getPreferredSize();
            int x = size.width - menuButtonSize.width - insets.right;
            int y = (innerHeight - menuButtonSize.height) / 2;
            LookupUi.this.myMenuButton.setBounds(x, y + insets.top, menuButtonSize.width, menuButtonSize.height);
            Dimension myHintButtonSize = LookupUi.this.myHintButton.getPreferredSize();
            if (LookupUi.this.myHintButton.isVisible() && !LookupUi.this.myProcessIcon.isVisible()) {
                y = (innerHeight - myHintButtonSize.height) / 2;
                LookupUi.this.myHintButton.setBounds(x -= myHintButtonSize.width, y + insets.top, myHintButtonSize.width, myHintButtonSize.height);
            } else if (!LookupUi.this.myHintButton.isVisible() && LookupUi.this.myProcessIcon.isVisible()) {
                Dimension myProcessIconSize = LookupUi.this.myProcessIcon.getPreferredSize();
                y = (innerHeight - myProcessIconSize.height) / 2;
                LookupUi.this.myProcessIcon.setBounds(x -= myProcessIconSize.width, y + insets.top, myProcessIconSize.width, myProcessIconSize.height);
            } else if (!LookupUi.this.myHintButton.isVisible() && !LookupUi.this.myProcessIcon.isVisible()) {
                x -= myHintButtonSize.width;
            } else {
                throw new IllegalStateException("Can't show both process icon and hint button");
            }
            Dimension adSize = LookupUi.this.myAdvertiser.getAdComponent().getPreferredSize();
            y = (innerHeight - adSize.height) / 2;
            LookupUi.this.myAdvertiser.getAdComponent().setBounds(insets.left, y + insets.top, x - insets.left, adSize.height);
        }
    }

    private final class LookupLayeredPane
    extends JBLayeredPane {
        final JPanel mainPanel = new JPanel(new BorderLayout());

        private LookupLayeredPane() {
            this.mainPanel.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
            this.add(this.mainPanel, 0, 0);
            this.setLayout(new AbstractLayoutManager(){

                @Override
                public Dimension preferredLayoutSize(@Nullable Container parent2) {
                    int maxCellWidth = LookupUi.this.myLookup.myCellRenderer.getLookupTextWidth() + LookupUi.this.myLookup.myCellRenderer.getTextIndent();
                    int scrollBarWidth = LookupUi.this.myScrollPane.getVerticalScrollBar().getWidth();
                    int listWidth = Math.min(scrollBarWidth + maxCellWidth, UISettings.getInstance().getMaxLookupWidth());
                    Dimension bottomPanelSize = LookupUi.this.myBottomPanel.getPreferredSize();
                    int panelHeight = LookupUi.this.myScrollPane.getPreferredSize().height + bottomPanelSize.height;
                    int width = Math.max(listWidth, bottomPanelSize.width);
                    width = Math.min(width, Registry.intValue("ide.completion.max.width"));
                    int height = Math.min(panelHeight, LookupUi.this.myMaximumHeight);
                    return new Dimension(width, height);
                }

                @Override
                public void layoutContainer(Container parent2) {
                    Dimension size = LookupLayeredPane.this.getSize();
                    LookupLayeredPane.this.mainPanel.setSize(size);
                    LookupLayeredPane.this.mainPanel.validate();
                    if (IdeEventQueue.getInstance().getTrueCurrentEvent().getID() == 506) {
                        int listHeight;
                        Dimension preferredSize = this.preferredLayoutSize(null);
                        if (preferredSize.width != size.width) {
                            UISettings.getInstance().setMaxLookupWidth(Math.max(500, size.width));
                        }
                        if ((listHeight = LookupUi.this.myList.getLastVisibleIndex() - LookupUi.this.myList.getFirstVisibleIndex() + 1) != LookupUi.this.myList.getModel().getSize() && listHeight != LookupUi.this.myList.getVisibleRowCount() && preferredSize.height != size.height) {
                            UISettings.getInstance().setMaxLookupListHeight(Math.max(5, listHeight));
                        }
                    }
                    LookupUi.this.myList.setFixedCellWidth(LookupUi.this.myScrollPane.getViewport().getWidth());
                }
            });
        }
    }
}

