/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseData;
import com.intellij.codeInsight.navigation.CtrlMouseHandlerKt;
import com.intellij.codeInsight.navigation.CtrlMouseRequest;
import com.intellij.codeInsight.navigation.CtrlMouseResult;
import com.intellij.codeInsight.navigation.CtrlMouseState;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.lang.documentation.ide.impl.DocumentationManager;
import com.intellij.lang.documentation.ide.impl.DocumentationTargetHoverInfoKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorMouseHoverPopupManager;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001:B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\"H\u0007J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001aH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010)\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010)\u001a\u00020-H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u000201H\u0016J\"\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010$\u001a\u00020\u001aH\u0002J\u0010\u00108\u001a\u00020\u00162\u0006\u0010)\u001a\u000209H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lcom/intellij/codeInsight/navigation/CtrlMouseHandler2;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Ljava/awt/event/KeyAdapter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cs", "Lkotlinx/coroutines/CoroutineScope;", "myLastMouseLocation", "Ljava/awt/Point;", "value", "Lcom/intellij/codeInsight/navigation/CtrlMouseState;", "myState", "getMyState", "()Lcom/intellij/codeInsight/navigation/CtrlMouseState;", "setMyState", "(Lcom/intellij/codeInsight/navigation/CtrlMouseState;)V", "cancelAndClear", "", "cancelHandlerJob", "clearState", "compute", "Lcom/intellij/codeInsight/navigation/CtrlMouseResult;", "request", "Lcom/intellij/codeInsight/navigation/CtrlMouseRequest;", "(Lcom/intellij/codeInsight/navigation/CtrlMouseRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeInReadAction", "dispose", "handle", "handlerJob", "Lkotlinx/coroutines/Job;", "highlightAndHint", "result", "ignoreMovement", "", "screenPoint", "keyPressed", "e", "Ljava/awt/event/KeyEvent;", "keyReleased", "mouseMoved", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseReleased", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "showHint", "Lcom/intellij/ui/LightweightHint;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "hostOffset", "", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "HintHyperlinkListener", "intellij.platform.lang.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nCtrlMouseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CtrlMouseHandler.kt\ncom/intellij/codeInsight/navigation/CtrlMouseHandler2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,441:1\n1549#2:442\n1620#2,3:443\n*S KotlinDebug\n*F\n+ 1 CtrlMouseHandler.kt\ncom/intellij/codeInsight/navigation/CtrlMouseHandler2\n*L\n274#1:442\n274#1:443,3\n*E\n"})
public final class CtrlMouseHandler2
extends KeyAdapter
implements EditorMouseMotionListener,
EditorMouseListener,
FileEditorManagerListener,
VisibleAreaListener,
Disposable {
    @NotNull
    private final Project project;
    @Nullable
    private Point myLastMouseLocation;
    @NotNull
    private final CoroutineScope cs;
    @Nullable
    private CtrlMouseState myState;

    public CtrlMouseHandler2(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getInstance().eventMulticaster");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this);
        eventMulticaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this);
        Topic<FileEditorManagerListener> topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, this);
        this.cs = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, 1, null));
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        Editor editor2 = e.getEditor();
        EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editor3 = editorEx;
        if (!Intrinsics.areEqual((Object)editor3.getProject(), (Object)this.project)) {
            return;
        }
        MouseEvent mouseEvent = e.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"e.mouseEvent");
        MouseEvent mouseEvent2 = mouseEvent;
        Point point = mouseEvent2.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"mouseEvent.locationOnScreen");
        if (this.ignoreMovement(point)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.EDITING_AREA) || !e.isOverText()) {
            this.cancelAndClear();
            return;
        }
        CtrlMouseAction action2 = CtrlMouseHandlerKt.access$getCtrlMouseAction(mouseEvent2.getModifiersEx());
        if (action2 == null) {
            this.cancelAndClear();
            return;
        }
        this.cancelHandlerJob();
        this.handle(new CtrlMouseRequest(editor3, e.getOffset(), action2));
    }

    private final boolean ignoreMovement(Point screenPoint) {
        Point previousMouseLocation = this.myLastMouseLocation;
        this.myLastMouseLocation = screenPoint;
        CtrlMouseState ctrlMouseState = this.getMyState();
        if (ctrlMouseState == null || (ctrlMouseState = ctrlMouseState.getHint()) == null) {
            return false;
        }
        CtrlMouseState hint = ctrlMouseState;
        JComponent hintComponent = hint.getComponent();
        if (!hintComponent.isShowing()) {
            return false;
        }
        Rectangle hintBounds = new Rectangle(hintComponent.getLocationOnScreen(), hintComponent.getSize());
        return ScreenUtil.isMovementTowards(previousMouseLocation, screenPoint, hintBounds);
    }

    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.cancelHandlerJob();
        CtrlMouseState ctrlMouseState = this.getMyState();
        if (ctrlMouseState == null) {
            boolean $i$a$-checkNotNull-CtrlMouseHandler2$keyPressed$state$22 = false;
            String $i$a$-checkNotNull-CtrlMouseHandler2$keyPressed$state$22 = "state must be non-null when the key listener is running";
            throw new IllegalStateException($i$a$-checkNotNull-CtrlMouseHandler2$keyPressed$state$22.toString());
        }
        CtrlMouseState state = ctrlMouseState;
        CtrlMouseAction action2 = CtrlMouseHandlerKt.access$getCtrlMouseAction(e.getModifiersEx());
        if (action2 == null) {
            this.clearState();
            return;
        }
        CtrlMouseRequest request2 = state.getRequest();
        if (action2 == request2.getAction()) {
            return;
        }
        this.handle(CtrlMouseRequest.copy$default(request2, null, 0, action2, 3, null));
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.keyPressed(e);
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.cancelAndClear();
    }

    @Override
    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.cancelAndClear();
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.cancelAndClear();
    }

    private final CtrlMouseState getMyState() {
        EDT.assertIsEdt();
        return this.myState;
    }

    private final void setMyState(CtrlMouseState value) {
        EDT.assertIsEdt();
        this.myState = value;
    }

    @TestOnly
    @NotNull
    public final Job handlerJob() {
        return (Job)SequencesKt.single(JobKt.getJob(this.cs.getCoroutineContext()).getChildren());
    }

    @Override
    public void dispose() {
        CoroutineScopeKt.cancel$default(this.cs, "CtrlMouseHandler disposal", null, 2, null);
        this.clearState();
    }

    private final void cancelAndClear() {
        this.cancelHandlerJob();
        this.clearState();
    }

    private final void cancelHandlerJob() {
        JobKt.cancelChildren$default(JobKt.getJob(this.cs.getCoroutineContext()), null, 1, null);
    }

    private final void clearState() {
        CtrlMouseState state = this.getMyState();
        if (state != null) {
            this.setMyState(null);
            Disposer.dispose(state);
        }
    }

    private final void handle(CtrlMouseRequest request2) {
        BuildersKt.launch(this.cs, CoroutinesKt.getEDT(Dispatchers.INSTANCE), CoroutineStart.UNDISPATCHED, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request2, null){
            int label;
            final /* synthetic */ CtrlMouseHandler2 this$0;
            final /* synthetic */ CtrlMouseRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CtrlMouseHandler2.access$compute(this.this$0, this.$request, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((result = (CtrlMouseResult)v0) != null) {
                            CtrlMouseHandler2.access$highlightAndHint(this.this$0, this.$request, result);
                        } else {
                            CtrlMouseHandler2.access$clearState(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Object compute(CtrlMouseRequest request2, Continuation<? super CtrlMouseResult> $completion) {
        return BuildersKt.withContext((CoroutineContext)Dispatchers.getIO(), (Function2)new Function2<CoroutineScope, Continuation<? super CtrlMouseResult>, Object>(this, request2, null){
            int label;
            final /* synthetic */ CtrlMouseHandler2 this$0;
            final /* synthetic */ CtrlMouseRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ReadConstraint[] readConstraintArray = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(CtrlMouseHandler2.access$getProject$p(this.this$0))};
                        this.label = 1;
                        Object object3 = CoroutinesKt.constrainedReadAction(readConstraintArray, (Function0)new Function0<CtrlMouseResult>(this.this$0, this.$request){
                            final /* synthetic */ CtrlMouseHandler2 this$0;
                            final /* synthetic */ CtrlMouseRequest $request;
                            {
                                this.this$0 = $receiver;
                                this.$request = $request;
                                super(0);
                            }

                            @Nullable
                            public final CtrlMouseResult invoke() {
                                return CtrlMouseHandler2.access$computeInReadAction(this.this$0, this.$request);
                            }
                        }, (Continuation)this);
                        Object object4 = object3;
                        if (object3 != object2) return (CtrlMouseResult)object4;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return (CtrlMouseResult)object4;
                        }
                        catch (IndexNotReadyException indexNotReadyException) {
                            DumbService.getInstance(CtrlMouseHandler2.access$getProject$p(this.this$0)).showDumbModeNotification(CodeInsightBundle.message("notification.element.information.is.not.available.during.index.update", new Object[0]));
                            return null;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CtrlMouseResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final CtrlMouseResult computeInReadAction(CtrlMouseRequest request2) {
        return (CtrlMouseResult)DocumentationTargetHoverInfoKt.injectedThenHost(this.project, (Editor)request2.getEditor(), request2.getOffset(), (Function3)new Function3<Editor, PsiFile, Integer, CtrlMouseResult>(request2, this){
            final /* synthetic */ CtrlMouseRequest $request;
            final /* synthetic */ CtrlMouseHandler2 this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CtrlMouseResult invoke(@NotNull Editor editor2, @NotNull PsiFile file2, int offset2) {
                CtrlMouseResult ctrlMouseResult;
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                CtrlMouseData ctrlMouseData = this.$request.getAction().getCtrlMouseData(editor2, file2, offset2);
                if (ctrlMouseData == null) {
                    return null;
                }
                CtrlMouseData data2 = ctrlMouseData;
                DocumentationTarget documentationTarget = data2.getTarget();
                DocumentationTarget documentationTarget2 = data2.getTarget();
                CtrlMouseResult result2 = new CtrlMouseResult(data2.isNavigatable(), data2.getRanges(), data2.getHintText(), documentationTarget != null ? documentationTarget.createPointer() : null, documentationTarget2 != null ? documentationTarget2.getClass() : null);
                if (editor2 instanceof EditorWindow) {
                    void $this$mapTo$iv$iv;
                    InjectedLanguageManager manager = InjectedLanguageManager.getInstance(CtrlMouseHandler2.access$getProject$p(this.this$0));
                    Iterable $this$map$iv = result2.getRanges();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        TextRange textRange = (TextRange)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(manager.injectedToHost((PsiElement)((EditorWindow)editor2).getInjectedFile(), (TextRange)it));
                    }
                    List hostRanges = (List)destination$iv$iv;
                    ctrlMouseResult = CtrlMouseResult.copy$default(result2, false, hostRanges, null, null, null, 29, null);
                } else {
                    ctrlMouseResult = result2;
                }
                return ctrlMouseResult;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightAndHint(CtrlMouseRequest request2, CtrlMouseResult result2) {
        void it;
        CtrlMouseState ctrlMouseState;
        Object object;
        void $this$mapTo$iv$iv;
        CtrlMouseState state = this.getMyState();
        if (state != null) {
            if (state.getRequest().getAction() == request2.getAction() && Intrinsics.areEqual(state.getRanges(), result2.getRanges())) {
                return;
            }
            this.clearState();
        }
        if (!result2.isNavigatable() && result2.getHintText() == null) {
            return;
        }
        EditorEx editor2 = request2.component1();
        int offset2 = request2.component2();
        DocumentEx documentEx = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        if (!CtrlMouseHandlerKt.access$checkRanges(result2, documentEx)) {
            return;
        }
        LightweightHint hint = this.showHint(editor2, offset2, result2);
        editor2.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        editor2.getContentComponent().addKeyListener(this);
        if (result2.isNavigatable()) {
            editor2.setCustomCursor(CtrlMouseHandler2.class, Cursor.getPredefinedCursor(12));
        }
        TextAttributes attributes = CtrlMouseHandlerKt.access$textAttributes(result2.isNavigatable());
        Iterable $this$map$iv = result2.getRanges();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void range;
            TextRange textRange = (TextRange)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(editor2.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5900, NavigationUtil.patchAttributesColor(attributes, (TextRange)range, (Editor)editor2), HighlighterTargetArea.EXACT_RANGE));
        }
        List highlighters = (List)destination$iv$iv;
        CtrlMouseState $i$f$map22 = ctrlMouseState = new CtrlMouseState(request2, result2.getRanges(), hint);
        object = this;
        boolean bl = false;
        Disposer.register((Disposable)it, () -> CtrlMouseHandler2.highlightAndHint$lambda$3$lambda$2(highlighters, editor2, this));
        super.setMyState(ctrlMouseState);
    }

    private final LightweightHint showHint(EditorEx editor2, int hostOffset, CtrlMouseResult result2) {
        HintHyperlinkListener hintHyperlinkListener;
        Object it;
        boolean skipHint;
        boolean bl = skipHint = EditorMouseHoverPopupManager.getInstance().isHintShown() || DocumentationManager.Companion.instance(this.project).isPopupVisible() || ApplicationManager.getApplication().isUnitTestMode();
        if (skipHint) {
            return null;
        }
        String string2 = result2.getHintText();
        if (string2 == null) {
            return null;
        }
        String text2 = string2;
        UIEventLogger.CtrlMouseHintShown.log(this.project, result2.getTargetClass());
        Pointer<? extends DocumentationTarget> pointer = result2.getTargetPointer();
        if (pointer != null) {
            it = pointer;
            boolean bl2 = false;
            hintHyperlinkListener = new HintHyperlinkListener((Editor)editor2, (Pointer<? extends DocumentationTarget>)it);
        } else {
            hintHyperlinkListener = null;
        }
        HintHyperlinkListener hyperlinkListener = hintHyperlinkListener;
        JComponent jComponent = HintUtil.createInformationLabel((String)text2, (HyperlinkListener)hyperlinkListener, null, null);
        it = jComponent;
        boolean bl3 = false;
        ((JComponent)it).setBorder(JBUI.Borders.empty(6, 6, 5, 6));
        JComponent component2 = jComponent;
        Editor editor3 = (Editor)editor2;
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
        return CtrlMouseHandlerKt.access$showHint(editor3, hostOffset, component2);
    }

    private static final void highlightAndHint$lambda$3$lambda$2(List $highlighters, EditorEx $editor, CtrlMouseHandler2 this$0) {
        Intrinsics.checkNotNullParameter((Object)$highlighters, (String)"$highlighters");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        for (RangeHighlighter highlighter : $highlighters) {
            highlighter.dispose();
        }
        $editor.setCustomCursor(CtrlMouseHandler2.class, null);
        $editor.getContentComponent().removeKeyListener(this$0);
        $editor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this$0);
    }

    public static final /* synthetic */ Object access$compute(CtrlMouseHandler2 $this, CtrlMouseRequest request2, Continuation $completion) {
        return $this.compute(request2, (Continuation<? super CtrlMouseResult>)$completion);
    }

    public static final /* synthetic */ void access$highlightAndHint(CtrlMouseHandler2 $this, CtrlMouseRequest request2, CtrlMouseResult result2) {
        $this.highlightAndHint(request2, result2);
    }

    public static final /* synthetic */ void access$clearState(CtrlMouseHandler2 $this) {
        $this.clearState();
    }

    public static final /* synthetic */ Project access$getProject$p(CtrlMouseHandler2 $this) {
        return $this.project;
    }

    public static final /* synthetic */ CtrlMouseResult access$computeInReadAction(CtrlMouseHandler2 $this, CtrlMouseRequest request2) {
        return $this.computeInReadAction(request2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/navigation/CtrlMouseHandler2$HintHyperlinkListener;", "Ljavax/swing/event/HyperlinkListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "targetPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "(Lcom/intellij/codeInsight/navigation/CtrlMouseHandler2;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/model/Pointer;)V", "hyperlinkUpdate", "", "e", "Ljavax/swing/event/HyperlinkEvent;", "intellij.platform.lang.impl"})
    private final class HintHyperlinkListener
    implements HyperlinkListener {
        @NotNull
        private final Editor editor;
        @NotNull
        private final Pointer<? extends DocumentationTarget> targetPointer;

        public HintHyperlinkListener(@NotNull Editor editor2, Pointer<? extends DocumentationTarget> targetPointer) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(targetPointer, (String)"targetPointer");
            this.editor = editor2;
            this.targetPointer = targetPointer;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                return;
            }
            String description = e.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)description, (String)"description");
            if (!StringsKt.startsWith$default((String)description, (String)"psi_element://", (boolean)false, (int)2, null)) {
                return;
            }
            CoroutineScope coroutineScope = CtrlMouseHandler2.this.cs;
            CoroutineContext coroutineContext = CoroutinesKt.getEDT(Dispatchers.INSTANCE);
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current()");
            BuildersKt.launch(coroutineScope, coroutineContext.plus(ModalityKt.asContextElement(modalityState)), CoroutineStart.UNDISPATCHED, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(CtrlMouseHandler2.this, this, description, e, null){
                int label;
                final /* synthetic */ CtrlMouseHandler2 this$0;
                final /* synthetic */ HintHyperlinkListener this$1;
                final /* synthetic */ String $description;
                final /* synthetic */ HyperlinkEvent $e;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$description = $description;
                    this.$e = $e;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = DocumentationManager.Companion.instance(CtrlMouseHandler2.access$getProject$p(this.this$0));
                            v1 = (Function0)new Function0<DocumentationTarget>((Object)HintHyperlinkListener.access$getTargetPointer$p(this.this$1)){

                                @Nullable
                                public final DocumentationTarget invoke() {
                                    return (DocumentationTarget)((Pointer)this.receiver).dereference();
                                }
                            };
                            v2 = this.$description;
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"description");
                            this.label = 1;
                            v3 = v0.activateInlineLinkS((Function0<? extends DocumentationTarget>)v1, v2, HintHyperlinkListener.access$getEditor$p(this.this$1), CtrlMouseHandlerKt.access$editorPoint(this.$e, HintHyperlinkListener.access$getEditor$p(this.this$1)), (Continuation<? super Boolean>)((Continuation)this));
                            if (v3 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl17:
                            // 2 sources

                            if (ok = ((Boolean)v3).booleanValue()) {
                                CtrlMouseHandler2.access$clearState(this.this$0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public static final /* synthetic */ Pointer access$getTargetPointer$p(HintHyperlinkListener $this) {
            return $this.targetPointer;
        }

        public static final /* synthetic */ Editor access$getEditor$p(HintHyperlinkListener $this) {
            return $this.editor;
        }
    }
}

