/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.util.TextRange;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocPreviewUtil {
    private static final IntSet ALLOWED_LINK_SEPARATORS = new IntOpenHashSet();
    private static final Comparator<String> REPLACEMENTS_COMPARATOR;

    private DocPreviewUtil() {
    }

    @NotNull
    @Nls
    public static String buildPreview(@NotNull @Nls String header, @Nullable String qName, @Nullable @Nls String fullText) {
        if (header == null) {
            DocPreviewUtil.$$$reportNull$$$0(0);
        }
        if (fullText == null) {
            String string2 = header;
            if (string2 == null) {
                DocPreviewUtil.$$$reportNull$$$0(1);
            }
            return string2;
        }
        HashMap<String, String> links = new HashMap<String, String>();
        DocPreviewUtil.process(fullText, new LinksCollector(links));
        HashMap<String, String> toAdd = new HashMap<String, String>();
        for (Map.Entry entry : links.entrySet()) {
            String longName;
            String shortName = DocPreviewUtil.parseShortName((String)entry.getKey());
            if (shortName != null) {
                toAdd.put(shortName, (String)entry.getValue());
            }
            if ((longName = DocPreviewUtil.parseLongName((String)entry.getKey(), (String)entry.getValue())) == null) continue;
            toAdd.put(longName, (String)entry.getValue());
        }
        links.putAll(toAdd);
        if (qName != null) {
            links.put(qName, "psi_element://" + qName);
        }
        ArrayList<TextRange> modifiedRanges = new ArrayList<TextRange>();
        ArrayList sortedReplacements = new ArrayList(links.keySet());
        sortedReplacements.sort(REPLACEMENTS_COMPARATOR);
        @Nls StringBuilder buffer = new StringBuilder(header);
        DocPreviewUtil.replace(buffer, "\n", "<br/>", modifiedRanges);
        for (String replaceFrom : sortedReplacements) {
            DocPreviewUtil.replace(buffer, replaceFrom, String.format("<a href=\"%s\">%s</a>", links.get(replaceFrom), replaceFrom), modifiedRanges);
        }
        String string3 = buffer.toString();
        if (string3 == null) {
            DocPreviewUtil.$$$reportNull$$$0(2);
        }
        return string3;
    }

    @Nullable
    private static String parseShortName(@NotNull String name) {
        int i2;
        if (name == null) {
            DocPreviewUtil.$$$reportNull$$$0(3);
        }
        return (i2 = name.lastIndexOf(46)) > 0 && i2 < name.length() - 1 ? name.substring(i2 + 1) : null;
    }

    @Nullable
    private static String parseLongName(@NotNull String shortName, @NotNull String address) {
        String pureAddress;
        int i2;
        if (shortName == null) {
            DocPreviewUtil.$$$reportNull$$$0(4);
        }
        if (address == null) {
            DocPreviewUtil.$$$reportNull$$$0(5);
        }
        if ((i2 = (pureAddress = address).lastIndexOf("//")) > 0 && i2 < pureAddress.length() - 2) {
            pureAddress = pureAddress.substring(i2 + 2);
        }
        return pureAddress.equals(shortName) || !pureAddress.endsWith(shortName) ? null : pureAddress;
    }

    private static void replace(@NotNull StringBuilder text2, @NotNull String replaceFrom, @NotNull String replaceTo, @NotNull List<TextRange> readOnlyChanges) {
        if (text2 == null) {
            DocPreviewUtil.$$$reportNull$$$0(6);
        }
        if (replaceFrom == null) {
            DocPreviewUtil.$$$reportNull$$$0(7);
        }
        if (replaceTo == null) {
            DocPreviewUtil.$$$reportNull$$$0(8);
        }
        if (readOnlyChanges == null) {
            DocPreviewUtil.$$$reportNull$$$0(9);
        }
        if (replaceFrom.isEmpty()) {
            return;
        }
        int i2 = text2.indexOf(replaceFrom);
        while (i2 >= 0) {
            int end = i2 + replaceFrom.length();
            if (!DocPreviewUtil.intersects(readOnlyChanges, i2, end) && ("\n".equals(replaceFrom) || (end >= text2.length() || ALLOWED_LINK_SEPARATORS.contains(text2.charAt(end))) && (i2 <= 0 || ALLOWED_LINK_SEPARATORS.contains(text2.charAt(i2 - 1))))) {
                text2.replace(i2, end, replaceTo);
                int diff = replaceTo.length() - replaceFrom.length();
                for (int j = 0; j < readOnlyChanges.size(); ++j) {
                    TextRange range = readOnlyChanges.get(j);
                    if (range.getStartOffset() < end) continue;
                    readOnlyChanges.set(j, range.shiftRight(diff));
                }
                readOnlyChanges.add(new TextRange(i2, i2 + replaceTo.length()));
            }
            i2 = text2.indexOf(replaceFrom, i2 + 1);
        }
    }

    private static boolean intersects(@NotNull List<? extends TextRange> ranges2, int start, int end) {
        if (ranges2 == null) {
            DocPreviewUtil.$$$reportNull$$$0(10);
        }
        for (TextRange textRange : ranges2) {
            if (!textRange.intersectsStrict(start, end)) continue;
            return true;
        }
        return false;
    }

    private static int process(@NotNull String text2, @NotNull Callback callback) {
        int i2;
        if (text2 == null) {
            DocPreviewUtil.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            DocPreviewUtil.$$$reportNull$$$0(12);
        }
        State state = State.TEXT;
        int dataStartOffset = 0;
        int tagNameStartOffset = 0;
        String tagName = null;
        block5: for (i2 = 0; i2 < text2.length(); ++i2) {
            char c2 = text2.charAt(i2);
            switch (state) {
                case TEXT: {
                    if (c2 != '<') continue block5;
                    if (i2 > dataStartOffset && !callback.onText(text2.substring(dataStartOffset, i2).replace("&nbsp;", " "))) {
                        return dataStartOffset;
                    }
                    dataStartOffset = i2;
                    if (i2 < text2.length() - 1 && text2.charAt(i2 + 1) == '/') {
                        state = State.INSIDE_CLOSE_TAG;
                        tagNameStartOffset = ++i2 + 1;
                        continue block5;
                    }
                    state = State.INSIDE_OPEN_TAG;
                    tagNameStartOffset = i2 + 1;
                    continue block5;
                }
                case INSIDE_OPEN_TAG: {
                    if (c2 == ' ') {
                        tagName = text2.substring(tagNameStartOffset, i2);
                        continue block5;
                    }
                    if (c2 == '/') {
                        if (i2 >= text2.length() - 1 || text2.charAt(i2 + 1) != '>') continue block5;
                        if (tagName == null) {
                            tagName = text2.substring(tagNameStartOffset, i2);
                        }
                        if (!callback.onStandaloneTag(tagName, text2.substring(dataStartOffset, i2 + 2))) {
                            return dataStartOffset;
                        }
                        tagName = null;
                        state = State.TEXT;
                        dataStartOffset = ++i2 + 1;
                        continue block5;
                    }
                    if (c2 != '>') continue block5;
                    if (tagName == null) {
                        tagName = text2.substring(tagNameStartOffset, i2);
                    }
                    if (!callback.onOpenTag(tagName, text2.substring(dataStartOffset, i2 + 1))) {
                        return dataStartOffset;
                    }
                    tagName = null;
                    state = State.TEXT;
                    dataStartOffset = i2 + 1;
                    continue block5;
                }
                case INSIDE_CLOSE_TAG: {
                    if (c2 != '>') continue block5;
                    tagName = text2.substring(tagNameStartOffset, i2);
                    if (!callback.onCloseTag(tagName, text2.substring(dataStartOffset, i2 + 1))) {
                        return dataStartOffset;
                    }
                    tagName = null;
                    state = State.TEXT;
                    dataStartOffset = i2 + 1;
                }
            }
        }
        if (dataStartOffset < text2.length()) {
            callback.onText(text2.substring(dataStartOffset).replace("&nbsp;", " "));
        }
        return i2;
    }

    static {
        ALLOWED_LINK_SEPARATORS.add(44);
        ALLOWED_LINK_SEPARATORS.add(32);
        ALLOWED_LINK_SEPARATORS.add(46);
        ALLOWED_LINK_SEPARATORS.add(59);
        ALLOWED_LINK_SEPARATORS.add(38);
        ALLOWED_LINK_SEPARATORS.add(9);
        ALLOWED_LINK_SEPARATORS.add(10);
        ALLOWED_LINK_SEPARATORS.add(91);
        ALLOWED_LINK_SEPARATORS.add(93);
        ALLOWED_LINK_SEPARATORS.add(40);
        ALLOWED_LINK_SEPARATORS.add(41);
        ALLOWED_LINK_SEPARATORS.add(60);
        ALLOWED_LINK_SEPARATORS.add(62);
        REPLACEMENTS_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                String shortName2;
                String shortName1;
                if (o1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (o2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(shortName1 = this.extractShortName(o1)).equals(shortName2 = this.extractShortName(o2))) {
                    return shortName1.compareTo(shortName2);
                }
                if (o1.endsWith(o2)) {
                    return -1;
                }
                if (o2.endsWith(o1)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }

            private String extractShortName(@NotNull String s) {
                int i2;
                if (s == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (i2 = s.lastIndexOf(46)) > 0 && i2 < s.length() - 1 ? s.substring(i2 + 1) : s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/navigation/DocPreviewUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compare";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extractShortName";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/DocPreviewUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceFrom";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceTo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readOnlyChanges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/DocPreviewUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildPreview";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseShortName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseLongName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }

    private static class LinksCollector
    implements Callback {
        private static final Pattern HREF_PATTERN = Pattern.compile("href=[\"']([^\"']+)");
        @NotNull
        private final Map<String, String> myLinks;
        private String myHref;

        LinksCollector(@NotNull Map<String, String> links) {
            if (links == null) {
                LinksCollector.$$$reportNull$$$0(0);
            }
            this.myLinks = links;
        }

        @Override
        public boolean onOpenTag(@NotNull String name, @NotNull String text2) {
            if (name == null) {
                LinksCollector.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                LinksCollector.$$$reportNull$$$0(2);
            }
            if (!"a".equals(name)) {
                return true;
            }
            Matcher matcher = HREF_PATTERN.matcher(text2);
            if (matcher.find()) {
                this.myHref = matcher.group(1);
            }
            return true;
        }

        @Override
        public boolean onCloseTag(@NotNull String name, @NotNull String text2) {
            if (name == null) {
                LinksCollector.$$$reportNull$$$0(3);
            }
            if (text2 == null) {
                LinksCollector.$$$reportNull$$$0(4);
            }
            if ("a".equals(name)) {
                this.myHref = null;
            }
            return true;
        }

        @Override
        public boolean onStandaloneTag(@NotNull String name, @NotNull String text2) {
            if (name == null) {
                LinksCollector.$$$reportNull$$$0(5);
            }
            if (text2 == null) {
                LinksCollector.$$$reportNull$$$0(6);
            }
            return true;
        }

        @Override
        public boolean onText(@NotNull String text2) {
            if (text2 == null) {
                LinksCollector.$$$reportNull$$$0(7);
            }
            if (this.myHref != null) {
                this.myLinks.put(text2, this.myHref);
                this.myHref = null;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "links";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/DocPreviewUtil$LinksCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onOpenTag";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCloseTag";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStandaloneTag";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Callback {
        public boolean onOpenTag(@NotNull String var1, @NotNull String var2);

        public boolean onCloseTag(@NotNull String var1, @NotNull String var2);

        public boolean onStandaloneTag(@NotNull String var1, @NotNull String var2);

        public boolean onText(@NotNull String var1);
    }

    private static enum State {
        TEXT,
        INSIDE_OPEN_TAG,
        INSIDE_CLOSE_TAG;

    }
}

