/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTaskBase;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.ItemWithPresentation;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.model.Pointer;
import com.intellij.model.psi.impl.UtilKt;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return null;
    }

    @Override
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor2, PsiFile file2) {
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(0);
        }
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor2, ImplementationSearcher.getFlags(), offset2);
        if (source == null && (offset2 = GotoImplementationHandler.tryGetNavigationSourceOffsetFromGutterIcon(editor2, "GotoImplementation")) >= 0) {
            source = TargetElementUtil.getInstance().findTargetElement(editor2, ImplementationSearcher.getFlags(), offset2);
        }
        if (source == null) {
            return null;
        }
        return this.createDataForSource(editor2, offset2, source);
    }

    @NotNull
    protected GotoTargetHandler.GotoData createDataForSource(@NotNull Editor editor2, int offset2, PsiElement source) {
        PsiElement[] targets2;
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(1);
        }
        if ((targets2 = this.findTargets(editor2, offset2, source)) == null) {
            GotoTargetHandler.GotoData data2 = new GotoTargetHandler.GotoData(source, PsiElement.EMPTY_ARRAY, Collections.emptyList());
            data2.isCanceled = true;
            GotoTargetHandler.GotoData gotoData = data2;
            if (gotoData == null) {
                GotoImplementationHandler.$$$reportNull$$$0(2);
            }
            return gotoData;
        }
        PsiReference reference2 = TargetElementUtil.findReference(editor2, offset2);
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets2, Collections.emptyList());
        gotoData.listUpdaterTask = new ImplementationsUpdaterTask(gotoData, editor2, offset2, reference2){

            @Override
            public void onSuccess() {
                super.onSuccess();
                @Nullable ItemWithPresentation oneElement = (ItemWithPresentation)this.getTheOnlyOneElement();
                if (oneElement != null && oneElement.getItem() instanceof SmartPsiElementPointer && GotoImplementationHandler.this.navigateToElement((PsiElement)((SmartPsiElementPointer)oneElement.getItem()).getElement())) {
                    this.myPopup.cancel();
                }
            }
        };
        GotoTargetHandler.GotoData gotoData2 = gotoData;
        if (gotoData2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(3);
        }
        return gotoData2;
    }

    protected PsiElement @Nullable [] findTargets(@NotNull Editor editor2, int offset2, @NotNull PsiElement source) {
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(4);
        }
        if (source == null) {
            GotoImplementationHandler.$$$reportNull$$$0(5);
        }
        final PsiReference reference2 = TargetElementUtil.findReference(editor2, offset2);
        final TargetElementUtil instance2 = TargetElementUtil.getInstance();
        return new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected boolean accept(PsiElement element) {
                if (reference2 != null && !reference2.getElement().isValid()) {
                    return false;
                }
                return instance2.acceptImplementationForReference(reference2, element);
            }

            @Override
            protected boolean canShowPopupWithOneItem(PsiElement element) {
                return false;
            }
        }.searchImplementations(editor2, source, offset2);
    }

    public static int tryGetNavigationSourceOffsetFromGutterIcon(@NotNull Editor editor2, String actionId) {
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(6);
        }
        int line = editor2.getCaretModel().getVisualPosition().line;
        List renderers = ((EditorGutterComponentEx)editor2.getGutter()).getGutterRenderers(line);
        ArrayList elementCandidates = new ArrayList();
        for (GutterMark renderer : renderers) {
            if (!(renderer instanceof LineMarkerInfo.LineMarkerGutterIconRenderer)) continue;
            LineMarkerInfo.LineMarkerGutterIconRenderer lineMarkerRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)renderer;
            AnAction clickAction = ((LineMarkerInfo.LineMarkerGutterIconRenderer)renderer).getClickAction();
            if (!(clickAction instanceof NavigateAction) || !actionId.equals(((NavigateAction)clickAction).getOriginalActionId())) continue;
            elementCandidates.add(lineMarkerRenderer.getLineMarkerInfo().getElement());
        }
        if (elementCandidates.size() == 1) {
            return ((PsiElement)elementCandidates.iterator().next()).getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    protected void chooseFromAmbiguousSources(Editor editor2, PsiFile file2, Consumer<? super GotoTargetHandler.GotoData> successCallback) {
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElementProcessor<PsiElement> navigateProcessor = element -> {
            GotoTargetHandler.GotoData data2 = this.createDataForSource(editor2, offset2, element);
            successCallback.accept(data2);
            return true;
        };
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return;
        }
        GotoDeclarationAction.chooseAmbiguousTarget(project2, editor2, offset2, navigateProcessor, CodeInsightBundle.message("declaration.navigation.title", new Object[0]), null);
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider2 : ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider2.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, @Nullable String name, int length, boolean finished) {
        Object fullName;
        ItemPresentation presentation2;
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(7);
        }
        if ((presentation2 = ((NavigationItem)((Object)sourceElement)).getPresentation()) == null) {
            fullName = name;
        } else {
            PsiElement container = GotoImplementationHandler.getContainer(sourceElement);
            ItemPresentation containerPresentation = container == null || container instanceof PsiFile ? null : ((NavigationItem)((Object)container)).getPresentation();
            String containerText = containerPresentation == null ? null : containerPresentation.getPresentableText();
            fullName = (String)(containerText == null ? "" : containerText + ".") + presentation2.getPresentableText();
        }
        String string2 = CodeInsightBundle.message("goto.implementation.chooserTitle", fullName == null ? "unnamed element" : StringUtil.escapeXmlEntities((String)fullName), length, finished ? "" : " so far");
        if (string2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(9);
        }
        String string2 = CodeInsightBundle.message("goto.implementation.findUsages.title", StringUtil.escapeXmlEntities(name), length);
        if (string2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(13);
        }
        String string2 = CodeInsightBundle.message("goto.implementation.notFound", new Object[0]);
        if (string2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(14);
        }
        return string2;
    }

    public void navigateToImplementations(@NotNull PsiElement baseElement, @NotNull MouseEvent e, @NlsContexts.PopupContent String dumbModeMessage) {
        Project project2;
        if (baseElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(15);
        }
        if (e == null) {
            GotoImplementationHandler.$$$reportNull$$$0(16);
        }
        if (DumbService.isDumb(project2 = baseElement.getProject())) {
            DumbService.getInstance(project2).showDumbModeNotification(dumbModeMessage);
            return;
        }
        PsiUtilCore.ensureValid(baseElement);
        PsiFile containingFile = baseElement.getContainingFile();
        if (PsiDocumentManager.getInstance(project2).getDocument(containingFile) == null) {
            containingFile = containingFile.getOriginalFile();
        }
        Editor editor2 = UtilKt.mockEditor(containingFile);
        GotoTargetHandler.GotoData source = this.createDataForSource(Objects.requireNonNull(editor2, "No document for " + containingFile), baseElement.getTextOffset(), baseElement);
        this.show(project2, editor2, containingFile, source, popup2 -> popup2.show(new RelativePoint(e)));
    }

    @TestOnly
    public GotoTargetHandler.GotoData createDataForSourceForTests(Editor editor2, PsiElement element) {
        return this.createDataForSource(editor2, element.getTextOffset(), element);
    }

    @Nullable
    private static Comparator<ItemWithPresentation> createImplementationComparator(@NotNull GotoTargetHandler.GotoData gotoData) {
        if (gotoData == null) {
            GotoImplementationHandler.$$$reportNull$$$0(17);
        }
        Comparator<ItemWithPresentation> projectContentComparator = GotoImplementationHandler.wrapPsiComparator(GotoImplementationHandler.projectElementsFirst(gotoData.source.getProject()));
        Comparator<ItemWithPresentation> presentationComparator = Comparator.comparing(element -> gotoData.getComparingObject((ItemWithPresentation)element));
        Comparator<ItemWithPresentation> positionComparator = GotoImplementationHandler.wrapPsiComparator(PsiUtilCore::compareElementsByPosition);
        return projectContentComparator.thenComparing(presentationComparator).thenComparing(positionComparator);
    }

    @NotNull
    private static Comparator<ItemWithPresentation> wrapPsiComparator(Comparator<PsiElement> result2) {
        Comparator comparator;
        Comparator comparator2 = comparator = (o1, o2) -> {
            if (o1.getItem() instanceof SmartPsiElementPointer && o2.getItem() instanceof SmartPsiElementPointer) {
                return ReadAction.compute(() -> result2.compare((PsiElement)((SmartPsiElementPointer)o1.getItem()).getElement(), (PsiElement)((SmartPsiElementPointer)o2.getItem()).getElement()));
            }
            return 0;
        };
        if (comparator2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(18);
        }
        return comparator2;
    }

    @NotNull
    public static Comparator<PsiElement> projectElementsFirst(@NotNull Project project2) {
        if (project2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(19);
        }
        FileIndexFacade index2 = FileIndexFacade.getInstance(project2);
        Comparator<PsiElement> comparator = Comparator.comparing(element -> {
            PsiFile containingFile = element.getContainingFile();
            return containingFile != null && index2.isInContent(containingFile.getVirtualFile());
        }).reversed();
        if (comparator == null) {
            GotoImplementationHandler.$$$reportNull$$$0(20);
        }
        return comparator;
    }

    @NotNull
    public static <T> Comparator<T> wrapIntoReadAction(@NotNull Comparator<? super T> base) {
        if (base == null) {
            GotoImplementationHandler.$$$reportNull$$$0(21);
        }
        Comparator comparator = (e1, e2) -> ReadAction.compute(() -> base.compare(e1, e2));
        if (comparator == null) {
            GotoImplementationHandler.$$$reportNull$$$0(22);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 10, 14, 18, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoData";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataForSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapPsiComparator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "projectElementsFirst";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapIntoReadAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceAndTargetElements";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDataForSource";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTargets";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryGetNavigationSourceOffsetFromGutterIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoundMessage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "navigateToImplementations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createImplementationComparator";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "projectElementsFirst";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "wrapIntoReadAction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 8, 10, 14, 18, 20, 22 -> new IllegalStateException(string2);
        };
    }

    private class ImplementationsUpdaterTask
    extends BackgroundUpdaterTaskBase<ItemWithPresentation> {
        private final Editor myEditor;
        private final int myOffset;
        private final GotoTargetHandler.GotoData myGotoData;
        private final PsiReference myReference;

        ImplementationsUpdaterTask(@NotNull GotoTargetHandler.GotoData gotoData, Editor editor2, int offset2, PsiReference reference2) {
            if (gotoData == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(1);
            }
            super(gotoData.source.getProject(), ImplementationSearcher.getSearchingForImplementations(), GotoImplementationHandler.createImplementationComparator(gotoData));
            this.myEditor = editor2;
            this.myOffset = offset2;
            this.myGotoData = gotoData;
            this.myReference = reference2;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(2);
            }
            super.run(indicator);
            for (ItemWithPresentation item : this.myGotoData.getItems()) {
                if (this.updateComponent(item)) continue;
                return;
            }
            new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected void processElement(PsiElement element) {
                    indicator.checkCanceled();
                    if (!TargetElementUtil.getInstance().acceptImplementationForReference(ImplementationsUpdaterTask.this.myReference, element)) {
                        return;
                    }
                    ItemWithPresentation item = ImplementationsUpdaterTask.this.myGotoData.addTarget(element);
                    if (item != null && !ImplementationsUpdaterTask.this.updateComponent(item)) {
                        indicator.cancel();
                    }
                }
            }.searchImplementations(this.myEditor, this.myGotoData.source, this.myOffset);
        }

        @Override
        public String getCaption(int size) {
            String name = ElementDescriptionUtil.getElementDescription(this.myGotoData.source, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
            return GotoImplementationHandler.this.getChooserTitle(this.myGotoData.source, name, size, this.isFinished());
        }

        @Override
        @Nullable
        protected Usage createUsage(@NotNull ItemWithPresentation element) {
            if (element == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(3);
            }
            if (element.getItem() instanceof Pointer) {
                PsiElement psiElement = (PsiElement)((Pointer)element.getItem()).dereference();
                return psiElement == null ? null : new UsageInfo2UsageAdapter(new UsageInfo(psiElement));
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gotoData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler$ImplementationsUpdaterTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createUsage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

