/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTaskBase;
import com.intellij.codeInsight.navigation.GotoTargetPresentationProvider;
import com.intellij.codeInsight.navigation.GotoTargetRenderer;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.codeInsight.navigation.ItemWithPresentation;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.model.Pointer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.util.RoundedCellRenderer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class GotoTargetHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GotoTargetHandler.class);
    private static final PsiElementListCellRenderer<?> ourDefaultTargetElementRenderer = new DefaultPsiElementListCellRenderer();

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        String featureId;
        if (project2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(2);
        }
        if ((featureId = this.getFeatureUsedKey()) != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        try {
            GotoData gotoData = this.getSourceAndTargetElements(editor2, file2);
            Consumer<JBPopup> showPopupProcedure = popup2 -> popup2.showInBestPositionFor(editor2);
            if (gotoData != null) {
                this.show(project2, editor2, file2, gotoData, showPopupProcedure);
            } else {
                this.chooseFromAmbiguousSources(editor2, file2, data2 -> this.show(project2, editor2, file2, (GotoData)data2, (Consumer<? super JBPopup>)showPopupProcedure));
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance(project2).showDumbModeNotification(CodeInsightBundle.message("message.navigation.is.not.available.here.during.index.update", new Object[0]));
        }
    }

    protected void chooseFromAmbiguousSources(Editor editor2, PsiFile file2, Consumer<? super GotoData> successCallback) {
    }

    @NonNls
    @Nullable
    protected abstract String getFeatureUsedKey();

    protected boolean useEditorFont() {
        return true;
    }

    @Nullable
    protected abstract GotoData getSourceAndTargetElements(Editor var1, PsiFile var2);

    protected void show(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull GotoData gotoData, @NotNull Consumer<? super JBPopup> showPopup2) {
        JScrollPane pane;
        boolean finished;
        if (project2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(5);
        }
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(6);
        }
        if (showPopup2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(7);
        }
        if (gotoData.isCanceled) {
            return;
        }
        PsiElement[] targets2 = gotoData.targets;
        List<AdditionalAction> additionalActions = gotoData.additionalActions;
        if (targets2.length == 0 && additionalActions.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor2, this.getNotFoundMessage(project2, editor2, file2));
            return;
        }
        boolean bl = finished = gotoData.listUpdaterTask == null || gotoData.listUpdaterTask.isFinished();
        if (targets2.length == 1 && additionalActions.isEmpty() && finished) {
            this.navigateToElement(targets2[0]);
            return;
        }
        String name = ((NavigationItem)((Object)gotoData.source)).getName();
        String title = this.getChooserTitle(gotoData.source, name, targets2.length, finished);
        gotoData.initPresentations();
        ArrayList<ItemWithPresentation> allElements = new ArrayList<ItemWithPresentation>(targets2.length + additionalActions.size());
        allElements.addAll(gotoData.getItems());
        if (this.shouldSortTargets()) {
            allElements.sort(this.createComparator(gotoData));
        }
        allElements.addAll(ContainerUtil.map(additionalActions, action2 -> new ItemWithPresentation(action2, TargetPresentation.builder(action2.getText()).icon(action2.getIcon()).presentation())));
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(allElements);
        Ref usageView = new Ref();
        builder2.setNamerForFiltering(item -> {
            if (item.getItem() instanceof AdditionalAction) {
                return ((AdditionalAction)item.getItem()).getText();
            }
            return item.getPresentation().getPresentableText();
        }).setTitle(title);
        if (this.useEditorFont()) {
            builder2.setFont(EditorUtil.getEditorFont());
        }
        builder2.setRenderer((ListCellRenderer)new RoundedCellRenderer((ListCellRenderer)new GotoTargetRenderer(o -> ((ItemWithPresentation)o).getPresentation()))).setItemsChosenCallback(selectedElements -> {
            for (ItemWithPresentation element : selectedElements) {
                if (element.getItem() instanceof AdditionalAction) {
                    ((AdditionalAction)element.getItem()).execute();
                    continue;
                }
                GotoTargetHandler.navigate(project2, element, navigatable -> this.navigateToElement((Navigatable)navigatable));
            }
        }).withHintUpdateSupply().setMovable(true).setCancelCallback(() -> {
            BackgroundUpdaterTaskBase<ItemWithPresentation> task2 = gotoData.listUpdaterTask;
            if (task2 != null) {
                task2.cancelTask();
            }
            return true;
        }).setCouldPin(popup1 -> {
            usageView.set(FindUtil.showInUsageView(gotoData.source, gotoData.targets, this.getFindUsagesTitle(gotoData.source, name, gotoData.targets.length), gotoData.source.getProject()));
            popup1.cancel();
            return false;
        }).setAdText(this.getAdText(gotoData.source, targets2.length));
        JBPopup popup2 = builder2.createPopup();
        JScrollPane jScrollPane = pane = builder2 instanceof PopupChooserBuilder ? ((PopupChooserBuilder)builder2).getScrollPane() : null;
        if (pane != null) {
            if (!ExperimentalUI.isNewUI()) {
                pane.setBorder(null);
            }
            pane.setViewportBorder(null);
        }
        if (gotoData.listUpdaterTask != null) {
            Alarm alarm = new Alarm((Disposable)popup2);
            alarm.addRequest(() -> {
                if (!editor2.isDisposed()) {
                    showPopup2.accept(popup2);
                }
            }, 300);
            gotoData.listUpdaterTask.init(popup2, (GenericListComponentUpdater<ItemWithPresentation>)builder2.getBackgroundUpdater(), usageView);
            ProgressManager.getInstance().run(gotoData.listUpdaterTask);
        } else {
            showPopup2.accept((JBPopup)popup2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            popup2.closeOk(null);
        }
    }

    public static void navigate(@NotNull Project project2, ItemWithPresentation element, Consumer<Navigatable> navigator) {
        if (project2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(8);
        }
        Navigatable nav = element.getItem() instanceof Navigatable ? (Navigatable)element.getItem() : (Navigatable)ActionUtil.underModalProgress((Project)project2, (String)CodeInsightBundle.message("progress.title.preparing.navigation", new Object[0]), () -> {
            Object psiElement = ((SmartPsiElementPointer)element.getItem()).getElement();
            return psiElement == null ? null : EditSourceUtil.getDescriptor(psiElement);
        });
        try {
            if (nav != null && nav.canNavigate()) {
                navigator.accept(nav);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance(project2).showDumbModeNotification(CodeInsightBundle.message("notification.navigation.is.not.available.while.indexing", new Object[0]));
        }
    }

    @NotNull
    protected Comparator<ItemWithPresentation> createComparator(@NotNull GotoData gotoData) {
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(9);
        }
        Comparator<ItemWithPresentation> comparator = Comparator.comparing(gotoData::getComparingObject);
        if (comparator == null) {
            GotoTargetHandler.$$$reportNull$$$0(10);
        }
        return comparator;
    }

    public static List<ItemWithPresentation> computePresentationInBackground(@NotNull Project project2, PsiElement @NotNull [] targets2, boolean hasDifferentNames) {
        if (project2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(11);
        }
        if (targets2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(12);
        }
        SmartPointerManager manager = SmartPointerManager.getInstance(project2);
        return (List)ActionUtil.underModalProgress((Project)project2, (String)CodeInsightBundle.message("progress.title.preparing.result", new Object[0]), () -> ContainerUtil.map(targets2, element -> new ItemWithPresentation(manager.createSmartPsiElementPointer(element), GotoTargetHandler.computePresentation(element, hasDifferentNames))));
    }

    @NotNull
    public static TargetPresentation computePresentation(@NotNull PsiElement element, boolean hasDifferentNames) {
        TargetPresentation presentation2;
        if (element == null) {
            GotoTargetHandler.$$$reportNull$$$0(13);
        }
        if ((presentation2 = GotoTargetPresentationProvider.getTargetPresentationFromProviders(element, hasDifferentNames)) != null) {
            TargetPresentation targetPresentation2 = presentation2;
            if (targetPresentation2 == null) {
                GotoTargetHandler.$$$reportNull$$$0(14);
            }
            return targetPresentation2;
        }
        TargetPresentation renderer = GotoTargetHandler.getTargetPresentationFromRenderers(element, hasDifferentNames);
        if (renderer != null) {
            TargetPresentation targetPresentation3 = renderer;
            if (targetPresentation3 == null) {
                GotoTargetHandler.$$$reportNull$$$0(15);
            }
            return targetPresentation3;
        }
        TargetPresentation targetPresentation4 = ourDefaultTargetElementRenderer.computePresentation(element);
        if (targetPresentation4 == null) {
            GotoTargetHandler.$$$reportNull$$$0(16);
        }
        return targetPresentation4;
    }

    @Nullable
    private static TargetPresentation getTargetPresentationFromRenderers(@NotNull PsiElement element, boolean hasDifferentNames) {
        if (element == null) {
            GotoTargetHandler.$$$reportNull$$$0(17);
        }
        GotoData dummyData = new GotoData(element, PsiElement.EMPTY_ARRAY, Collections.emptyList());
        dummyData.hasDifferentNames = hasDifferentNames;
        PsiElementListCellRenderer renderer = GotoTargetHandler.createRenderer(dummyData, element);
        return renderer == null ? null : renderer.computePresentation(element);
    }

    @Deprecated
    public static PsiElementListCellRenderer createRenderer(@NotNull GotoData gotoData, @NotNull PsiElement eachTarget) {
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(18);
        }
        if (eachTarget == null) {
            GotoTargetHandler.$$$reportNull$$$0(19);
        }
        for (GotoTargetRendererProvider eachProvider : GotoTargetRendererProvider.EP_NAME.getExtensionList()) {
            PsiElementListCellRenderer renderer = eachProvider.getRenderer(eachTarget, gotoData);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    protected boolean navigateToElement(PsiElement target2) {
        Navigatable descriptor2;
        Navigatable navigatable = descriptor2 = target2 instanceof Navigatable ? (Navigatable)((Object)target2) : EditSourceUtil.getDescriptor(target2);
        if (descriptor2 != null && descriptor2.canNavigate()) {
            this.navigateToElement(descriptor2);
            return true;
        }
        return false;
    }

    protected void navigateToElement(@NotNull Navigatable descriptor2) {
        if (descriptor2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(20);
        }
        descriptor2.navigate(true);
    }

    protected boolean shouldSortTargets() {
        return true;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    @NlsContexts.PopupTitle
    protected String getChooserTitle(PsiElement sourceElement, String name, int length) {
        LOG.warn("Please override getChooserTitle(PsiElement, String, int, boolean) instead");
        return "";
    }

    @NotNull
    @NlsContexts.PopupTitle
    protected String getChooserTitle(@NotNull PsiElement sourceElement, @Nullable String name, int length, boolean finished) {
        if (sourceElement == null) {
            GotoTargetHandler.$$$reportNull$$$0(21);
        }
        String string2 = this.getChooserTitle(sourceElement, name, length);
        if (string2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.TabTitle
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            GotoTargetHandler.$$$reportNull$$$0(23);
        }
        String string2 = this.getChooserTitle(sourceElement, name, length, true);
        if (string2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(24);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.HintText
    protected abstract String getNotFoundMessage(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    @NlsContexts.PopupAdvertisement
    protected String getAdText(PsiElement source, int length) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 15, 16, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showPopup";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/GotoTargetHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachTarget";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/GotoTargetHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createComparator";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 24: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computePresentationInBackground";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPresentationFromRenderers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "navigateToElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 14, 15, 16, 22, 24 -> new IllegalStateException(string2);
        };
    }

    public static class GotoData {
        @NotNull
        public final PsiElement source;
        public PsiElement[] targets;
        public final List<AdditionalAction> additionalActions;
        public boolean isCanceled;
        private boolean hasDifferentNames;
        public BackgroundUpdaterTaskBase<ItemWithPresentation> listUpdaterTask;
        protected final Set<String> myNames;
        private List<ItemWithPresentation> myItems;

        public GotoData(@NotNull PsiElement source, PsiElement @NotNull [] targets2, @NotNull List<AdditionalAction> additionalActions) {
            if (source == null) {
                GotoData.$$$reportNull$$$0(0);
            }
            if (additionalActions == null) {
                GotoData.$$$reportNull$$$0(1);
            }
            if (targets2 == null) {
                GotoData.$$$reportNull$$$0(2);
            }
            this.source = source;
            this.targets = targets2;
            this.additionalActions = additionalActions;
            this.myNames = new HashSet<String>();
            for (PsiElement target2 : targets2) {
                if (!(target2 instanceof PsiNamedElement)) continue;
                this.myNames.add(((PsiNamedElement)target2).getName());
                if (this.myNames.size() > 1) break;
            }
            this.hasDifferentNames = this.myNames.size() > 1;
        }

        public boolean hasDifferentNames() {
            return this.hasDifferentNames;
        }

        public ItemWithPresentation addTarget(PsiElement element) {
            if (ArrayUtil.find(this.targets, element) > -1) {
                return null;
            }
            if (!this.hasDifferentNames && element instanceof PsiNamedElement) {
                String name = ReadAction.compute(() -> ((PsiNamedElement)element).getName());
                this.myNames.add(name);
                boolean bl = this.hasDifferentNames = this.myNames.size() > 1;
                if (this.hasDifferentNames) {
                    for (ItemWithPresentation item : this.myItems) {
                        if (!(item.getItem() instanceof Pointer)) continue;
                        ReadAction.run(() -> {
                            Object o = ((Pointer)item.getItem()).dereference();
                            if (o instanceof PsiElement) {
                                item.setPresentation(GotoTargetHandler.computePresentation((PsiElement)o, this.hasDifferentNames));
                            }
                        });
                    }
                }
            }
            this.targets = ArrayUtil.append(this.targets, element);
            return GotoData.initPresentation(element, this.hasDifferentNames);
        }

        private static ItemWithPresentation initPresentation(PsiElement target2, boolean hasDifferentNames) {
            Pointer pointer = ReadAction.compute(() -> SmartPointerManager.createPointer(target2));
            TargetPresentation presentation2 = ReadAction.compute(() -> GotoTargetHandler.computePresentation(target2, hasDifferentNames));
            return new ItemWithPresentation(pointer, presentation2);
        }

        @NotNull
        public String getComparingObject(ItemWithPresentation value) {
            TargetPresentation presentation2 = value.getPresentation();
            String string2 = Stream.of(presentation2.getPresentableText(), presentation2.getContainerText(), presentation2.getLocationText()).filter(Objects::nonNull).collect(Collectors.joining(" "));
            if (string2 == null) {
                GotoData.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @VisibleForTesting
        public void initPresentations() {
            this.myItems = GotoTargetHandler.computePresentationInBackground(this.source.getProject(), this.targets, this.hasDifferentNames);
        }

        public List<ItemWithPresentation> getItems() {
            return this.myItems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalActions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparingObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    public static interface AdditionalAction {
        @NlsActions.ActionText
        @NotNull
        public String getText();

        public Icon getIcon();

        public void execute();
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            String name;
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                return name;
            }
            PsiFile file2 = element.getContainingFile();
            if (file2 == null) {
                PsiUtilCore.ensureValid(element);
                LOG.error("No file for " + element.getClass());
                return element.toString();
            }
            return file2.getName();
        }

        protected String getContainerText(PsiElement element, String name) {
            if (element instanceof NavigationItem) {
                ItemPresentation presentation2 = ((NavigationItem)((Object)element)).getPresentation();
                return presentation2 != null ? presentation2.getLocationString() : null;
            }
            return null;
        }
    }
}

