/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.Nullable;

public class ImplementationSearcher {
    public PsiElement @Nullable [] searchImplementations(Editor editor2, PsiElement element, int offset2) {
        TargetElementUtil targetElementUtil = TargetElementUtil.getInstance();
        boolean onRef = ReadAction.compute(() -> targetElementUtil.findTargetElement(editor2, ImplementationSearcher.getFlags() & 0xFFFFFFF6, offset2) == null);
        return this.searchImplementations(element, editor2, onRef && ReadAction.compute(() -> element == null || targetElementUtil.includeSelfInGotoImplementation(element)) != false, onRef);
    }

    public PsiElement @Nullable [] searchImplementations(PsiElement element, Editor editor2, boolean includeSelfAlways, boolean includeSelfIfNoOthers) {
        if (element == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] elements = this.searchDefinitions(element, editor2);
        if (elements == null) {
            return null;
        }
        if (elements.length > 0) {
            return this.filterElements(element, includeSelfAlways ? ArrayUtil.prepend(element, elements) : elements);
        }
        if (includeSelfAlways || includeSelfIfNoOthers) {
            return new PsiElement[]{element};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected static SearchScope getSearchScope(PsiElement element, Editor editor2) {
        try {
            return ReadAction.compute(() -> TargetElementUtil.getInstance().getSearchScope(editor2, element));
        }
        catch (PsiInvalidElementAccessException e) {
            throw new ProcessCanceledException(e);
        }
    }

    protected PsiElement @Nullable(value="For the case the search has been cancelled") [] searchDefinitions(PsiElement element, Editor editor2) {
        Ref result2 = Ref.create();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> result2.set(this.search(element, editor2).toArray((PsiElement[])PsiElement.EMPTY_ARRAY)), ImplementationSearcher.getSearchingForImplementations(), true, element.getProject())) {
            return null;
        }
        return (PsiElement[])result2.get();
    }

    protected Query<PsiElement> search(PsiElement element, Editor editor2) {
        return DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)ImplementationSearcher.getSearchScope(element, editor2), (boolean)this.isSearchDeep());
    }

    protected boolean isSearchDeep() {
        return true;
    }

    protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
        return targetElements;
    }

    public static int getFlags() {
        return TargetElementUtil.getInstance().getDefinitionSearchFlags();
    }

    @NlsContexts.ProgressTitle
    public static String getSearchingForImplementations() {
        return CodeInsightBundle.message("searching.for.implementations", new Object[0]);
    }

    public static abstract class BackgroundableImplementationSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(PsiElement element, Editor editor2) {
            CommonProcessors.CollectProcessor<PsiElement> processor = new CommonProcessors.CollectProcessor<PsiElement>(){

                @Override
                public boolean process(PsiElement element) {
                    this.processElement(element);
                    return super.process(element);
                }
            };
            this.search(element, editor2).forEach((Processor<PsiElement>)processor);
            return processor.toArray(PsiElement.EMPTY_ARRAY);
        }

        protected abstract void processElement(PsiElement var1);
    }

    public static class FirstImplementationsSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(final PsiElement element, final Editor editor2) {
            PsiElement[] psiElementArray;
            if (this.canShowPopupWithOneItem(element)) {
                return new PsiElement[]{element};
            }
            final PsiElementProcessor.FindElement collectProcessor = new PsiElementProcessor.FindElement();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    this.search(element, editor2).forEach((Processor<PsiElement>)new PsiElementProcessorAdapter<PsiElement>((PsiElementProcessor)collectProcessor){

                        @Override
                        public boolean processInReadAction(PsiElement element) {
                            return !this.accept(element) || super.processInReadAction(element);
                        }
                    });
                }
            }, FirstImplementationsSearcher.getSearchingForImplementations(), true, element.getProject())) {
                return null;
            }
            Object foundElement = collectProcessor.getFoundElement();
            if (foundElement != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = foundElement;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }

        protected boolean canShowPopupWithOneItem(PsiElement element) {
            return this.accept(element);
        }

        protected boolean accept(PsiElement element) {
            return true;
        }
    }
}

