/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.Processor;
import com.intellij.util.TextWithIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtil {
    private static final ExtensionPointName<GotoRelatedProvider> GO_TO_EP_NAME = new ExtensionPointName("com.intellij.gotoRelatedProvider");

    private NavigationUtil() {
    }

    @NotNull
    public static JBPopup getPsiElementPopup(PsiElement @NotNull [] elements, @NlsContexts.PopupTitle String title) {
        if (elements == null) {
            NavigationUtil.$$$reportNull$$$0(0);
        }
        return NavigationUtil.getPsiElementPopup(elements, new DefaultPsiElementCellRenderer(), title);
    }

    @NotNull
    public static JBPopup getPsiElementPopup(PsiElement @NotNull [] elements, @NotNull PsiElementListCellRenderer<? super PsiElement> renderer, @NlsContexts.PopupTitle String title) {
        if (renderer == null) {
            NavigationUtil.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            NavigationUtil.$$$reportNull$$$0(2);
        }
        return NavigationUtil.getPsiElementPopup((PsiElement[])elements, renderer, (String)title, (T element) -> {
            Navigatable descriptor2 = EditSourceUtil.getDescriptor(element);
            if (descriptor2 != null && descriptor2.canNavigate()) {
                descriptor2.navigate(true);
            }
            return true;
        });
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(T @NotNull [] elements, @NotNull PsiElementListCellRenderer<? super T> renderer, @NlsContexts.PopupTitle String title, @NotNull PsiElementProcessor<? super T> processor) {
        if (renderer == null) {
            NavigationUtil.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            NavigationUtil.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            NavigationUtil.$$$reportNull$$$0(5);
        }
        return NavigationUtil.getPsiElementPopup(elements, renderer, (String)title, processor, null);
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(T @NotNull [] elements, @NotNull PsiElementListCellRenderer<? super T> renderer, @Nullable @NlsContexts.PopupTitle String title, @NotNull PsiElementProcessor<? super T> processor, @Nullable T initialSelection) {
        if (renderer == null) {
            NavigationUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            NavigationUtil.$$$reportNull$$$0(7);
        }
        if (elements == null) {
            NavigationUtil.$$$reportNull$$$0(8);
        }
        assert (elements.length > 0) : "Attempted to show a navigation popup with zero elements";
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(List.of(elements)).setRenderer(renderer).setFont(EditorUtil.getEditorFont()).withHintUpdateSupply();
        if (initialSelection != null) {
            builder2.setSelectedValue(initialSelection, true);
        }
        if (title != null) {
            builder2.setTitle(title);
        }
        renderer.installSpeedSearch(builder2, true);
        JBPopup popup2 = builder2.setItemsChosenCallback(selectedValues -> {
            for (PsiElement element : selectedValues) {
                if (element == null) continue;
                processor.execute(element);
            }
        }).createPopup();
        if (builder2 instanceof PopupChooserBuilder) {
            JScrollPane pane = ((PopupChooserBuilder)builder2).getScrollPane();
            pane.setBorder(null);
            pane.setViewportBorder(null);
        }
        NavigationUtil.hidePopupIfDumbModeStarts(popup2, elements[0].getProject());
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            NavigationUtil.$$$reportNull$$$0(9);
        }
        return jBPopup;
    }

    public static void hidePopupIfDumbModeStarts(final @NotNull JBPopup popup2, @NotNull Project project2) {
        if (popup2 == null) {
            NavigationUtil.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            NavigationUtil.$$$reportNull$$$0(11);
        }
        if (!DumbService.isDumb(project2)) {
            project2.getMessageBus().connect((Disposable)popup2).subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

                @Override
                public void enteredDumbMode() {
                    popup2.cancel();
                }
            });
        }
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt) {
        if (elt == null) {
            NavigationUtil.$$$reportNull$$$0(12);
        }
        return NavigationUtil.activateFileWithPsiElement(elt, true);
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt, boolean searchForOpen) {
        if (elt == null) {
            NavigationUtil.$$$reportNull$$$0(13);
        }
        return NavigationUtil.openFileWithPsiElement(elt, searchForOpen, true);
    }

    public static boolean openFileWithPsiElement(PsiElement element, boolean searchForOpen, boolean requestFocus) {
        VirtualFile virtualFile2;
        boolean openAsNative = false;
        if (element instanceof PsiFile && (virtualFile2 = ((PsiFile)element).getVirtualFile()) != null) {
            FileType type = virtualFile2.getFileType();
            boolean bl = openAsNative = type instanceof INativeFileType || type instanceof UnknownFileType;
        }
        if (searchForOpen) {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        } else {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, true);
        }
        Ref resultRef = new Ref();
        boolean openAsNativeFinal = openAsNative;
        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
            if (openAsNativeFinal || !NavigationUtil.activatePsiElementIfOpen(element, searchForOpen, requestFocus)) {
                NavigationItem navigationItem = (NavigationItem)((Object)element);
                if (navigationItem.canNavigate()) {
                    navigationItem.navigate(requestFocus);
                    resultRef.set(Boolean.TRUE);
                } else {
                    resultRef.set(Boolean.FALSE);
                }
            }
        }, "", null);
        if (!resultRef.isNull()) {
            return (Boolean)resultRef.get();
        }
        element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        return false;
    }

    private static boolean activatePsiElementIfOpen(@NotNull PsiElement elt, boolean searchForOpen, boolean requestFocus) {
        FileEditor[] editors2;
        TextRange range;
        if (elt == null) {
            NavigationUtil.$$$reportNull$$$0(14);
        }
        if (!elt.isValid()) {
            return false;
        }
        PsiFile file2 = (elt = elt.getNavigationElement()).getContainingFile();
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (!EditorHistoryManager.getInstance((Project)elt.getProject()).hasBeenOpen(vFile)) {
            return false;
        }
        FileEditorManager fem = FileEditorManager.getInstance(elt.getProject());
        boolean wasAlreadyOpen = fem.isFileOpen(vFile);
        if (!wasAlreadyOpen) {
            fem.openFile(vFile, requestFocus, searchForOpen);
        }
        if ((range = elt.getTextRange()) == null) {
            return false;
        }
        for (FileEditor editor2 : editors2 = fem.getEditors(vFile)) {
            Editor text2;
            int offset2;
            if (!(editor2 instanceof TextEditor) || !range.containsOffset(offset2 = (text2 = ((TextEditor)editor2).getEditor()).getCaretModel().getOffset())) continue;
            if (wasAlreadyOpen) {
                fem.openFile(vFile, requestFocus, searchForOpen);
            }
            return true;
        }
        return false;
    }

    public static TextAttributes patchAttributesColor(TextAttributes attributes, @NotNull TextRange range, @NotNull Editor editor2) {
        if (range == null) {
            NavigationUtil.$$$reportNull$$$0(15);
        }
        if (editor2 == null) {
            NavigationUtil.$$$reportNull$$$0(16);
        }
        if (attributes.getForegroundColor() == null && attributes.getEffectColor() == null) {
            return attributes;
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)editor2.getProject(), (boolean)false);
        if (model2 != null && !((MarkupModelEx)model2).processRangeHighlightersOverlappingWith(range.getStartOffset(), range.getEndOffset(), highlighter -> {
            TextAttributes textAttributes;
            if (highlighter.isValid() && highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE && (textAttributes = highlighter.getTextAttributes(editor2.getColorsScheme())) != null) {
                Color color = textAttributes.getBackgroundColor();
                return color == null || color.getBlue() <= 128 || color.getRed() >= 128 || color.getGreen() >= 128;
            }
            return true;
        })) {
            TextAttributes clone = attributes.clone();
            clone.setForegroundColor(Color.orange);
            clone.setEffectColor(Color.orange);
            return clone;
        }
        return attributes;
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items2, @NlsContexts.PopupTitle String title) {
        return NavigationUtil.getRelatedItemsPopup(items2, title, false);
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items2, @NlsContexts.PopupTitle String title, boolean showContainingModules) {
        ArrayList<Object> elements = new ArrayList<Object>(items2.size());
        HashMap<PsiElement, GotoRelatedItem> itemsMap = new HashMap<PsiElement, GotoRelatedItem>();
        for (GotoRelatedItem gotoRelatedItem : items2) {
            if (gotoRelatedItem.getElement() != null) {
                if (itemsMap.putIfAbsent(gotoRelatedItem.getElement(), gotoRelatedItem) != null) continue;
                elements.add(gotoRelatedItem.getElement());
                continue;
            }
            elements.add(gotoRelatedItem);
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, itemsMap, title, showContainingModules, element -> {
            if (element instanceof PsiElement) {
                ((GotoRelatedItem)itemsMap.get(element)).navigate();
            } else {
                ((GotoRelatedItem)element).navigate();
            }
            return true;
        });
        if (jBPopup == null) {
            NavigationUtil.$$$reportNull$$$0(17);
        }
        return jBPopup;
    }

    private static JBPopup getPsiElementPopup(final List<Object> elements, final Map<PsiElement, GotoRelatedItem> itemsMap, @NlsContexts.PopupTitle String title, final boolean showContainingModules, final Processor<Object> processor) {
        final Ref<Boolean> hasMnemonic = Ref.create(false);
        final DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){

            @Override
            public String getElementText(PsiElement element) {
                String customName = ((GotoRelatedItem)itemsMap.get(element)).getCustomName();
                return customName != null ? customName : super.getElementText(element);
            }

            @Override
            protected Icon getIcon(PsiElement element) {
                Icon customIcon = ((GotoRelatedItem)itemsMap.get(element)).getCustomIcon();
                return customIcon != null ? customIcon : super.getIcon(element);
            }

            @Override
            public String getContainerText(PsiElement element, String name) {
                String customContainerName = ((GotoRelatedItem)itemsMap.get(element)).getCustomContainerName();
                if (customContainerName != null) {
                    return customContainerName;
                }
                PsiFile file2 = element.getContainingFile();
                return file2 != null && !this.getElementText(element).equals(file2.getName()) ? "(" + file2.getName() + ")" : null;
            }

            @Override
            @Nullable
            protected TextWithIcon getItemLocation(Object value) {
                return showContainingModules ? super.getItemLocation(value) : null;
            }

            @Override
            protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, int index2, boolean selected, boolean hasFocus) {
                GotoRelatedItem item = (GotoRelatedItem)value;
                Color color = list2.getForeground();
                SimpleTextAttributes nameAttributes = new SimpleTextAttributes(0, color);
                String name = item.getCustomName();
                if (name == null) {
                    return false;
                }
                renderer.append(name, nameAttributes);
                renderer.setIcon(item.getCustomIcon());
                String containerName = item.getCustomContainerName();
                if (containerName != null) {
                    renderer.append(" " + containerName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                return true;
            }

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                Component psiComponent = super.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
                if (!((Boolean)hasMnemonic.get()).booleanValue() || !(psiComponent instanceof JPanel)) {
                    return psiComponent;
                }
                JPanel component2 = (JPanel)psiComponent;
                JPanel panelWithMnemonic = new JPanel(new BorderLayout());
                int mnemonic = NavigationUtil.getMnemonic(value, itemsMap);
                JLabel label2 = new JLabel("");
                if (mnemonic != -1) {
                    label2.setText(mnemonic + ".");
                    label2.setDisplayedMnemonicIndex(0);
                }
                label2.setPreferredSize(new JLabel("8.").getPreferredSize());
                JComponent leftRenderer2 = (JComponent)component2.getComponents()[0];
                component2.remove(leftRenderer2);
                panelWithMnemonic.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
                panelWithMnemonic.setBackground(leftRenderer2.getBackground());
                label2.setBackground(leftRenderer2.getBackground());
                panelWithMnemonic.add((Component)label2, "West");
                panelWithMnemonic.add((Component)leftRenderer2, "Center");
                component2.add(panelWithMnemonic);
                return component2;
            }
        };
        ListPopupImpl popup2 = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<Object>(title, elements){
            final Map<Object, ListSeparator> separators;
            {
                super(arg0, arg1);
                this.separators = new HashMap<Object, ListSeparator>();
                String current = null;
                boolean hasTitle = false;
                for (Object element : elements) {
                    GotoRelatedItem item = element instanceof GotoRelatedItem ? (GotoRelatedItem)element : (GotoRelatedItem)itemsMap.get(element);
                    if (item == null || Objects.equals(current, item.getGroup())) continue;
                    current = item.getGroup();
                    this.separators.put(element, new ListSeparator(hasTitle && Strings.isEmpty(current) ? CodeInsightBundle.message("goto.related.items.separator.other", new Object[0]) : current));
                    if (hasTitle || Strings.isEmpty(current)) continue;
                    hasTitle = true;
                }
                if (!hasTitle) {
                    this.separators.remove(elements.get(0));
                }
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public String getIndexedString(Object value) {
                if (value instanceof GotoRelatedItem) {
                    return ((GotoRelatedItem)value).getCustomName();
                }
                PsiElement element = (PsiElement)value;
                if (!element.isValid()) {
                    return "INVALID";
                }
                return renderer.getElementText(element) + " " + renderer.getContainerText(element, (String)null);
            }

            public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
                processor.process(selectedValue);
                return super.onChosen(selectedValue, finalChoice);
            }

            @Nullable
            public ListSeparator getSeparatorAbove(Object value) {
                return this.separators.get(value);
            }
        }){};
        popup2.getList().setCellRenderer(new PopupListElementRenderer<Object>(popup2){

            public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                Component component2 = renderer.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
                if (this.myDescriptor.hasSeparatorAboveOf(value)) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.add(component2, "Center");
                    SeparatorWithText sep = new SeparatorWithText(){

                        protected void paintComponent(Graphics g) {
                            g.setColor(new JBColor(Color.WHITE, JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()));
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paintComponent(g);
                        }
                    };
                    sep.setCaption(this.myDescriptor.getCaptionAboveOf(value));
                    panel2.add((Component)sep, "North");
                    return panel2;
                }
                return component2;
            }
        });
        popup2.setMinimumSize(new Dimension(200, -1));
        for (Object item : elements) {
            int mnemonic = NavigationUtil.getMnemonic(item, itemsMap);
            if (mnemonic == -1) continue;
            Action action2 = NavigationUtil.createNumberAction(mnemonic, popup2, itemsMap, processor);
            popup2.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke(String.valueOf(mnemonic)), action2);
            popup2.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke("NUMPAD" + mnemonic), action2);
            hasMnemonic.set(true);
        }
        return popup2;
    }

    private static Action createNumberAction(final int mnemonic, final ListPopupImpl listPopup, final Map<PsiElement, GotoRelatedItem> itemsMap, final Processor<Object> processor) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Object item : listPopup.getListStep().getValues()) {
                    if (NavigationUtil.getMnemonic(item, itemsMap) != mnemonic) continue;
                    listPopup.setFinalRunnable(() -> processor.process(item));
                    listPopup.closeOk(null);
                }
            }
        };
    }

    private static int getMnemonic(Object item, Map<PsiElement, GotoRelatedItem> itemsMap) {
        return (item instanceof GotoRelatedItem ? (GotoRelatedItem)item : itemsMap.get((PsiElement)item)).getMnemonic();
    }

    @NotNull
    public static List<GotoRelatedItem> collectRelatedItems(@NotNull PsiElement contextElement, @Nullable DataContext dataContext2) {
        if (contextElement == null) {
            NavigationUtil.$$$reportNull$$$0(18);
        }
        LinkedHashSet items2 = new LinkedHashSet();
        GO_TO_EP_NAME.forEachExtensionSafe(provider2 -> {
            items2.addAll(provider2.getItems(contextElement));
            if (dataContext2 != null) {
                items2.addAll(provider2.getItems(dataContext2));
            }
        });
        GotoRelatedItem[] result2 = items2.toArray(new GotoRelatedItem[0]);
        Arrays.sort(result2, (i1, i2) -> {
            String o1 = i1.getGroup();
            String o2 = i2.getGroup();
            return Strings.isEmpty(o1) ? 1 : (Strings.isEmpty(o2) ? -1 : o1.compareTo(o2));
        });
        List<GotoRelatedItem> list2 = Arrays.asList(result2);
        if (list2 == null) {
            NavigationUtil.$$$reportNull$$$0(19);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementPopup";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedItemsPopup";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRelatedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementPopup";
                break;
            }
            case 9: 
            case 17: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hidePopupIfDumbModeStarts";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "activateFileWithPsiElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "activatePsiElementIfOpen";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "patchAttributesColor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectRelatedItems";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 17, 19 -> new IllegalStateException(string2);
        };
    }
}

