/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.DefaultModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.intellij.util.TextWithIcon;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u000b*\u00020\u0013H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0013H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"CONTAINER_PATTERN", "Ljava/util/regex/Pattern;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "fileLocation", "Lcom/intellij/util/TextWithIcon;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "presentationError", "", "element", "Lcom/intellij/psi/PsiElement;", "targetPresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "itemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getColoredAttributes", "getContainerText", "", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/codeInsight/navigation/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Pattern CONTAINER_PATTERN;

    @ApiStatus.Internal
    @NotNull
    public static final TargetPresentation targetPresentation(@NotNull ItemPresentation itemPresentation) {
        Intrinsics.checkNotNullParameter((Object)itemPresentation, (String)"itemPresentation");
        String string2 = itemPresentation.getPresentableText();
        if (string2 == null) {
            string2 = "";
        }
        TargetPresentation targetPresentation2 = TargetPresentation.Companion.builder(string2).icon(itemPresentation.getIcon(false)).presentableTextAttributes(UtilKt.getColoredAttributes(itemPresentation)).containerText(UtilKt.getContainerText(itemPresentation)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation2, (String)"TargetPresentation\n    .\u2026xt())\n    .presentation()");
        return targetPresentation2;
    }

    private static final TextAttributes getColoredAttributes(ItemPresentation $this$getColoredAttributes) {
        ColoredItemPresentation coloredPresentation = $this$getColoredAttributes instanceof ColoredItemPresentation ? (ColoredItemPresentation)$this$getColoredAttributes : null;
        Object object = coloredPresentation;
        if (object == null || (object = object.getTextAttributesKey()) == null) {
            return null;
        }
        Object textAttributesKey = object;
        return EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes((TextAttributesKey)textAttributesKey);
    }

    @Nls
    private static final String getContainerText(ItemPresentation $this$getContainerText) {
        String string2 = $this$getContainerText.getLocationString();
        if (string2 == null) {
            return null;
        }
        String locationString = string2;
        Matcher matcher = CONTAINER_PATTERN.matcher(locationString);
        return matcher.matches() ? matcher.group(2) : locationString;
    }

    @ApiStatus.Internal
    @NotNull
    public static final TargetPresentation targetPresentation(@NotNull PsiElement element) {
        TextAttributes textAttributes;
        Color color;
        TargetPresentationBuilder targetPresentationBuilder;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        Project project3 = project2;
        PsiFile psiFile = element.getContainingFile();
        VirtualFile file2 = psiFile != null ? psiFile.getVirtualFile() : null;
        NavigationItem navigationItem = element instanceof NavigationItem ? (NavigationItem)((Object)element) : null;
        ItemPresentation itemPresentation = navigationItem != null ? navigationItem.getPresentation() : null;
        Object object3 = itemPresentation;
        if (object3 == null || (object3 = object3.getPresentableText()) == null) {
            PsiNamedElement psiNamedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
            object3 = psiNamedElement != null ? psiNamedElement.getName() : null;
            if (object3 == null) {
                object3 = element.getText();
            }
        }
        if ((object2 = object3) == null) {
            boolean bl = false;
            UtilKt.presentationError(element);
            object = ((Object)element).toString();
        } else {
            object = object2;
        }
        Object presentableText2 = object;
        TextWithIcon moduleTextWithIcon = PsiElementListCellRenderer.getModuleTextWithIcon(element);
        TargetPresentationBuilder targetPresentationBuilder2 = TargetPresentation.Companion.builder((String)presentableText2);
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            targetPresentationBuilder = targetPresentationBuilder2;
            boolean bl = false;
            color = VfsPresentationUtil.getFileBackgroundColor((Project)project3, (VirtualFile)file2);
            targetPresentationBuilder2 = targetPresentationBuilder;
        } else {
            color = null;
        }
        ItemPresentation itemPresentation2 = itemPresentation;
        TargetPresentationBuilder targetPresentationBuilder3 = targetPresentationBuilder2.backgroundColor(color).icon(element.getIcon(3)).presentableTextAttributes(itemPresentation2 != null ? UtilKt.getColoredAttributes(itemPresentation2) : null);
        ItemPresentation itemPresentation3 = itemPresentation;
        String string2 = itemPresentation3 != null ? UtilKt.getContainerText(itemPresentation3) : null;
        VirtualFile virtualFile4 = file2;
        if (virtualFile4 != null) {
            VirtualFile it = virtualFile4;
            String string3 = string2;
            targetPresentationBuilder = targetPresentationBuilder3;
            boolean bl = false;
            TextAttributes textAttributes2 = UtilKt.fileStatusAttributes(project3, file2);
            targetPresentationBuilder3 = targetPresentationBuilder;
            string2 = string3;
            textAttributes = textAttributes2;
        } else {
            textAttributes = null;
        }
        TextWithIcon textWithIcon = moduleTextWithIcon;
        TextWithIcon textWithIcon2 = moduleTextWithIcon;
        TargetPresentation targetPresentation2 = targetPresentationBuilder3.containerText(string2, textAttributes).locationText(textWithIcon != null ? textWithIcon.getText() : null, textWithIcon2 != null ? textWithIcon2.getIcon() : null).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation2, (String)"TargetPresentation\n    .\u2026icon)\n    .presentation()");
        return targetPresentation2;
    }

    private static final void presentationError(PsiElement element) {
        PomTargetPsiElement pomTargetPsiElement = element instanceof PomTargetPsiElement ? (PomTargetPsiElement)element : null;
        Object object = pomTargetPsiElement != null ? pomTargetPsiElement.getTarget() : null;
        if (object == null) {
            object = element;
        }
        PomTarget instance2 = object;
        Class<?> clazz = instance2.getClass();
        LOG.error(PluginException.createByClass(clazz.getName() + " cannot be presented", null, clazz));
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TextAttributes fileStatusAttributes(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(file2);
        Color fileColor = fileStatus != null ? fileStatus.getColor() : null;
        boolean hasProblem = WolfTheProblemSolver.getInstance(project2).isProblemFile(file2);
        return hasProblem ? new TextAttributes(fileColor, null, JBColor.red, EffectType.WAVE_UNDERSCORE, 0) : (fileColor != null ? new TextAttributes(fileColor, null, null, null, 0) : null);
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TextWithIcon fileLocation(@NotNull Project project2, @NotNull VirtualFile file2) {
        Module module2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        return fileIndex.isInLibrary(file2) ? new DefaultModuleRendererFactory().libraryLocation(project2, fileIndex, file2) : ((module2 = ModuleUtilCore.findModuleForFile(file2, project2)) != null ? DefaultModuleRendererFactory.projectLocation(file2, module2, fileIndex) : null);
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.codeInsight.navigation");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#com.intell\u2026.codeInsight.navigation\")");
        LOG = logger;
        Pattern pattern = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"(\\\\(in |\\\\()?([^)]*)(\\\\))?\")");
        CONTAINER_PATTERN = pattern;
    }
}

