/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.impl.CommonKt;
import com.intellij.codeInsight.navigation.impl.NavigationRequestor;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.impl.DirectoryNavigationRequest;
import com.intellij.navigation.impl.RawNavigationRequest;
import com.intellij.navigation.impl.SourceNavigationRequest;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.EDT;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\u0014"}, d2={"isKeywordUnderCaret", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "isUnderDoubleClick", "navigateRequest", "", "request", "Lcom/intellij/navigation/NavigationRequest;", "navigateRequestLazy", "requestor", "Lcom/intellij/codeInsight/navigation/impl/NavigationRequestor;", "navigateToLookupItem", "notifyNowhereToGo", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
public final class IdeKt {
    public static final boolean navigateToLookupItem(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Lookup activeLookup = LookupManager.getInstance(project2).getActiveLookup();
        if (activeLookup == null) {
            return false;
        }
        LookupElement currentItem = activeLookup.getCurrentItem();
        IdeKt.navigateRequestLazy(project2, () -> IdeKt.navigateToLookupItem$lambda$0(currentItem));
        return true;
    }

    public static final void navigateRequestLazy(@NotNull Project project2, @NotNull NavigationRequestor requestor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        EDT.assertIsEdt();
        NavigationRequest request2 = (NavigationRequest)ActionUtil.underModalProgress((Project)project2, (String)ActionsBundle.actionText((String)"GotoDeclarationOnly"), () -> IdeKt.navigateRequestLazy$lambda$1(requestor));
        if (request2 != null) {
            IdeKt.navigateRequest(project2, request2);
        }
    }

    public static final void navigateRequest(@NotNull Project project2, @NotNull NavigationRequest request2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        EDT.assertIsEdt();
        IdeDocumentHistory.getInstance((Project)project2).includeCurrentCommandAsNavigation();
        NavigationRequest navigationRequest2 = request2;
        if (navigationRequest2 instanceof SourceNavigationRequest) {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project2, ((SourceNavigationRequest)request2).getFile(), ((SourceNavigationRequest)request2).getOffset());
            if (UISettings.Companion.getInstance().getOpenInPreviewTabIfPossible() && Registry.is("editor.preview.tab.navigation")) {
                openFileDescriptor.setUsePreviewTab(true);
            }
            openFileDescriptor.navigate(true);
        } else if (navigationRequest2 instanceof DirectoryNavigationRequest) {
            PsiNavigationSupport.getInstance().navigateToDirectory(((DirectoryNavigationRequest)request2).getDirectory(), true);
        } else if (navigationRequest2 instanceof RawNavigationRequest) {
            ((RawNavigationRequest)request2).getNavigatable().navigate(true);
        } else {
            throw new IllegalStateException(("unsupported request " + request2.getClass().getName()).toString());
        }
    }

    public static final void notifyNowhereToGo(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (Registry.is("ide.gtd.show.error") && !IdeKt.isUnderDoubleClick() && !IdeKt.isKeywordUnderCaret(project2, file2, offset2)) {
            HintManager.getInstance().showInformationHint(editor2, CodeInsightBundle.message("declaration.navigation.nowhere.to.go", new Object[0]));
        }
    }

    private static final boolean isUnderDoubleClick() {
        AWTEvent event = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
        return event instanceof MouseEvent && ((MouseEvent)event).getClickCount() == 2;
    }

    private static final boolean isKeywordUnderCaret(Project project2, PsiFile file2, int offset2) {
        PsiElement psiElement = file2.findElementAt(offset2);
        if (psiElement == null) {
            return false;
        }
        PsiElement elementAtCaret = psiElement;
        NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage(elementAtCaret.getLanguage());
        Intrinsics.checkNotNullExpressionValue((Object)namesValidator, (String)"INSTANCE.forLanguage(elementAtCaret.language)");
        NamesValidator namesValidator2 = namesValidator;
        return namesValidator2.isKeyword(elementAtCaret.getText(), project2);
    }

    private static final NavigationRequest navigateToLookupItem$lambda$0(LookupElement $currentItem) {
        Navigatable navigatable;
        PsiElement psiElement = TargetElementUtil.targetElementFromLookupElement($currentItem);
        return psiElement != null && (navigatable = CommonKt.gtdTargetNavigatable(psiElement)) != null ? navigatable.navigationRequest() : null;
    }

    private static final NavigationRequest navigateRequestLazy$lambda$1(NavigationRequestor $requestor) {
        Intrinsics.checkNotNullParameter((Object)$requestor, (String)"$requestor");
        return $requestor.navigationRequest();
    }
}

