/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.impl;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.codeInsight.navigation.impl.PsiFileNavigationTarget;
import com.intellij.model.Pointer;
import com.intellij.navigation.NavigationRequest;
import com.intellij.navigation.NavigationTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.TextWithIcon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/navigation/impl/PsiFileNavigationTarget;", "Lcom/intellij/navigation/NavigationTarget;", "psiFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "createPointer", "Lcom/intellij/model/Pointer;", "navigationRequest", "Lcom/intellij/navigation/NavigationRequest;", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "intellij.platform.lang.impl"})
public final class PsiFileNavigationTarget
implements NavigationTarget {
    @NotNull
    private final PsiFile psiFile;

    public PsiFileNavigationTarget(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
    }

    @Override
    @NotNull
    public Pointer<? extends NavigationTarget> createPointer() {
        Pointer<PsiFileNavigationTarget> pointer = Pointer.delegatingPointer((Pointer)UtilsKt.createSmartPointer((PsiElement)this.psiFile), arg_0 -> PsiFileNavigationTarget.createPointer$lambda$0(createPointer.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(pointer, (String)"delegatingPointer(\n    p\u2026iFileNavigationTarget\n  )");
        return pointer;
    }

    @Override
    @NotNull
    public TargetPresentation presentation() {
        UserDataHolder userDataHolder;
        Project project2 = this.psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        Project project3 = project2;
        String string2 = this.psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiFile.name");
        TargetPresentationBuilder targetPresentationBuilder = TargetPresentation.Companion.builder(string2).icon(this.psiFile.getIcon(0)).containerText((userDataHolder = this.psiFile.getParent()) != null && (userDataHolder = userDataHolder.getVirtualFile()) != null ? ((VirtualFile)userDataHolder).getPresentableUrl() : null);
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder, (String)"TargetPresentation\n     \u2026tualFile?.presentableUrl)");
        TargetPresentationBuilder builder2 = targetPresentationBuilder;
        VirtualFile virtualFile2 = this.psiFile.getVirtualFile();
        if (virtualFile2 == null) {
            TargetPresentation targetPresentation2 = builder2.presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation2, (String)"builder.presentation()");
            return targetPresentation2;
        }
        VirtualFile file2 = virtualFile2;
        TargetPresentationBuilder targetPresentationBuilder2 = builder2.backgroundColor(VfsPresentationUtil.getFileBackgroundColor((Project)project3, (VirtualFile)file2)).presentableTextAttributes(UtilKt.fileStatusAttributes(project3, file2));
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder2, (String)"builder\n      .backgroun\u2026ttributes(project, file))");
        builder2 = targetPresentationBuilder2;
        TextWithIcon textWithIcon = UtilKt.fileLocation(project3, file2);
        if (textWithIcon == null) {
            TargetPresentation targetPresentation3 = builder2.presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation3, (String)"builder.presentation()");
            return targetPresentation3;
        }
        TextWithIcon locationAndIcon = textWithIcon;
        TargetPresentationBuilder targetPresentationBuilder3 = builder2.locationText(locationAndIcon.getText(), locationAndIcon.getIcon());
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder3, (String)"builder.locationText(loc\u2026xt, locationAndIcon.icon)");
        builder2 = targetPresentationBuilder3;
        TargetPresentation targetPresentation4 = builder2.presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation4, (String)"builder.presentation()");
        return targetPresentation4;
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        return this.psiFile.navigationRequest();
    }

    private static final PsiFileNavigationTarget createPointer$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiFileNavigationTarget)$tmp0.invoke(p0);
    }
}

