/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.impl;

import com.intellij.codeInsight.navigation.BaseCtrlMouseInfo;
import com.intellij.codeInsight.navigation.CtrlMouseDocInfo;
import com.intellij.codeInsight.navigation.impl.DocKt;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Unused in v2 implementation")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/navigation/impl/SingleSymbolCtrlMouseInfo;", "Lcom/intellij/codeInsight/navigation/BaseCtrlMouseInfo;", "symbol", "Lcom/intellij/model/Symbol;", "elementAtOffset", "Lcom/intellij/psi/PsiElement;", "textRanges", "", "Lcom/intellij/openapi/util/TextRange;", "declared", "", "(Lcom/intellij/model/Symbol;Lcom/intellij/psi/PsiElement;Ljava/util/List;Z)V", "pointer", "Lcom/intellij/model/Pointer;", "getSymbol", "()Lcom/intellij/model/Symbol;", "getDocInfo", "Lcom/intellij/codeInsight/navigation/CtrlMouseDocInfo;", "isNavigatable", "isValid", "intellij.platform.lang.impl"})
public final class SingleSymbolCtrlMouseInfo
extends BaseCtrlMouseInfo {
    @NotNull
    private final PsiElement elementAtOffset;
    private final boolean declared;
    @NotNull
    private final Pointer<? extends Symbol> pointer;

    public SingleSymbolCtrlMouseInfo(@NotNull Symbol symbol, @NotNull PsiElement elementAtOffset, @NotNull List<? extends TextRange> textRanges, boolean declared) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)elementAtOffset, (String)"elementAtOffset");
        Intrinsics.checkNotNullParameter(textRanges, (String)"textRanges");
        super(textRanges);
        this.elementAtOffset = elementAtOffset;
        this.declared = declared;
        Pointer<? extends Symbol> pointer = symbol.createPointer();
        Intrinsics.checkNotNullExpressionValue(pointer, (String)"symbol.createPointer()");
        this.pointer = pointer;
    }

    private final Symbol getSymbol() {
        Symbol symbol = this.pointer.dereference();
        if (symbol == null) {
            boolean bl = false;
            String string2 = "Must not be called on invalid info";
            throw new IllegalArgumentException(string2.toString());
        }
        return symbol;
    }

    @Override
    public boolean isValid() {
        return this.pointer.dereference() != null && this.elementAtOffset.isValid();
    }

    @Override
    public boolean isNavigatable() {
        if (this.declared) {
            return true;
        }
        PsiElement psiElement = PsiSymbolService.getInstance().extractElementFromSymbol(this.getSymbol());
        if (psiElement == null) {
            return true;
        }
        PsiElement psi = psiElement;
        return psi != this.elementAtOffset && psi != this.elementAtOffset.getParent();
    }

    @Override
    @NotNull
    public CtrlMouseDocInfo getDocInfo() {
        return DocKt.docInfo(this.getSymbol(), this.elementAtOffset);
    }
}

