/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.impl;

import com.intellij.codeInsight.navigation.impl.PsiElementNavigationTarget;
import com.intellij.codeInsight.navigation.impl.PsiFileNavigationTarget;
import com.intellij.codeInsight.navigation.impl.TargetPresentationBuilderImpl;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.NavigationTarget;
import com.intellij.navigation.SymbolNavigationProvider;
import com.intellij.navigation.SymbolNavigationService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\r\u001a\u00020\u000e2\u000b\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/navigation/impl/SymbolNavigationServiceImpl;", "Lcom/intellij/navigation/SymbolNavigationService;", "()V", "ourExtension", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/navigation/SymbolNavigationProvider;", "getNavigationTargets", "", "Lcom/intellij/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "presentationBuilder", "Lcom/intellij/platform/backend/presentation/TargetPresentationBuilder;", "presentableText", "", "Lorg/jetbrains/annotations/Nls;", "psiElementNavigationTarget", "element", "Lcom/intellij/psi/PsiElement;", "psiFileNavigationTarget", "file", "Lcom/intellij/psi/PsiFile;", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class SymbolNavigationServiceImpl
implements SymbolNavigationService {
    @NotNull
    private final ClassExtension<SymbolNavigationProvider> ourExtension = new ClassExtension("com.intellij.symbolNavigation");

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project2, @NotNull Symbol symbol) {
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        SmartList result2 = new SmartList();
        for (Object t : this.ourExtension.forKey(symbol.getClass())) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"ourExtension.forKey(symbol.javaClass)");
            SymbolNavigationProvider provider2 = (SymbolNavigationProvider)t;
            Collection collection = result2;
            Collection<? extends NavigationTarget> collection2 = provider2.getNavigationTargets(project2, symbol);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"provider.getNavigationTargets(project, symbol)");
            CollectionsKt.addAll((Collection)collection, (Iterable)collection2);
        }
        if (symbol instanceof NavigatableSymbol) {
            Collection collection = result2;
            Collection<? extends NavigationTarget> collection3 = ((NavigatableSymbol)symbol).getNavigationTargets(project2);
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"symbol.getNavigationTargets(project)");
            CollectionsKt.addAll((Collection)collection, (Iterable)collection3);
        }
        if (symbol instanceof NavigationTarget) {
            ((Collection)result2).add(symbol);
        }
        if ((element = PsiSymbolService.getInstance().extractElementFromSymbol(symbol)) != null) {
            ((Collection)result2).add(new PsiElementNavigationTarget(element));
        }
        return result2;
    }

    @Override
    @NotNull
    public NavigationTarget psiFileNavigationTarget(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new PsiFileNavigationTarget(file2);
    }

    @Override
    @NotNull
    public NavigationTarget psiElementNavigationTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new PsiElementNavigationTarget(element);
    }

    @Override
    @NotNull
    public TargetPresentationBuilder presentationBuilder(@NotNull String presentableText2) {
        Intrinsics.checkNotNullParameter((Object)presentableText2, (String)"presentableText");
        return new TargetPresentationBuilderImpl(null, null, presentableText2, null, null, null, null, null, 251, null);
    }
}

