/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageOrColorPreviewManager
implements Disposable,
EditorMouseMotionListener,
EditorFactoryListener {
    private static final Logger LOG = Logger.getInstance(ImageOrColorPreviewManager.class);
    private static final Key<KeyListener> EDITOR_LISTENER_ADDED = Key.create("previewManagerListenerAdded");
    private final Alarm alarm = new Alarm();
    @Nullable
    private Collection<PsiElement> myElements;

    ImageOrColorPreviewManager() {
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(0);
        }
        this.registerListeners(event.getEditor());
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Editor editor2;
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(1);
        }
        if ((editor2 = event.getEditor()).isOneLineMode()) {
            return;
        }
        KeyListener keyListener = EDITOR_LISTENER_ADDED.get((UserDataHolder)editor2);
        if (keyListener != null) {
            EDITOR_LISTENER_ADDED.set((UserDataHolder)editor2, null);
            editor2.getContentComponent().removeKeyListener(keyListener);
            editor2.removeEditorMouseMotionListener((EditorMouseMotionListener)this);
        }
    }

    private void registerListeners(final Editor editor2) {
        if (editor2.isOneLineMode()) {
            return;
        }
        Project project2 = editor2.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !ImageOrColorPreviewManager.isSupportedFile(psiFile)) {
            return;
        }
        editor2.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PointerInfo pointerInfo;
                if (e.getKeyCode() == 16 && !editor2.isOneLineMode() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location2 = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location2, editor2.getContentComponent());
                    int offset2 = editor2.logicalPositionToOffset(editor2.xyToLogicalPosition(location2));
                    ImageOrColorPreviewManager.this.alarm.cancelAllRequests();
                    ImageOrColorPreviewManager.this.alarm.addRequest((Runnable)new PreviewRequest(editor2, offset2, true), 100);
                }
            }
        };
        editor2.getContentComponent().addKeyListener(keyListener);
        EDITOR_LISTENER_ADDED.set((UserDataHolder)editor2, keyListener);
    }

    private static boolean isSupportedFile(PsiFile psiFile) {
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            for (ElementPreviewProvider provider2 : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                if (!provider2.isSupportedFile(file2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> getPsiElementsAt(Editor editor2, int offset2) {
        Document document;
        if (editor2.isDisposed()) {
            Set<PsiElement> set2 = Collections.emptySet();
            if (set2 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(2);
            }
            return set2;
        }
        Project project2 = editor2.getProject();
        if (project2 == null || project2.isDisposed()) {
            Set<PsiElement> set3 = Collections.emptySet();
            if (set3 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(3);
            }
            return set3;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        PsiFile psiFile = documentManager.getPsiFile(document = editor2.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !psiFile.isValid()) {
            Set<PsiElement> set4 = Collections.emptySet();
            if (set4 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(4);
            }
            return set4;
        }
        Set<PsiElement> elements = ContainerUtil.createWeakSet();
        if (documentManager.isCommitted(document)) {
            ContainerUtil.addIfNotNull(elements, InjectedLanguageUtil.findElementAtNoCommit(psiFile, offset2));
        }
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            ContainerUtil.addIfNotNull(elements, file2.findElementAt(offset2));
        }
        Set<PsiElement> set5 = elements;
        if (set5 == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(5);
        }
        return set5;
    }

    @Override
    public void dispose() {
        this.alarm.cancelAllRequests();
        this.myElements = null;
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        Editor editor2;
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(6);
        }
        if ((editor2 = event.getEditor()).isOneLineMode()) {
            return;
        }
        this.alarm.cancelAllRequests();
        Collection<PsiElement> elements = this.myElements;
        if (elements == null && event.getMouseEvent().isShiftDown()) {
            this.alarm.addRequest((Runnable)new PreviewRequest(editor2, event.getOffset(), false), 100);
        } else if (elements != null && !SlowOperations.allowSlowOperations(() -> ImageOrColorPreviewManager.getPsiElementsAt(editor2, event.getOffset()).equals(elements)).booleanValue()) {
            this.myElements = null;
            for (ElementPreviewProvider provider2 : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                try {
                    for (PsiElement element : elements) {
                        provider2.hide(element, editor2);
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementsAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editorCreated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "editorReleased";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5 -> new IllegalStateException(string2);
        };
    }

    private final class PreviewRequest
    implements Runnable {
        private final Editor editor;
        private final int offset;
        private final boolean keyTriggered;

        PreviewRequest(Editor editor2, int offset2, boolean keyTriggered) {
            this.editor = editor2;
            this.offset = offset2;
            this.keyTriggered = keyTriggered;
        }

        @Override
        public void run() {
            SlowOperations.allowSlowOperations(() -> this.doRun());
        }

        private void doRun() {
            Collection<PsiElement> elements = ImageOrColorPreviewManager.getPsiElementsAt(this.editor, this.offset);
            if (elements.equals(ImageOrColorPreviewManager.this.myElements)) {
                return;
            }
            for (PsiElement element : elements) {
                if (element == null || !element.isValid()) {
                    return;
                }
                if (PsiDocumentManager.getInstance(element.getProject()).isUncommited(this.editor.getDocument()) || DumbService.getInstance(element.getProject()).isDumb()) {
                    return;
                }
                for (ElementPreviewProvider provider2 : ElementPreviewProvider.EP_NAME.getExtensions()) {
                    if (!provider2.isSupportedFile(element.getContainingFile())) continue;
                    try {
                        provider2.show(element, this.editor, this.editor.offsetToXY(this.offset), this.keyTriggered);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error(e);
                    }
                }
            }
            ImageOrColorPreviewManager.this.myElements = elements;
        }
    }
}

