/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTemplateCallback {
    private static final Logger LOGGER = Logger.getInstance(CustomTemplateCallback.class);
    private final TemplateManager myTemplateManager;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    private final int myOffset;
    @NotNull
    private final Project myProject;
    private final boolean myInInjectedFragment;
    protected Set<TemplateContextType> myApplicableContextTypes;

    public CustomTemplateCallback(@NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            CustomTemplateCallback.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            CustomTemplateCallback.$$$reportNull$$$0(1);
        }
        this.myProject = file2.getProject();
        this.myTemplateManager = TemplateManager.getInstance(this.myProject);
        int parentEditorOffset = CustomTemplateCallback.getOffset(editor2);
        PsiElement element = InjectedLanguageManager.getInstance(file2.getProject()).findInjectedElementAt(file2, parentEditorOffset);
        this.myFile = element != null ? element.getContainingFile() : file2;
        this.myInInjectedFragment = InjectedLanguageManager.getInstance(this.myProject).isInjectedFragment(this.myFile);
        this.myEditor = this.myInInjectedFragment ? InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor2, file2, parentEditorOffset) : editor2;
        this.myOffset = this.myInInjectedFragment ? CustomTemplateCallback.getOffset(this.myEditor) : parentEditorOffset;
    }

    public TemplateManager getTemplateManager() {
        return this.myTemplateManager;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            CustomTemplateCallback.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    public PsiElement getContext() {
        return CustomTemplateCallback.getContext(this.myFile, this.getOffset(), this.myInInjectedFragment);
    }

    public int getOffset() {
        return this.myOffset;
    }

    public static int getOffset(@NotNull Editor editor2) {
        SelectionModel selectionModel;
        if (editor2 == null) {
            CustomTemplateCallback.$$$reportNull$$$0(3);
        }
        return (selectionModel = editor2.getSelectionModel()).hasSelection() ? selectionModel.getSelectionStart() : Math.max(editor2.getCaretModel().getOffset() - 1, 0);
    }

    @Nullable
    public TemplateImpl findApplicableTemplate(@NotNull @NlsSafe String key) {
        if (key == null) {
            CustomTemplateCallback.$$$reportNull$$$0(4);
        }
        return ContainerUtil.getFirstItem(this.findApplicableTemplates(key));
    }

    @NotNull
    public List<TemplateImpl> findApplicableTemplates(@NotNull @NlsSafe String key) {
        if (key == null) {
            CustomTemplateCallback.$$$reportNull$$$0(5);
        }
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : CustomTemplateCallback.getMatchingTemplates(key)) {
            if (!this.isAvailableTemplate(candidate)) continue;
            result2.add(candidate);
        }
        ArrayList<TemplateImpl> arrayList = result2;
        if (arrayList == null) {
            CustomTemplateCallback.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private boolean isAvailableTemplate(@NotNull TemplateImpl template) {
        if (template == null) {
            CustomTemplateCallback.$$$reportNull$$$0(7);
        }
        if (this.myApplicableContextTypes == null) {
            this.myApplicableContextTypes = TemplateManagerImpl.getApplicableContextTypes(TemplateActionContext.create(this.myFile, this.myEditor, this.myOffset, this.myOffset, false));
        }
        return !template.isDeactivated() && TemplateManagerImpl.isApplicable(template, this.myApplicableContextTypes);
    }

    public void startTemplate(@NotNull Template template, Map<String, String> predefinedValues, TemplateEditingListener listener2) {
        if (template == null) {
            CustomTemplateCallback.$$$reportNull$$$0(8);
        }
        if (this.myInInjectedFragment) {
            template.setToReformat(false);
        }
        this.myTemplateManager.startTemplate(this.myEditor, template, false, predefinedValues, listener2);
    }

    @NotNull
    private static List<TemplateImpl> getMatchingTemplates(@NotNull String templateKey) {
        if (templateKey == null) {
            CustomTemplateCallback.$$$reportNull$$$0(9);
        }
        TemplateSettings settings = TemplateSettings.getInstance();
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : settings.getTemplates(templateKey)) {
            if (template.isDeactivated()) continue;
            candidates.add(template);
        }
        ArrayList<TemplateImpl> arrayList = candidates;
        if (arrayList == null) {
            CustomTemplateCallback.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.myEditor;
        if (editor2 == null) {
            CustomTemplateCallback.$$$reportNull$$$0(11);
        }
        return editor2;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFile.getFileType();
        if (fileType == null) {
            CustomTemplateCallback.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            CustomTemplateCallback.$$$reportNull$$$0(13);
        }
        return project2;
    }

    public void deleteTemplateKey(@NotNull String key) {
        if (key == null) {
            CustomTemplateCallback.$$$reportNull$$$0(14);
        }
        int caretAt = this.myEditor.getCaretModel().getOffset();
        int templateStart = caretAt - key.length();
        this.myEditor.getDocument().deleteString(templateStart, caretAt);
        this.myEditor.getCaretModel().moveToOffset(templateStart);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            CustomTemplateCallback.$$$reportNull$$$0(15);
        }
        return CustomTemplateCallback.getContext(file2, offset2, true);
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file2, int offset2, boolean searchInInjectedFragment) {
        if (file2 == null) {
            CustomTemplateCallback.$$$reportNull$$$0(16);
        }
        PsiElement element = null;
        if (searchInInjectedFragment && !InjectedLanguageManager.getInstance(file2.getProject()).isInjectedFragment(file2)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(file2.getProject());
            Document document = documentManager.getDocument(file2);
            if (document != null && !documentManager.isCommitted(document)) {
                LOGGER.error("Trying to access to injected template context on uncommited document, offset = " + offset2, CoreAttachmentFactory.createAttachment(file2.getVirtualFile()));
            } else {
                element = InjectedLanguageManager.getInstance(file2.getProject()).findInjectedElementAt(file2, offset2);
            }
        }
        if (element == null) {
            element = PsiUtilCore.getElementAtOffset(file2, offset2);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            CustomTemplateCallback.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    public boolean isInInjectedFragment() {
        return this.myInInjectedFragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 10, 11, 12, 13, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/CustomTemplateCallback";
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/CustomTemplateCallback";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findApplicableTemplates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableTemplates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingTemplates";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteTemplateKey";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 10, 11, 12, 13, 17 -> new IllegalStateException(string2);
        };
    }
}

